/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.runtime.protocol;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.message.BPELInternalMessage;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.util.MessageUtil;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Descriptions;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELFactoryImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.message.BPELInternalMessageImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.runtime.BPELMessageMatcher;
import com.ebmwebsourcing.easybpel.model.bpel.tools.Util;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.soa.Endpoint;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageAdapter;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.petalslink.abslayer.service.api.Binding;
import org.petalslink.abslayer.service.api.BindingOperation;
import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.Operation;

public class SOAPAdapter
implements MessageAdapter {
    private Logger log = Logger.getLogger(BPELMessageMatcher.class.getName());
    private final Descriptions desc;
    private Endpoint providerEndpoint;
    private Scope scope = null;
    private static final String REQUEST = "request";
    private static final String RESPONSE = "response";

    public SOAPAdapter(BPELProcess bpeldefinition, Endpoint providerEndpoint, Scope scope) {
        this.desc = bpeldefinition.getImports();
        this.providerEndpoint = providerEndpoint;
        this.scope = scope;
    }

    public SOAPAdapter(BPELProcess bpeldefinition) {
        this.desc = bpeldefinition.getImports();
    }

    @Override
    public void setLog(Logger logger) {
        this.log = logger;
    }

    public InternalMessage<?> adapt(Variable variable) throws CoreException {
        BPELInternalMessage msg = null;
        if (this.providerEndpoint == null) {
            throw new CoreException("Provider Endpoint cannot be null");
        }
        msg = this.format((BPELVariable)variable, this.providerEndpoint);
        return msg;
    }

    private BPELInternalMessage format(BPELVariable<Element> variable, Endpoint providerEndpoint) throws CoreException {
        BPELInternalMessage formattedMessage = null;
        if (variable.getValue() == null || variable.getValue().getContent() == null) {
            MessageUtil.createMessageIfNotExist(variable, this.desc, BPELFactoryImpl.getCore().getMessageFactory());
        }
        formattedMessage = (BPELInternalMessage)variable.getValue();
        this.log.finest("providerEndpoint.getEndpointName() = " + providerEndpoint.getEndpointName());
        this.log.finest("providerEndpoint.getInterfaceName() = " + providerEndpoint.getInterfaceName());
        this.log.finest("providerEndpoint.getServiceName() = " + providerEndpoint.getServiceName());
        this.log.finest("providerEndpoint.getDescription() = " + providerEndpoint.getDescription());
        if (variable.getValue() != null && providerEndpoint.getDescription() != null) {
            Operation op = null;
            Interface itf = this.desc.findInterface(providerEndpoint.getInterfaceName());
            op = itf.getOperation(new QName(itf.getQName().getNamespaceURI(), providerEndpoint.getInvokedOperation()));
            if (op != null) {
                Binding binding = null;
                for (Binding bindingItem : this.desc.getBindings()) {
                    if (bindingItem.getInterface() == null || !bindingItem.getInterface().getQName().equals(itf.getQName())) continue;
                    binding = bindingItem;
                    break;
                }
                if (binding == null) {
                    throw new CoreException("Impossible to find binding corresponding to interface: " + itf.getQName());
                }
                BindingOperation bOp = binding.getOperationByName(op.getName());
                if (bOp != null) {
                    PartnerLink partner;
                    String direction = REQUEST;
                    Map<Endpoint, Map<String, ExternalContext>> contexts = this.scope.getProcess().getExternalContexts();
                    Map<String, ExternalContext> map = contexts.get(providerEndpoint);
                    if (map != null && map.get(op.getName()) != null && (partner = (PartnerLink)this.scope.findEndpointKey(providerEndpoint)) != null && partner.getMyRole() != null) {
                        direction = RESPONSE;
                    }
                    if (bOp.getStyle() == Binding.BindingStyle.DOCUMENT) {
                        this.log.finest("format as document");
                        formattedMessage = this.formatAsDocument((BPELInternalMessage)variable.getValue(), op, direction);
                    } else if (bOp.getStyle() == Binding.BindingStyle.RPC) {
                        this.log.finest("format as rpc");
                        formattedMessage = this.formatAsRpc((BPELInternalMessage)variable.getValue(), bOp, op, direction);
                    }
                }
            }
            formattedMessage.setQName(new QName(((Element)((BPELInternalMessage)variable.getValue()).getContent()).getNamespaceURI(), ((Element)((BPELInternalMessage)variable.getValue()).getContent()).getName()));
        }
        return formattedMessage;
    }

    private BPELInternalMessage formatAsRpc(BPELInternalMessage internalMessage, BindingOperation bOp, Operation op, String direction) throws BPELException {
        BPELInternalMessageImpl formattedMessage = new BPELInternalMessageImpl();
        if (internalMessage != null) {
            formattedMessage.setEndpoint(internalMessage.getEndpoint());
            formattedMessage.setQName(internalMessage.getQName());
            formattedMessage.setService(internalMessage.getService());
            Element elmt = (Element)((Element)internalMessage.getContent()).clone();
            String operationName = bOp.getName();
            if (direction.equals(RESPONSE)) {
                operationName = String.valueOf(operationName) + "Response";
            }
            elmt.setName(operationName);
            String targetNamespace = op.getParentInterface().getParentDescription().getTargetNamespace();
            if (!elmt.getNamespaceURI().equals(targetNamespace)) {
                elmt.setNamespace(Namespace.getNamespace(targetNamespace));
            }
            if (op.getInput().getParts() != null && op.getInput().getParts().length > 0 || op.getInput().getElement() != null) {
                Document doc = new Document(elmt);
                formattedMessage.setContent(doc.getRootElement());
            }
        } else {
            throw new BPELException("Internal message cannot be null.");
        }
        return formattedMessage;
    }

    private BPELInternalMessage formatAsDocument(BPELInternalMessage internalMessage, Operation op, String direction) throws BPELException {
        BPELInternalMessageImpl formattedMessage = new BPELInternalMessageImpl();
        if (internalMessage != null) {
            formattedMessage.setEndpoint(internalMessage.getEndpoint());
            formattedMessage.setQName(internalMessage.getQName());
            formattedMessage.setService(internalMessage.getService());
            Element elmt = null;
            elmt = ((Element)internalMessage.getContent()).getChildren() != null && ((Element)internalMessage.getContent()).getChildren().size() == 1 && (op.getInput().getMessageName().getLocalPart().equals(((Element)internalMessage.getContent()).getName()) || op.getOutput() != null && op.getOutput().getMessageName().getLocalPart().equals(((Element)internalMessage.getContent()).getName())) ? (Element)((Element)((Element)internalMessage.getContent()).getChildren().get(0)).clone() : (Element)((Element)internalMessage.getContent()).clone();
            if (direction.equals(REQUEST) && op.getInput() != null && op.getInput().getParts() != null && op.getInput().getParts().length > 0 && op.getInput().getParts()[0].getType() != null && op.getInput().getParts()[0].getQName() != null) {
                elmt.setName(op.getInput().getParts()[0].getQName().getLocalPart());
            }
            if (op.getInput().getParts() != null && op.getInput().getParts().length > 0 && op.getInput().getParts()[0].getType() != null) {
                elmt.setNamespace(null);
            }
            if (op.getInput().getParts() != null && op.getInput().getParts().length > 0 || op.getInput().getElement() != null) {
                Document doc = new Document(elmt);
                formattedMessage.setContent(doc.getRootElement());
            }
        } else {
            throw new BPELException("Internal message cannot be null.");
        }
        return formattedMessage;
    }

    public InternalMessage<?> formatFault(InternalMessage<?> internalMessage) {
        BPELInternalMessageImpl res = new BPELInternalMessageImpl();
        res.setContent(Util.getChildElements((Element)internalMessage.getContent()).get(0));
        res.setEndpoint(internalMessage.getEndpoint());
        res.setOperationName(internalMessage.getOperationName());
        res.setQName(internalMessage.getQName());
        res.setService(internalMessage.getService());
        return res;
    }

    public Element getDetails(Element fault) {
        Element details = null;
        details = fault.getChild("detail", Namespace.getNamespace("http://schemas.xmlsoap.org/soap/envelope/"));
        if (details == null) {
            details = fault.getChild("detail");
        }
        if (details == null) {
            details = fault.getChild("Detail", Namespace.getNamespace("http://www.w3.org/2003/05/soap-envelope"));
        }
        if (details == null) {
            details = fault.getChild("Detail");
        }
        return details;
    }

    public static Element createSOAPFault(Element content) {
        Element soapfault = null;
        soapfault = new Element("Fault", Namespace.getNamespace("soap", "http://schemas.xmlsoap.org/soap/envelope/"));
        Document doc = new Document(soapfault);
        Element faultcode = new Element("faultcode");
        faultcode.setText("soap:Server");
        soapfault.addContent(faultcode);
        Element detail = new Element("detail");
        if (content != null) {
            detail.addContent((Element)content.clone());
        }
        soapfault.addContent(detail);
        return doc.getRootElement();
    }
}

