/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.wsdlImports;

import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.util.ScopeUtil;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Descriptions;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Import;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TImport;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import javax.xml.namespace.QName;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.XmlException;
import org.petalslink.abslayer.WSDLVersionConstants;
import org.petalslink.abslayer.service.api.Description;

public class ImportImpl
extends BPELElementImpl<TImport>
implements Import {
    private static final long serialVersionUID = 1L;
    public Description description = null;
    public Schema schema = null;

    public ImportImpl(TImport model, BPELElement parent) {
        super(Constants._Import_QNAME, model, parent);
        try {
            BPELProcess process = ScopeUtil.getProcess(this);
            URI baseUri = process.getDocumentBaseURI();
            if (this.getImportType() != null) {
                if (this.getImportType().toString().equals(WSDLVersionConstants.WSDL11.value().toString())) {
                    if (this.getLocation() != null) {
                        URL location = null;
                        if (baseUri.isAbsolute()) {
                            String path = String.valueOf(baseUri.toString().substring(0, baseUri.toString().lastIndexOf("/") + 1)) + this.getLocation().toString();
                            URI locationUri = URI.create(path);
                            location = locationUri.toURL();
                        } else {
                            location = new File(String.valueOf(baseUri.normalize().toString()) + this.getLocation()).toURI().toURL();
                        }
                        this.description = Descriptions.readDescription11(location);
                    }
                } else if (this.getImportType().toString().equals(WSDLVersionConstants.WSDL20.value().toString())) {
                    if (this.getLocation() != null) {
                        URL location = null;
                        if (baseUri.isAbsolute()) {
                            String path = String.valueOf(baseUri.toString().substring(0, baseUri.toString().lastIndexOf("/") + 1)) + this.getLocation().toString();
                            URI locationUri = URI.create(path);
                            location = locationUri.toURL();
                        } else {
                            location = new File(String.valueOf(baseUri.normalize().toString()) + this.getLocation()).toURI().toURL();
                        }
                        this.description = Descriptions.readDescription20(location);
                    }
                } else if (this.getImportType().toString().equals("http://www.w3.org/2001/XMLSchema") && this.getLocation() != null) {
                    URL location = null;
                    if (baseUri.isAbsolute()) {
                        String path = String.valueOf(baseUri.toString().substring(0, baseUri.toString().lastIndexOf("/") + 1)) + this.getLocation().toString();
                        URI locationUri = URI.create(path);
                        location = locationUri.toURL();
                    } else {
                        location = new File(String.valueOf(baseUri.normalize().toString()) + this.getLocation()).toURI().toURL();
                    }
                    this.schema = Descriptions.readSchema(location);
                }
            }
        }
        catch (SchemaException e) {
            BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this, new BPELException("Error to import file: " + this.getLocation() + " => " + e.getMessage(), e)));
        }
        catch (MalformedURLException e) {
            BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this, new BPELException("Error to import file: " + this.getLocation() + " => " + e.getMessage(), e)));
        }
        catch (XmlObjectReadException e) {
            BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this, new BPELException("Error to import file: " + this.getLocation() + " => " + e.getMessage(), e)));
        }
    }

    @Override
    public Description getDescription() {
        return this.description;
    }

    @Override
    public URI getImportType() {
        URI res = null;
        if (((TImport)this.model).getImportType() != null) {
            res = URI.create(((TImport)this.model).getImportType());
        }
        return res;
    }

    @Override
    public void setImportType(URI uri) {
        ((TImport)this.model).setImportType(uri.toString());
    }

    @Override
    public URI getLocation() {
        URI res = null;
        if (((TImport)this.model).getLocation() != null) {
            res = URI.create(((TImport)this.model).getLocation());
        }
        return res;
    }

    @Override
    public void setLocation(URI uri) {
        ((TImport)this.model).setLocation(uri.toString());
    }

    @Override
    public URI getNamespace() {
        URI res = null;
        if (((TImport)this.model).getNamespace() != null) {
            res = URI.create(((TImport)this.model).getNamespace());
        }
        return res;
    }

    public void setDescription(Description description) {
        this.description = description;
    }

    public void setSchema2(Schema schema) {
        this.schema = schema;
    }

    @Override
    public void setNamespace(URI uri) {
        ((TImport)this.model).setNamespace(uri.toString());
    }

    @Override
    public Schema getSchema2() {
        return this.schema;
    }

    @Override
    public Map<QName, String> getOtherAttributes() throws XmlException {
        return ((TImport)this.model).getOtherAttributes();
    }
}

