/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;
import org.ow2.easywsdl.schema.api.extensions.NamespaceMapperImpl;

public class XPathAnalyzer {
    private static Logger log = Logger.getLogger(XPathAnalyzer.class.getName());

    public Element evaluate(String xpathExpression, Element source, NamespaceMapperImpl context) throws BPELException {
        ArrayList<String> xpathExpressions = new ArrayList<String>();
        xpathExpressions.add(xpathExpression);
        return this.evaluate(xpathExpressions, source, context);
    }

    public Element evaluate(List<String> xpathExpressions, Element source, NamespaceMapperImpl context) throws BPELException {
        Element target = null;
        try {
            for (String xpathExpression : xpathExpressions) {
                Object res;
                XPath xpathExpr = XPath.newInstance(xpathExpression);
                for (Map.Entry<String, String> entry : context.getNamespaces().entrySet()) {
                    if (entry.getKey().equals("xml")) continue;
                    xpathExpr.addNamespace(entry.getKey(), entry.getValue());
                }
                if (source.getDocument() == null) {
                    new Document(source);
                }
                if ((res = xpathExpr.selectSingleNode(source)) instanceof Document) {
                    target = ((Document)res).getRootElement();
                    log.finest("this xpath expression " + xpathExpression + " matchs with: \n " + new XMLOutputter(Format.getPrettyFormat()).outputString(source));
                    break;
                }
                if (!(res instanceof Element)) continue;
                target = (Element)res;
                log.finest("this xpath expression " + xpathExpression + " matchs with: \n " + new XMLOutputter(Format.getPrettyFormat()).outputString(source));
                break;
            }
            if (target == null) {
                log.finest("namespace used: " + context.getNamespaces());
                log.finest("No xpath expressions " + xpathExpressions + " match with: \n" + new XMLOutputter(Format.getPrettyFormat()).outputString(source));
            }
        }
        catch (JDOMException e) {
            throw new BPELException(e);
        }
        return target;
    }
}

