/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpmn.bpmn2bpel;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.with.WithName;
import com.ebmwebsourcing.easybox.api.with.WithOtherAttributes;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Assign;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Empty;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Flow;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.If;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Invoke;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Pick;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Receive;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Reply;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Scope;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Sequence;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Wait;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.While;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4pick.OnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELElementVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TAssign;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TBooleanExpr;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TCopy;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TDeadlineExpr;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TDurationExpr;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TEmpty;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TExit;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TExpression;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TFlow;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TFrom;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TIf;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TImport;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TInvoke;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TOnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TPick;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TProcess;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TReceive;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TReply;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TScope;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TSequence;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TTo;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TWait;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TWhile;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELFactoryImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELProcessImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.AssignImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.EmptyImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ExitImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.FlowImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.IfImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.InvokeImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.PickImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ReceiveImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ReplyImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ScopeImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.SequenceImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.WaitImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.WhileImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign.CopyImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign.FromImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign.ToImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4pick.OnMessageImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.wsdlImports.ImportImpl;
import com.ebmwebsourcing.easybpel.xpath.exp.api.XPathExpressionException;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.BPELBooleanExpressionImpl;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.BPELDeadLineExpressionImpl;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.BPELDurationExpressionImpl;
import com.ebmwebsourcing.easybpmn.bpmn20.api.BPMNException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.DefinitionsHelper;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Activity;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Assignment;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.BaseElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.CallActivity;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.CatchEvent;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Collaboration;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.DataAssociation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.DataInputAssociation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.DataOutputAssociation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.EndEvent;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Event;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.EventBasedGateway;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.EventDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ExclusiveGateway;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.FlowElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.FlowNode;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Gateway;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Import;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Interface;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.IntermediateCatchEvent;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ItemDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Message;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.MessageEventDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Operation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ParallelGateway;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Participant;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.PartnerRole;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Process;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ReceiveTask;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.SendTask;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.SequenceFlow;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ServiceTask;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.StartEvent;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Task;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.TerminateEventDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ThrowEvent;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.TimerEventDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TSequenceFlow;
import com.ebmwebsourcing.easybpmn.bpmn20.api.with.ItemAwareElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.with.WithFlowElements;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.BPELGeneratorHelper;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.BPELProcessWriterHelper;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.GenerationProperties;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.wsdl.WSDLGenerator;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyplnk20.api.element.PartnerLinkType;
import com.ebmwebsourcing.easyschema10.api.SchemaHelper;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.w3c.dom.Document;

public class BPELGenerator {
    public List<BPELProcess> generate(Definitions def, String path) throws BPMNException {
        return this.generate(def, new GenerationProperties(), path);
    }

    public List<BPELProcess> generate(Definitions def) throws BPMNException {
        System.out.println("***** definitions are: " + def.getId());
        return this.generate(def, new GenerationProperties(), null);
    }

    public List<BPELProcess> generate(Definitions def, GenerationProperties gp, String writingPath) throws BPMNException {
        ArrayList<BPELProcess> res = new ArrayList<BPELProcess>();
        gp.setBPMNDefinitions(def);
        WSDLGenerator wsdlGen = new WSDLGenerator();
        Set<com.ebmwebsourcing.easywsdl11.api.element.Definitions> descs = wsdlGen.generate(def, gp);
        gp.setDescs(descs);
        HashMap schemaImports = new HashMap();
        for (Collaboration c : def.getCollaborations()) {
            for (Participant participant : c.getParticipant()) {
                if (!participant.hasProcessRef()) continue;
                BPELProcess bpel = this.generate(participant, gp);
                res.add(bpel);
                for (com.ebmwebsourcing.easywsdl11.api.element.Definitions defs : descs) {
                    this.addDescriptionImport(bpel, defs);
                }
                schemaImports.put(bpel.getQName(), new HashMap());
                block5: for (QName elt : gp.getElementsToImport()) {
                    List<Element> elts = bpel.getImports().findElementsInAllSchema(elt);
                    if (elts != null && !elts.isEmpty()) continue;
                    for (Import impt : def.getImports()) {
                        com.ebmwebsourcing.easywsdl11.api.element.Definitions wsdlDefs;
                        Schema s;
                        if (impt.isXSDImport() && impt.getNamespace().equals(elt.getNamespaceURI()) && SchemaHelper.findElementByQName(s = impt.getSchema(), elt) != null) {
                            ((Map)schemaImports.get(bpel.getQName())).put(impt.getLocation(), s);
                            this.addSchemaImport(bpel, s, impt.getLocation());
                            continue block5;
                        }
                        if (!impt.isWSDL11Import() || !impt.getNamespace().equals(elt.getNamespaceURI()) || SchemaHelper.findElementByQName(wsdlDefs = impt.getWSDL11Definitions(), elt) == null) continue;
                        ((Map)schemaImports.get(bpel.getQName())).put(impt.getLocation(), wsdlDefs);
                        this.addDescriptionImport(bpel, wsdlDefs);
                        continue block5;
                    }
                }
            }
        }
        if (writingPath != null) {
            try {
                for (com.ebmwebsourcing.easywsdl11.api.element.Definitions defs : descs) {
                    BPELProcessWriterHelper.writeFile(writingPath, defs.getName() + ".wsdl", defs);
                }
                for (BPELProcess bpel : res) {
                    Document doc = BPELFactoryImpl.getInstance().newBPELWriter().getDocument(bpel);
                    BPELProcessWriterHelper.writeFile(writingPath, bpel.getName() + ".bpel", XMLPrettyPrinter.prettyPrint(doc));
                    for (String location : ((Map)schemaImports.get(bpel.getQName())).keySet()) {
                        BPELProcessWriterHelper.writeFile(writingPath, BPELGeneratorHelper.getFileNameFromImportLocation(location), (XmlObject)((Map)schemaImports.get(bpel.getQName())).get(location));
                    }
                }
            }
            catch (Exception e) {
                throw new BPMNException("A problem occured during the process writing.", e);
            }
        }
        return res;
    }

    private BPELProcess generate(Participant participant, GenerationProperties gp) throws BPMNException {
        Process p = DefinitionsHelper.findBPMNObject(gp.getBPMNDefinitions(), participant.getProcessRef(), Process.class);
        String processName = p.hasName() ? p.getName() : p.getId();
        BPELProcessImpl res = new BPELProcessImpl(URI.create(processName), new TProcess(), null, null);
        res.setName(processName);
        res.setTargetNamespace(gp.getBPMNDefinitions().getTargetNamespace());
        gp.setBpelProcess(res);
        this.generatePartnerLinks(participant, gp);
        this.generateVariablesFromMessages(this.getMessagesFromTasks(p.getFlowElementsByClass(Task.class), gp), gp);
        this.generateProcess(res, p, gp);
        return res;
    }

    private void generateVariablesFromMessages(List<Message> msgs, GenerationProperties gp) throws BPMNException {
        for (Message msg : msgs) {
            this.createOrFindVariableFromMessage(msg, gp);
        }
    }

    public void generatePartnerLinks(Participant participant, GenerationProperties gp) {
        String myRole = null;
        block0: for (PartnerRole partnerRole : gp.getBPMNDefinitions().getPartnerRoles()) {
            if (!partnerRole.hasParticipantRef()) continue;
            for (QName participantRef : partnerRole.getParticipantRef()) {
                if (participantRef == null || !participantRef.getLocalPart().equals(participant.getId())) continue;
                myRole = partnerRole.getName();
                break block0;
            }
        }
        for (WithOtherAttributes withOtherAttributes : (PartnerLinkType[])gp.getArtefactDesc().getAnyXmlObjects(PartnerLinkType.class)) {
            if (withOtherAttributes.getRoles() == null || withOtherAttributes.getRoles().length <= 0) continue;
            PartnerLink pl = gp.getBpelProcess().createPartnerLink();
            String role = withOtherAttributes.getRoles()[0].getName();
            pl.setName(withOtherAttributes.getName().replace("PLT", ""));
            if (role.equals(myRole)) {
                pl.setMyRole(role);
            } else {
                pl.setPartnerRole(role);
            }
            pl.setPartnerLinkType(new QName(gp.getArtefactDesc().getTargetNamespace(), withOtherAttributes.getName()));
        }
    }

    private List<Message> getMessagesFromTasks(List<Task> tasks, GenerationProperties gp) throws BPMNException {
        ArrayList<Message> msgs = new ArrayList<Message>();
        for (Task t : tasks) {
            if (t instanceof SendTask) {
                msgs.add(DefinitionsHelper.findBPMNObject(gp.getBPMNDefinitions(), ((SendTask)t).getMessageRef(), Message.class));
                continue;
            }
            if (t instanceof ReceiveTask) {
                msgs.add(DefinitionsHelper.findBPMNObject(gp.getBPMNDefinitions(), ((ReceiveTask)t).getMessageRef(), Message.class));
                continue;
            }
            if (!(t instanceof ServiceTask)) continue;
            Operation op = DefinitionsHelper.findBPMNObject(gp.getBPMNDefinitions(), ((ServiceTask)t).getOperationRef(), Operation.class);
            msgs.add(DefinitionsHelper.findBPMNObject(gp.getBPMNDefinitions(), op.getInMessageRef(), Message.class));
            if (!op.hasOutMessageRef()) continue;
            msgs.add(DefinitionsHelper.findBPMNObject(gp.getBPMNDefinitions(), op.getOutMessageRef(), Message.class));
        }
        return msgs;
    }

    private void generateProcess(BPELProcess bpel, Process bpmn, GenerationProperties gp) throws BPMNException {
        try {
            SequenceImpl seqMain = new SequenceImpl(new TSequence(), bpel);
            seqMain.setName("main");
            bpel.setActivity(seqMain);
            List<FlowNode> starts = this.detectAllStartingNodes(bpmn);
            gp.setLoopers(BPELGeneratorHelper.findLoopDivergers(bpmn, starts));
            if (starts.size() == 1) {
                this.generateActivity(starts.iterator().next(), seqMain, gp);
            } else if (starts.size() > 1) {
                this.generateStartingPick(starts, seqMain, gp);
            }
        }
        catch (BPELException e) {
            throw new BPMNException(e);
        }
    }

    public List<FlowNode> detectAllStartingNodes(WithFlowElements bpmn) {
        ArrayList<FlowNode> l = new ArrayList<FlowNode>();
        for (FlowNode fn : bpmn.getFlowElementsByClass(FlowNode.class)) {
            if (fn instanceof StartEvent) {
                if (!((StartEvent)fn).hasEventDefinition() || ((StartEvent)fn).getEventDefinition().length == 0) {
                    l.addAll(fn.getOutgoingFlowNodes());
                    continue;
                }
                l.add(fn);
                continue;
            }
            if (!fn.getIncomingFlowNodes().isEmpty()) continue;
            l.add(fn);
        }
        return l;
    }

    private com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity generateNextActivity(FlowElement a, BPELElement parent, GenerationProperties gp) throws BPELException, BPMNException {
        System.out.println("************* FlowElement: " + a.getName() + " --- instance of class: " + a.getClass());
        com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity ua = null;
        if (a instanceof Task) {
            Task t = (Task)a;
            System.out.println("************* Taskes: " + t.getName());
            if (t.getOutgoingFlowNodes().size() > 1) {
                Flow f;
                ua = f = this.generateFlow((Activity)a, parent, gp);
            } else if (t.getOutgoingFlowNodes().size() == 1) {
                Sequence seq = this.generateSequence((Activity)a, parent, gp);
                ua = seq;
            }
        } else if (a instanceof Gateway) {
            Gateway g = (Gateway)a;
            System.out.println("************* gateways: " + g.getName());
            if (g.getOutgoingFlowNodes().size() > 1) {
                com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity f = this.generateActivityFromGateway(g, (com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity)parent, gp);
                ua = f;
            } else if (g.getOutgoingFlowNodes().size() == 1) {
                SequenceImpl seq = new SequenceImpl(new TSequence(), parent);
                this.addActivityInParent(seq, parent);
                ua = this.generateActivity(g.getOutgoingFlowNodes().get(0), seq, gp);
            }
        } else if (a instanceof Event) {
            Event e = (Event)a;
            System.out.println("************* events: " + e.getName());
            if (e.getOutgoingFlowNodes().size() != 0) {
                if (e.getOutgoingFlowNodes().size() > 1) {
                    Flow f;
                    ua = f = this.generateFlow((Activity)a, parent, gp);
                } else if (e.getOutgoingFlowNodes().size() == 1) {
                    ua = this.generateActivity(e.getOutgoingFlowNodes().get(0), (com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity)parent, gp);
                }
            }
        }
        return ua;
    }

    private Sequence generateSequence(FlowNode a, BPELElement parent, GenerationProperties gp) throws BPELException, BPMNException {
        Sequence seq = null;
        System.out.println("******* Flow node is: " + a.getName());
        if (parent instanceof Sequence) {
            seq = (Sequence)parent;
        } else {
            seq = new SequenceImpl(new TSequence(), parent);
            this.addActivityInParent(seq, parent);
        }
        this.generateActivity(a.getOutgoingFlowNodes().get(0), seq, gp);
        return seq;
    }

    private Flow generateFlow(Activity a, BPELElement parent, GenerationProperties gp) throws BPELException, BPMNException {
        FlowImpl flow = new FlowImpl(new TFlow(), parent);
        this.addActivityInParent(flow, (com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity)parent);
        for (FlowNode elmt : a.getOutgoingFlowNodes()) {
            this.generateActivity(elmt, flow, gp);
        }
        return flow;
    }

    private com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity generateActivity(FlowElement flowElement, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        if (flowElement instanceof Task) {
            return this.generateActivityFromTask((Task)flowElement, seqOrFlowOrScope, gp);
        }
        if (flowElement instanceof CallActivity) {
            return this.generateScope((CallActivity)flowElement, seqOrFlowOrScope, gp);
        }
        if (flowElement instanceof Gateway) {
            return this.generateActivityFromGateway((Gateway)flowElement, seqOrFlowOrScope, gp);
        }
        if (flowElement instanceof EndEvent) {
            return null;
        }
        if (flowElement instanceof Event) {
            return this.generateActivityFromEvent((Event)flowElement, seqOrFlowOrScope, gp);
        }
        throw new NotImplementedException("Sorry but this element: " + flowElement.getClass() + " cannot be generated into a bpel activity");
    }

    private com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity generateActivityFromEvent(Event a, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity res = null;
        if (a instanceof CatchEvent) {
            EventDefinition[] eds = ((CatchEvent)a).getEventDefinition();
            for (int i = 0; i < eds.length; ++i) {
                if (eds[i] instanceof MessageEventDefinition) {
                    List<FlowNode> outgoing = a.getOutgoingFlowNodes();
                    if (outgoing.size() == 1 && outgoing.get(0) instanceof ReceiveTask) {
                        res = null;
                        continue;
                    }
                    res = this.generateReceiveIntEvent((CatchEvent)a, (MessageEventDefinition)eds[i], seqOrFlowOrScope, gp);
                    continue;
                }
                if (!(eds[i] instanceof TimerEventDefinition)) continue;
                res = this.generateWait(a, (TimerEventDefinition)eds[i], seqOrFlowOrScope, gp);
            }
            this.generateAssign(a.getName(), ((CatchEvent)a).getDataOutputAssociation(), seqOrFlowOrScope, gp);
        } else if (a instanceof ThrowEvent) {
            this.generateAssign(a.getName(), ((ThrowEvent)a).getDataInputAssociation(), seqOrFlowOrScope, gp);
            EventDefinition[] eds = ((ThrowEvent)a).getEventDefinition();
            for (int i = 0; i < eds.length; ++i) {
                if (eds[i] instanceof MessageEventDefinition) {
                    List<FlowNode> incoming = a.getIncomingFlowNodes();
                    if (incoming.size() == 1 && incoming.get(0) instanceof SendTask) {
                        res = null;
                        continue;
                    }
                    res = this.generateSendIntEvent((ThrowEvent)a, (MessageEventDefinition)eds[i], seqOrFlowOrScope, gp);
                    continue;
                }
                if (!(eds[i] instanceof TerminateEventDefinition)) continue;
                ExitImpl exit = new ExitImpl(new TExit(), seqOrFlowOrScope);
                this.addActivityInParent(exit, seqOrFlowOrScope);
            }
        }
        this.generateNextActivity(a, seqOrFlowOrScope, gp);
        return res;
    }

    private Wait generateWait(WithName wn, TimerEventDefinition ed, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException {
        WaitImpl wait = new WaitImpl(new TWait(), seqOrFlowOrScope);
        this.addActivityInParent(wait, seqOrFlowOrScope);
        wait.setName(wn.getName());
        if (ed.hasTimeDate()) {
            BPELDeadLineExpressionImpl exp = new BPELDeadLineExpressionImpl(new TDeadlineExpr(), wait);
            exp.setContent(ed.getTimeDate().getTextContent());
            wait.setUntil(exp);
        } else if (ed.hasTimeDuration()) {
            BPELDurationExpressionImpl exp = new BPELDurationExpressionImpl(new TDurationExpr(), wait);
            exp.setContent(ed.getTimeDuration().getTextContent());
            wait.setFor(exp);
        }
        return wait;
    }

    public Reply generateSendIntEvent(ThrowEvent a, MessageEventDefinition ed, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        return this.generateReply(a.getName(), ed.getOperationRef(), seqOrFlowOrScope, gp);
    }

    public Receive generateReceiveIntEvent(CatchEvent a, MessageEventDefinition ed, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        assert (a != null);
        return this.generateReceive(a.getName(), false, ed.getOperationRef(), seqOrFlowOrScope, gp);
    }

    private com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity generateActivityFromGateway(Gateway gateway, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity res = null;
        if (gateway instanceof ExclusiveGateway) {
            ExclusiveGateway eg = (ExclusiveGateway)gateway;
            if (gp.getAlreadyGeneratedLoops().contains(gateway)) {
                if (gp.getAlreadyGeneratedLoopExit().contains(gateway)) {
                    return null;
                }
                gp.getAlreadyGeneratedLoopExit().add(eg);
                return this.generateActivity(gp.getLoopExit(eg), gp.getCurrentWhileParent(), gp);
            }
            if (gp.isLoopDiverger(eg)) {
                gp.getAlreadyGeneratedLoops().add(eg);
                this.generateWhile(eg, gp.getLoopingFlows(eg), seqOrFlowOrScope, gp);
            } else {
                List<FlowNode> outgoing = eg.getOutgoingFlowNodes();
                res = outgoing.size() == 1 ? this.generateActivity(outgoing.get(0), seqOrFlowOrScope, gp) : this.generateIf(eg, seqOrFlowOrScope, gp);
            }
        } else if (gateway instanceof ParallelGateway) {
            res = this.generateFlow((ParallelGateway)gateway, seqOrFlowOrScope, gp);
        } else if (gateway instanceof EventBasedGateway) {
            if (gp.getAlreadyGeneratedLoops().contains(gateway)) {
                return null;
            }
            if (gp.isLoopDiverger(gateway)) {
                gp.getAlreadyGeneratedLoops().add(gateway);
                return this.generateWhile((EventBasedGateway)gateway, seqOrFlowOrScope, gp);
            }
            res = this.generatePick((EventBasedGateway)gateway, seqOrFlowOrScope, gp);
        } else {
            throw new NotImplementedException("Sorry but this element: " + gateway.getClass() + " cannot be generated into a bpel activity");
        }
        return res;
    }

    private com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity generateStartingPick(Collection<FlowNode> starts, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity parent, GenerationProperties gp) throws BPELException, BPMNException {
        PickImpl pick = new PickImpl(new TPick(), parent);
        this.addActivityInParent(pick, parent);
        for (FlowNode fn : starts) {
            if (fn instanceof IntermediateCatchEvent) {
                EventDefinition ed = ((IntermediateCatchEvent)fn).getEventDefinition()[0];
                if (!(ed instanceof MessageEventDefinition)) continue;
                this.generateOnMessage(fn, ((MessageEventDefinition)ed).getOperationRef(), ((IntermediateCatchEvent)fn).getDataOutputAssociation(), null, pick, gp);
                continue;
            }
            if (fn instanceof ReceiveTask) {
                this.generateOnMessage((ReceiveTask)fn, pick, gp);
                continue;
            }
            if (fn instanceof EventBasedGateway) {
                return this.generatePick((EventBasedGateway)fn, parent, gp);
            }
            throw new BPMNException("A BPEL process should start with intermediate catch events or receive tasks. " + fn.getClass());
        }
        return pick;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity generatePick(EventBasedGateway gateway, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity parent, GenerationProperties gp) throws BPELException, BPMNException {
        PickImpl pick = new PickImpl(new TPick(), parent);
        this.addActivityInParent(pick, parent);
        FlowElement loopExit = null;
        if (gp.isLoopDiverger(gateway)) {
            loopExit = gp.getLoopExit(gateway);
        }
        for (FlowNode fn : gateway.getOutgoingFlowNodes()) {
            OnMessage e = null;
            if (fn instanceof IntermediateCatchEvent) {
                EventDefinition ed = ((IntermediateCatchEvent)fn).getEventDefinition()[0];
                if (!(ed instanceof MessageEventDefinition)) throw new BPMNException("An event based gateway should be connected to intermediate message catching events or to receive tasks.");
                e = this.generateOnMessage(fn, ((MessageEventDefinition)ed).getOperationRef(), ((IntermediateCatchEvent)fn).getDataOutputAssociation(), null, pick, gp);
            } else {
                if (!(fn instanceof ReceiveTask)) throw new BPMNException("An event based gateway should be connected to intermediate message catching events or to receive tasks.");
                e = this.generateOnMessage((ReceiveTask)fn, pick, gp);
            }
            if (loopExit == null || !loopExit.equals(fn)) continue;
            BPELVariable<?> var = this.createOrFindBooleanVariable(gateway, gp);
            AssignImpl assign = new AssignImpl(new TAssign(), e);
            CopyImpl copy = new CopyImpl(new TCopy(), assign);
            FromImpl from = new FromImpl(new TFrom(), copy);
            from.setContent("true");
            ToImpl to = new ToImpl(new TTo(), copy);
            to.setContent("$" + var.getQName().getLocalPart());
            copy.setFrom(from);
            copy.setTo(to);
            assign.addCopy(copy);
            this.addActivityInParent(assign, e);
        }
        return pick;
    }

    private Scope generateScope(CallActivity callActi, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        QName qn = callActi.getCalledElement();
        Process proc = DefinitionsHelper.findBPMNObject(gp.getBPMNDefinitions(), qn, Process.class);
        ScopeImpl scope = new ScopeImpl(new TScope(), seqOrFlowOrScope);
        this.addActivityInParent(scope, seqOrFlowOrScope);
        SequenceImpl seqMain = new SequenceImpl(new TSequence(), scope);
        this.addActivityInParent(seqMain, scope);
        Definitions defs = gp.getBPMNDefinitions();
        gp.setBPMNDefinitions(DefinitionsHelper.getParentDefinitions(proc));
        List<FlowNode> starts = this.detectAllStartingNodes(proc);
        if (starts.size() == 1) {
            this.generateActivity(starts.iterator().next(), seqMain, gp);
        } else if (starts.size() > 1) {
            this.generateStartingPick(starts, seqMain, gp);
        }
        gp.setBPMNDefinitions(defs);
        return scope;
    }

    private While generateWhile(EventBasedGateway ebg, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        BPELBooleanExpressionImpl cond;
        TWhile model = new TWhile();
        WhileImpl while_ = new WhileImpl(model, seqOrFlowOrScope);
        while_.setName(ebg.getName());
        gp.setCurrentWhileParent(seqOrFlowOrScope);
        BPELVariable<?> var = this.createOrFindBooleanVariable(ebg, gp);
        AssignImpl assign = new AssignImpl(new TAssign(), seqOrFlowOrScope);
        CopyImpl copy = new CopyImpl(new TCopy(), assign);
        FromImpl from = new FromImpl(new TFrom(), copy);
        from.setContent("false");
        ToImpl to = new ToImpl(new TTo(), copy);
        to.setContent("$" + var.getQName().getLocalPart());
        copy.setFrom(from);
        copy.setTo(to);
        assign.addCopy(copy);
        this.addActivityInParent(assign, seqOrFlowOrScope);
        TBooleanExpr expr = new TBooleanExpr();
        try {
            cond = new BPELBooleanExpressionImpl((TExpression)expr, while_);
        }
        catch (XPathExpressionException e) {
            throw new BPELException(e);
        }
        String loopCondition = "not($" + var.getQName().getLocalPart() + ")";
        cond.setContent(loopCondition);
        while_.setCondition(cond);
        model.setCondition(expr);
        this.addActivityInParent(while_, seqOrFlowOrScope);
        this.generatePick(ebg, while_, gp);
        return while_;
    }

    private void generateWhile(ExclusiveGateway eg, Set<SequenceFlow> loopingFlows, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        BPELBooleanExpressionImpl cond;
        System.out.println("*************While for : " + eg.getId());
        TWhile model = new TWhile();
        WhileImpl while_ = new WhileImpl(model, seqOrFlowOrScope);
        while_.setName(eg.getName());
        gp.setCurrentWhileParent(seqOrFlowOrScope);
        TBooleanExpr expr = new TBooleanExpr();
        try {
            cond = new BPELBooleanExpressionImpl((TExpression)expr, while_);
        }
        catch (XPathExpressionException e) {
            throw new BPELException(e);
        }
        Process p = DefinitionsHelper.getProcess(eg, gp.getBPMNDefinitions());
        TSequenceFlow nonlooper = null;
        for (SequenceFlow sf : p.getFlowElementsByClass(SequenceFlow.class)) {
            if (!sf.getSourceRef().getId().equals(eg.getId()) || loopingFlows.contains(sf)) continue;
            nonlooper = sf;
            break;
        }
        String loopCondition = "not(" + nonlooper.getConditionExpression().getTextContent() + ")";
        cond.setContent(loopCondition);
        while_.setCondition(cond);
        model.setCondition(expr);
        this.addActivityInParent(while_, seqOrFlowOrScope);
        this.generateWhileInsideIf(eg, loopingFlows, while_, model, gp);
    }

    private void generateWhileInsideIf(ExclusiveGateway eg, Collection<SequenceFlow> loopingFlows, While while_, TWhile model, GenerationProperties gp) throws BPELException, BPMNException {
        TSequence sm = new TSequence();
        SequenceImpl seq = new SequenceImpl(sm, while_);
        while_.setActivity(seq);
        model.setSequence(sm);
        ArrayList<FlowNode> activities = new ArrayList<FlowNode>();
        for (SequenceFlow sf : loopingFlows) {
            activities.add(sf.getTargetRef());
        }
        this.generateIf(activities, seq, eg, gp);
    }

    private Flow getCurrentFlow(BPELElement parent) {
        Flow res = null;
        if (parent != null) {
            res = parent instanceof Flow ? (Flow)parent : this.getCurrentFlow((BPELElement)((Object)((AbstractSchemaElementImpl)((Object)parent)).getParent()));
        }
        return res;
    }

    private If getCurrentIf(BPELElement parent) {
        If res = null;
        if (parent != null) {
            res = parent instanceof If ? (If)parent : this.getCurrentIf((BPELElement)((Object)((AbstractSchemaElementImpl)((Object)parent)).getParent()));
        }
        return res;
    }

    private Flow generateFlow(ParallelGateway gateway, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        FlowImpl flowA = null;
        System.out.println("found gateways: " + gateway.getId());
        List<FlowNode> activities = gateway.getOutgoingFlowNodes();
        if (activities.size() > 0 && gateway.getIncomingFlowNodes().size() == 1) {
            flowA = new FlowImpl(new TFlow(), seqOrFlowOrScope);
            this.addActivityInParent(flowA, seqOrFlowOrScope);
            System.out.println("flow out size = " + activities.size());
            for (FlowNode elmt : activities) {
                SequenceImpl seq = new SequenceImpl(new TSequence(), flowA);
                this.addActivityInParent(seq, flowA);
                this.generateActivity(elmt, seq, gp);
            }
        } else if (!gp.getGatewaysAlreadyGenerated().contains(gateway)) {
            gp.getGatewaysAlreadyGenerated().add(gateway);
            this.generateNextActivity(gateway, (BPELElement)((Object)((BPELElementImpl)((Object)this.getCurrentFlow(seqOrFlowOrScope))).getParent()), gp);
        }
        return flowA;
    }

    private If generateIf(List<FlowNode> activities, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, ExclusiveGateway eg, GenerationProperties gp) throws BPELException, BPMNException {
        IfImpl ifA = new IfImpl(new TIf(), seqOrFlowOrScope);
        this.addActivityInParent(ifA, seqOrFlowOrScope);
        System.out.println("if out size = " + activities.size());
        boolean first = true;
        for (FlowNode elmt : activities) {
            SequenceImpl seq = new SequenceImpl(new TSequence(), ifA);
            this.generateActivity(elmt, seq, gp);
            try {
                SequenceFlow sf;
                BPELBooleanExpressionImpl exp;
                System.out.println("elmt.getId().toString() = " + elmt.getId().toString());
                if (eg.getDefault() != null && eg.getDefault().getTargetRef().getId().toString().equals(elmt.getId().toString())) {
                    exp = new BPELBooleanExpressionImpl((TExpression)new TBooleanExpr(), ifA);
                    ifA.addElseIfActivity(exp, seq);
                    continue;
                }
                if (first) {
                    exp = new BPELBooleanExpressionImpl((TExpression)new TBooleanExpr(), ifA);
                    sf = DefinitionsHelper.getSequenceFlow(DefinitionsHelper.getProcess(elmt, gp.getBPMNDefinitions()), eg.getId(), elmt.getId());
                    exp.setContent(sf.getConditionExpression().getTextContent());
                    ifA.addIfActivity(exp, seq);
                    first = false;
                    continue;
                }
                exp = new BPELBooleanExpressionImpl((TExpression)new TBooleanExpr(), ifA);
                sf = DefinitionsHelper.getSequenceFlow(DefinitionsHelper.getProcess(elmt, gp.getBPMNDefinitions()), eg.getId(), elmt.getId());
                exp.setContent(sf.getConditionExpression().getTextContent());
                ifA.addElseIfActivity(exp, seq);
            }
            catch (XPathExpressionException e) {
                throw new BPELException(e);
            }
        }
        return ifA;
    }

    private If generateIf(ExclusiveGateway gateway, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        System.out.println("found gateways: " + gateway.getId());
        List<FlowNode> activities = gateway.getOutgoingFlowNodes();
        if (activities.size() > 0 && gateway.getIncomingFlowNodes().size() == 1) {
            return this.generateIf(activities, seqOrFlowOrScope, gateway, gp);
        }
        if (!gp.getGatewaysAlreadyGenerated().contains(gateway)) {
            gp.getGatewaysAlreadyGenerated().add(gateway);
            this.generateNextActivity(gateway, (BPELElement)((Object)((BPELElementImpl)((Object)this.getCurrentIf(seqOrFlowOrScope))).getParent()), gp);
        }
        return null;
    }

    private com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity generateActivityFromTask(Task a, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity res = null;
        if (a != null) {
            if (a.hasDataInputAssociation()) {
                this.generateAssign(a.getName(), a.getDataInputAssociation(), seqOrFlowOrScope, gp);
            }
            if (a instanceof ServiceTask) {
                Invoke invoke;
                res = invoke = this.generateInvoke((ServiceTask)a, seqOrFlowOrScope, gp);
            } else if (a instanceof ReceiveTask) {
                Receive receive = this.generateReceive((ReceiveTask)a, seqOrFlowOrScope, gp);
                res = receive;
            } else if (a instanceof SendTask) {
                if (this.isProcessEndingSendTask((SendTask)a)) {
                    Reply reply = this.generateReply((SendTask)a, seqOrFlowOrScope, gp);
                    res = reply;
                } else {
                    res = this.generateInvoke((SendTask)a, seqOrFlowOrScope, gp);
                }
            } else {
                Empty empty = this.generateEmpty(a, seqOrFlowOrScope, gp);
                res = empty;
            }
            if (a.hasDataOutputAssociation()) {
                this.generateAssign(a.getName(), a.getDataOutputAssociation(), seqOrFlowOrScope, gp);
            }
            this.generateNextActivity(a, seqOrFlowOrScope, gp);
        }
        return res;
    }

    private boolean isProcessEndingSendTask(SendTask st) {
        if (st.getOutgoingFlowNodes() == null || st.getOutgoingFlowNodes().isEmpty()) {
            return true;
        }
        boolean allEndEvent = true;
        for (FlowNode a : st.getOutgoingFlowNodes()) {
            if (a instanceof EndEvent) continue;
            allEndEvent = false;
            break;
        }
        return allEndEvent;
    }

    public Receive generateReceive(ReceiveTask a, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        assert (a != null);
        return this.generateReceive(a.getName(), a.isInstantiate(), a.getOperationRef(), seqOrFlowOrScope, gp);
    }

    private Receive generateReceive(String name, boolean createInstance, QName operationRef, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        ReceiveImpl receive = new ReceiveImpl(new TReceive(), seqOrFlowOrScope);
        this.addActivityInParent(receive, seqOrFlowOrScope);
        receive.setName(name);
        receive.setCreateInstance(createInstance);
        Operation op = DefinitionsHelper.findBPMNObject(gp.getBPMNDefinitions(), operationRef, Operation.class);
        Interface itf = (Interface)op.getXmlObjectParent();
        if (itf.hasImplementationRef()) {
            receive.setInterface(itf.getImplementationRef());
            receive.setOperation(op.getImplementationRef().getLocalPart());
        } else {
            receive.setOperation(op.getName());
            receive.setInterface(new QName(gp.getBPMNDefinitions().getTargetNamespace(), itf.getName()));
        }
        receive.setPartnerLink(BPELGeneratorHelper.findPartnerLinkFromInterface(receive.getInterface(), gp.getBpelProcess(), gp.getArtefactDesc()).getName());
        Message msgIn = DefinitionsHelper.findBPMNObject(gp.getBPMNDefinitions(), op.getInMessageRef(), Message.class);
        BPELVariable<?> inputVariable = this.createOrFindVariableFromMessage(msgIn, gp);
        receive.setInputVariable(inputVariable.getQName().getLocalPart());
        return receive;
    }

    public Invoke generateInvoke(ServiceTask a, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        return this.generateInvoke(a.getName(), a.getOperationRef(), true, seqOrFlowOrScope, gp);
    }

    public Invoke generateInvoke(SendTask a, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        return this.generateInvoke(a.getName(), a.getOperationRef(), false, seqOrFlowOrScope, gp);
    }

    private Invoke generateInvoke(String name, QName operationRef, boolean outputVariable, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        InvokeImpl invoke = new InvokeImpl(new TInvoke(), seqOrFlowOrScope);
        this.addActivityInParent(invoke, seqOrFlowOrScope);
        invoke.setName(name);
        Operation op = DefinitionsHelper.findBPMNObject(gp.getBPMNDefinitions(), operationRef, Operation.class);
        Interface itf = (Interface)op.getXmlObjectParent();
        if (itf.hasImplementationRef()) {
            invoke.setInterface(itf.getImplementationRef());
            invoke.setOperation(op.getImplementationRef().getLocalPart());
        } else {
            invoke.setOperation(op.getName());
            invoke.setInterface(new QName(gp.getBPMNDefinitions().getTargetNamespace(), itf.getName()));
        }
        invoke.setPartnerLink(BPELGeneratorHelper.findPartnerLinkFromInterface(invoke.getInterface(), gp.getBpelProcess(), gp.getArtefactDesc()).getName());
        Message msgIn = DefinitionsHelper.findBPMNObject(gp.getBPMNDefinitions(), op.getInMessageRef(), Message.class);
        BPELVariable<?> inputVariable = this.createOrFindVariableFromMessage(msgIn, gp);
        invoke.setInputVariable(inputVariable.getQName().getLocalPart());
        if (outputVariable) {
            Message msgOut = DefinitionsHelper.findBPMNObject(gp.getBPMNDefinitions(), op.getOutMessageRef(), Message.class);
            BPELVariable<?> outputVar = this.createOrFindVariableFromMessage(msgOut, gp);
            invoke.setOutputVariable(outputVar.getQName().getLocalPart());
        }
        return invoke;
    }

    public Empty generateEmpty(Task a, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException {
        EmptyImpl empty = new EmptyImpl(new TEmpty(), seqOrFlowOrScope);
        this.addActivityInParent(empty, seqOrFlowOrScope);
        empty.setName(a.getName());
        return empty;
    }

    public Reply generateReply(SendTask a, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        return this.generateReply(a.getName(), a.getOperationRef(), seqOrFlowOrScope, gp);
    }

    private Reply generateReply(String name, QName operationRef, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        ReplyImpl reply = new ReplyImpl(new TReply(), seqOrFlowOrScope);
        this.addActivityInParent(reply, seqOrFlowOrScope);
        reply.setName(name);
        Operation op = DefinitionsHelper.findBPMNObject(gp.getBPMNDefinitions(), operationRef, Operation.class);
        Interface itf = (Interface)op.getXmlObjectParent();
        if (itf.hasImplementationRef()) {
            reply.setInterface(itf.getImplementationRef());
            reply.setOperation(op.getImplementationRef().getLocalPart());
        } else {
            reply.setOperation(op.getName());
            reply.setInterface(new QName(gp.getBPMNDefinitions().getTargetNamespace(), itf.getName()));
        }
        reply.setPartnerLink(BPELGeneratorHelper.findPartnerLinkFromInterface(reply.getInterface(), gp.getBpelProcess(), gp.getArtefactDesc()).getName());
        Message msg = DefinitionsHelper.findBPMNObject(gp.getBPMNDefinitions(), op.getOutMessageRef(), Message.class);
        BPELVariable<?> var = this.createOrFindVariableFromMessage(msg, gp);
        reply.setOutputVariable(var.getQName().getLocalPart());
        return reply;
    }

    private void addActivityInParent(BPELElement child, BPELElement seqOrFlowOrScope) throws BPELException {
        if (seqOrFlowOrScope instanceof Sequence) {
            ((Sequence)seqOrFlowOrScope).addActivity((com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity)child);
        } else if (seqOrFlowOrScope instanceof Flow) {
            ((Flow)seqOrFlowOrScope).addActivity((com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity)child);
        } else if (seqOrFlowOrScope instanceof OnMessage) {
            ((OnMessage)seqOrFlowOrScope).setActivity((com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity)child);
        } else if (seqOrFlowOrScope instanceof Pick) {
            ((Pick)seqOrFlowOrScope).addOnMessage((OnMessage)child);
        } else if (seqOrFlowOrScope instanceof While) {
            ((While)seqOrFlowOrScope).setActivity((com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity)child);
        } else if (seqOrFlowOrScope instanceof Scope) {
            ((Scope)seqOrFlowOrScope).setActivity((com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity)child);
        } else {
            throw new BPELException("Sorry but this type of element is not handled yet : " + seqOrFlowOrScope.getClass());
        }
    }

    private Assign generateAssign(String activityName, DataAssociation[] dataAssociations, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        AssignImpl assign = null;
        if (dataAssociations.length > 0) {
            assign = new AssignImpl(new TAssign(), seqOrFlowOrScope);
            for (DataAssociation asso : dataAssociations) {
                HashMap<String, String> variableMapping = new HashMap<String, String>();
                for (ItemAwareElement iae : asso.getSourceRef()) {
                    ItemDefinition itemDef = DefinitionsHelper.findBPMNObject(gp.getBPMNDefinitions(), iae.getItemSubjectRef(), ItemDefinition.class);
                    BPELVariable<?> var = this.createOrFindVariableFromElement(itemDef.getStructureRef(), gp);
                    variableMapping.put(((BaseElement)((Object)iae)).getId(), var.getQName().getLocalPart());
                }
                ItemDefinition itemDef = DefinitionsHelper.findBPMNObject(gp.getBPMNDefinitions(), asso.getTargetRef().getItemSubjectRef(), ItemDefinition.class);
                BPELVariable<?> var = this.createOrFindVariableFromElement(itemDef.getStructureRef(), gp);
                for (Assignment a : asso.getAssignment()) {
                    CopyImpl copy = new CopyImpl(new TCopy(), assign);
                    FromImpl from = new FromImpl(new TFrom(), copy);
                    from.setContent(this.generateExpression(a.getFrom().getTextContent(), variableMapping));
                    copy.setFrom(from);
                    variableMapping.clear();
                    variableMapping.put(((BaseElement)((Object)asso.getTargetRef())).getId(), var.getQName().getLocalPart());
                    ToImpl to = new ToImpl(new TTo(), copy);
                    to.setContent(this.generateExpression(a.getTo().getTextContent(), variableMapping));
                    copy.setTo(to);
                    assign.addCopy(copy);
                }
                if (!asso.hasTransformation()) continue;
                System.out.println("WARNING : the transformations defined in BPMN dataAssociations are not handled yet.");
            }
            this.addActivityInParent(assign, seqOrFlowOrScope);
        }
        return assign;
    }

    private String generateExpression(String xpathExpression, Map<String, String> mapping) {
        String result = xpathExpression;
        for (String associationExtrmityId : mapping.keySet()) {
            result = result.replace("$" + associationExtrmityId, "$" + mapping.get(associationExtrmityId));
        }
        return result;
    }

    private BPELVariable<?> createOrFindVariableFromElement(QName element, GenerationProperties gp) {
        gp.getElementsToImport().add(element);
        for (BPELVariable var : gp.getBpelProcess().getVariables()) {
            if (var.getElement() == null || !var.getElement().equals(element)) continue;
            return var;
        }
        BPELElementVariable var = gp.getBpelProcess().createBPELElementVariable(element.getLocalPart() + "Variable", element, BPELElementVariable.VariableType.ELEMENT);
        return var;
    }

    private OnMessage generateOnMessage(ReceiveTask rt, Pick pick, GenerationProperties gp) throws BPMNException, BPELException {
        return this.generateOnMessage(rt, rt.getOperationRef(), rt.getDataOutputAssociation(), rt.getDataInputAssociation(), pick, gp);
    }

    private OnMessage generateOnMessage(FlowNode fn, QName operationRef, DataOutputAssociation[] doas, DataInputAssociation[] dias, Pick pick, GenerationProperties gp) throws BPELException, BPMNException {
        OnMessageImpl onMessage = new OnMessageImpl(new TOnMessage(), (BPELElementImpl)((Object)pick));
        this.addActivityInParent(onMessage, pick);
        Operation op = DefinitionsHelper.findBPMNObject(gp.getBPMNDefinitions(), operationRef, Operation.class);
        Interface itf = (Interface)op.getXmlObjectParent();
        if (itf.hasImplementationRef()) {
            onMessage.setInterface(itf.getImplementationRef());
            onMessage.setOperation(op.getImplementationRef().getLocalPart());
        } else {
            onMessage.setOperation(op.getName());
            onMessage.setInterface(new QName(gp.getBPMNDefinitions().getTargetNamespace(), itf.getName()));
        }
        onMessage.setPartnerLink(BPELGeneratorHelper.findPartnerLinkFromInterface(onMessage.getInterface(), gp.getBpelProcess(), gp.getArtefactDesc()).getName());
        Message msg = DefinitionsHelper.findBPMNObject(gp.getBPMNDefinitions(), op.getInMessageRef(), Message.class);
        BPELVariable<?> var = this.createOrFindVariableFromMessage(msg, gp);
        onMessage.setInputVariable(var.getQName().getLocalPart());
        SequenceImpl seq = new SequenceImpl(new TSequence(), onMessage);
        this.addActivityInParent(seq, onMessage);
        if (dias != null) {
            this.generateAssign(fn.getName(), dias, seq, gp);
        }
        if (doas != null) {
            this.generateAssign(fn.getName(), doas, seq, gp);
        }
        this.generateNextActivity(fn, seq, gp);
        return onMessage;
    }

    private BPELVariable<?> createOrFindVariableFromMessage(Message message, GenerationProperties gp) throws BPMNException {
        ItemDefinition itemDef = DefinitionsHelper.findBPMNObject(gp.getBPMNDefinitions(), message.getItemRef(), ItemDefinition.class);
        return this.createOrFindVariableFromElement(itemDef.getStructureRef(), gp);
    }

    private BPELVariable<?> createOrFindBooleanVariable(FlowElement fe, GenerationProperties gp) throws BPMNException {
        for (BPELVariable var : gp.getBpelProcess().getVariables()) {
            if (!var.getQName().getLocalPart().startsWith(fe.getId())) continue;
            return var;
        }
        return gp.getBpelProcess().createBPELElementVariable(fe.getId() + "Variable", new QName("http://www.w3.org/2001/XMLSchema", "boolean"), BPELElementVariable.VariableType.TYPE);
    }

    private void addDescriptionImport(BPELProcess p, com.ebmwebsourcing.easywsdl11.api.element.Definitions desc) {
        ImportImpl imp = new ImportImpl(new TImport(), p);
        imp.setImportType(URI.create("http://schemas.xmlsoap.org/wsdl/"));
        imp.setLocation(URI.create(desc.getName() + ".wsdl"));
        imp.setNamespace(URI.create(desc.getTargetNamespace()));
        imp.setDescription((Description)Factory.getInstance().wrap(desc));
        p.addImport(imp);
    }

    private void addSchemaImport(BPELProcess p, Schema schema, String location) {
        ImportImpl imp = new ImportImpl(new TImport(), p);
        imp.setImportType(URI.create("http://www.w3.org/2001/XMLSchema"));
        imp.setLocation(URI.create(location));
        imp.setNamespace(URI.create(schema.getTargetNamespace()));
        imp.setSchema2(schema);
        p.addImport(imp);
    }
}

