/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpmn.bpmn2bpel;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.EventBasedGateway;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ExclusiveGateway;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.FlowElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.FlowNode;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Gateway;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Process;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.SequenceFlow;
import com.ebmwebsourcing.easyplnk20.api.element.PartnerLinkType;
import com.ebmwebsourcing.easyplnk20.api.element.Role;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public class BPELGeneratorHelper {
    public static Map<Gateway, Set<SequenceFlow>> findLoopDivergers(Process proc, Collection<? extends FlowElement> starts) {
        HashMap<Gateway, Set<SequenceFlow>> result = new HashMap<Gateway, Set<SequenceFlow>>();
        ArrayList<List<FlowElement>> loops = new ArrayList<List<FlowElement>>();
        for (FlowElement flowElement : starts) {
            ArrayList<FlowElement> visited = new ArrayList<FlowElement>();
            BPELGeneratorHelper.followPath(flowElement, visited, loops);
        }
        for (List list : loops) {
            Gateway diverger = null;
            for (int i = 0; i < list.size(); ++i) {
                if (!(list.get(i) instanceof ExclusiveGateway) && !(list.get(i) instanceof EventBasedGateway) || ((FlowNode)list.get(i)).getOutgoingFlowNodes().size() <= 1) continue;
                diverger = (Gateway)list.get(i);
                break;
            }
            FlowElement next = null;
            int index = list.indexOf(diverger);
            next = index == list.size() - 1 ? (FlowElement)list.get(0) : (FlowElement)list.get(index + 1);
            SequenceFlow outgoer = null;
            for (SequenceFlow sf : proc.getFlowElementsByClass(SequenceFlow.class)) {
                if (!sf.getSourceRef().getId().equals(diverger.getId()) || !sf.getTargetRef().getId().equals(next.getId())) continue;
                outgoer = sf;
                break;
            }
            if (!result.containsKey(diverger)) {
                result.put(diverger, new HashSet());
            }
            ((Set)result.get(diverger)).add(outgoer);
        }
        return result;
    }

    private static void followPath(FlowElement fe, List<FlowElement> visited, List<List<FlowElement>> loops) {
        if (visited.contains(fe)) {
            int index = visited.indexOf(fe);
            List<FlowElement> l = visited.subList(index, visited.size());
            loops.add(l);
        } else {
            FlowNode fn;
            ArrayList<FlowElement> l = new ArrayList<FlowElement>(visited);
            l.add(fe);
            if (fe instanceof FlowNode && (fn = (FlowNode)fe).getOutgoing() != null) {
                for (FlowNode next : fn.getOutgoingFlowNodes()) {
                    BPELGeneratorHelper.followPath(next, l, loops);
                }
            }
        }
    }

    public static PartnerLink findPartnerLinkFromInterface(QName itf, BPELProcess process, Definitions artefactDesc) throws BPELException {
        ArrayList<PartnerLinkType> validPLT = new ArrayList<PartnerLinkType>();
        for (PartnerLinkType plt : (PartnerLinkType[])artefactDesc.getAnyXmlObjects(PartnerLinkType.class)) {
            for (Role r : plt.getRoles()) {
                if (!r.getPortType().equals(itf)) continue;
                validPLT.add(plt);
            }
        }
        for (PartnerLinkType plt : validPLT) {
            for (PartnerLink pl : process.getPartnerLinks()) {
                if (!pl.getPartnerLinkType().getNamespaceURI().equals(artefactDesc.getTargetNamespace()) || !pl.getPartnerLinkType().getLocalPart().equals(plt.getName())) continue;
                return pl;
            }
        }
        return null;
    }

    public static Set<FlowNode> getAllStartingNodes(Process proc) {
        HashSet<FlowNode> startingNodes = new HashSet<FlowNode>();
        HashSet<FlowNode> alreadyVisitedNodes = new HashSet<FlowNode>();
        for (FlowNode fn : proc.getFlowNode()) {
            BPELGeneratorHelper.followPathBackWards(fn, startingNodes, alreadyVisitedNodes);
        }
        return startingNodes;
    }

    private static void followPathBackWards(FlowNode fn, Set<FlowNode> startingNodes, Set<FlowNode> alreadyVisitedNodes) {
        if (alreadyVisitedNodes.contains(fn)) {
            return;
        }
        List<FlowNode> incoming = fn.getIncomingFlowNodes();
        if (incoming.isEmpty()) {
            startingNodes.add(fn);
        } else {
            alreadyVisitedNodes.add(fn);
            for (FlowNode preceding : incoming) {
                BPELGeneratorHelper.followPathBackWards(preceding, startingNodes, alreadyVisitedNodes);
            }
        }
    }

    public static String getFileNameFromImportLocation(String location) {
        int index = location.lastIndexOf("/");
        if (index != -1) {
            if (index == location.length() - 1) {
                return BPELGeneratorHelper.getFileNameFromImportLocation(location.substring(0, index));
            }
            return location.substring(index + 1);
        }
        return location;
    }
}

