/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpmn.bpmn2bpel.wsdl;

import com.ebmwebsourcing.easybpmn.bpmn20.api.BPMNException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.DefinitionsHelper;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Collaboration;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Interface;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Participant;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.PartnerRole;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.GenerationProperties;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.wsdl.WSDLGeneratorHelper;
import com.ebmwebsourcing.easyplnk20.api.element.PartnerLinkType;
import com.ebmwebsourcing.easyplnk20.api.element.Role;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.Import;
import java.util.Collection;
import javax.xml.namespace.QName;

public class ArtefactWSDLGenerator {
    public static Definitions generateArtefactWSDL(Collaboration c, Collection<Definitions> descs, GenerationProperties gp) throws BPMNException {
        Definitions res = gp.newInstance(Definitions.class);
        res.setName((c.hasName() ? c.getName() : c.getId()).replace(" ", "") + "Artefacts");
        String artefactNameSpace = WSDLGeneratorHelper.getArtefactNamespace(gp.getBPMNDefinitions().getTargetNamespace());
        res.setTargetNamespace(artefactNameSpace);
        for (Definitions desc : descs) {
            Import impt = gp.newInstance(Import.class);
            impt.setLocation(desc.getName() + ".wsdl");
            impt.setNamespace(desc.getTargetNamespace());
            res.addImport(impt);
        }
        for (Participant participant : c.getParticipant()) {
            block2: for (QName qn : participant.getInterfaceRef()) {
                PartnerLinkType plt = gp.newInstance(PartnerLinkType.class);
                res.addAnyXmlObject(plt);
                Role role = gp.newInstance(Role.class);
                plt.addRole(role);
                Interface itf = DefinitionsHelper.findBPMNObject(gp.getBPMNDefinitions(), qn, Interface.class);
                plt.setName(participant.getName() + "_" + itf.getName() + "PLT");
                if (itf.hasImplementationRef()) {
                    role.setPortType(itf.getImplementationRef());
                } else {
                    role.setPortType(new QName(gp.getBPMNDefinitions().getTargetNamespace(), itf.getName()));
                }
                role.setName(itf.getName());
                for (PartnerRole pr : gp.getBPMNDefinitions().getPartnerRoles()) {
                    if (!pr.hasParticipantRef()) continue;
                    for (QName participantQname : pr.getParticipantRef()) {
                        if (!participantQname.getLocalPart().equals(participant.getId())) continue;
                        role.setName(pr.getName());
                        continue block2;
                    }
                }
            }
        }
        return res;
    }
}

