/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpmn.bpmn2bpel.wsdl;

import com.ebmwebsourcing.easybpmn.bpmn20.api.BPMNException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.DefinitionsHelper;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.EndPoint;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Interface;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Participant;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.GenerationProperties;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.wsdl.WSDLGeneratorHelper;
import com.ebmwebsourcing.easywsdl11.api.WsdlHelper;
import com.ebmwebsourcing.easywsdl11.api.element.Binding;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.Port;
import com.ebmwebsourcing.easywsdl11.api.element.PortType;
import com.ebmwebsourcing.easywsdl11.api.element.Service;
import com.ebmwebsourcing.easywsdl11.api.type.TExtensibleDocumented;
import java.util.ArrayList;
import javax.xml.namespace.QName;

public class ConcreteWSDLGenerator {
    public static void generateConcreteWSDL(Interface itf, Participant participant, Definitions abstractDesc, GenerationProperties gp) throws BPMNException {
        if (itf.hasImplementationRef()) {
            QName implemRef;
            PortType pt;
            Service s = null;
            if (abstractDesc.getServices() == null || abstractDesc.getServices().length == 0) {
                s = gp.newInstance(Service.class);
                s.setName(abstractDesc.getName() + "Service");
                abstractDesc.addService(s);
            } else {
                s = abstractDesc.getServices()[0];
            }
            if (participant.hasEndPointRef()) {
                for (QName qn : participant.getEndPointRef()) {
                    Port p;
                    Binding binding;
                    EndPoint endpoint = DefinitionsHelper.findBPMNObject(gp.getBPMNDefinitions(), qn, EndPoint.class);
                    if (endpoint == null || !endpoint.hasEndPointRef() || !(binding = WsdlHelper.findParentDefinitions(p = WSDLGeneratorHelper.findPortInImports(endpoint.getEndPointRef(), gp.getBPMNDefinitions())).getBindingByName(p.getBinding().getLocalPart())).getType().equals(itf.getImplementationRef())) continue;
                    if (abstractDesc.getBindingByName(binding.getName()) == null) {
                        abstractDesc.addBinding(binding);
                    }
                    if (s.getPortByName(p.getName()) != null) continue;
                    s.addPort(p);
                }
                if (s.getPorts() != null && s.getPorts().length > 0) {
                    return;
                }
            }
            if ((pt = WSDLGeneratorHelper.findInterfaceInImports(implemRef = itf.getImplementationRef(), gp.getBPMNDefinitions())) != null) {
                Definitions defs = WsdlHelper.findParentDefinitions(pt);
                ArrayList<String> bindings = new ArrayList<String>();
                for (Binding binding : defs.getBindings()) {
                    if (!binding.hasType() || !binding.getType().equals(implemRef)) continue;
                    bindings.add(binding.getName());
                }
                for (TExtensibleDocumented tExtensibleDocumented : defs.getServices()) {
                    for (Port port : tExtensibleDocumented.getPorts()) {
                        Binding binding;
                        if (!bindings.contains(port.getBinding().getLocalPart())) continue;
                        if (s.getPortByName(port.getName()) == null) {
                            s.addPort(port);
                        }
                        if (abstractDesc.getBindingByName((binding = defs.getBindingByName(port.getBinding().getLocalPart())).getName()) != null) continue;
                        abstractDesc.addBinding(binding);
                    }
                }
            }
        }
    }
}

