/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpmn.bpmn2bpel.wsdl;

import com.ebmwebsourcing.easybpmn.bpmn20.api.BPMNException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.DefinitionsHelper;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Collaboration;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Interface;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Participant;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.GenerationProperties;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.wsdl.AbstractWSDLGenerator;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.wsdl.ArtefactWSDLGenerator;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.wsdl.ConcreteWSDLGenerator;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.wsdl.WSDLGeneratorHelper;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;

public class WSDLGenerator {
    public Set<com.ebmwebsourcing.easywsdl11.api.element.Definitions> generate(Definitions def) throws BPMNException {
        return this.generate(def, new GenerationProperties());
    }

    public Set<com.ebmwebsourcing.easywsdl11.api.element.Definitions> generate(Definitions def, GenerationProperties gp) throws BPMNException {
        gp.setBPMNDefinitions(def);
        WSDLGeneratorHelper.init();
        HashSet<com.ebmwebsourcing.easywsdl11.api.element.Definitions> res = new HashSet<com.ebmwebsourcing.easywsdl11.api.element.Definitions>();
        for (Collaboration c : def.getCollaborations()) {
            for (Participant participant : c.getParticipant()) {
                if (!participant.hasInterfaceRef() || participant.getInterfaceRef().length <= 0) continue;
                this.generate(participant, gp);
            }
            res.addAll(WSDLGeneratorHelper.getAllDefinitions());
            com.ebmwebsourcing.easywsdl11.api.element.Definitions artefactDesc = ArtefactWSDLGenerator.generateArtefactWSDL(c, res, gp);
            res.add(artefactDesc);
            gp.setArtefactDesc(artefactDesc);
        }
        return res;
    }

    public void generate(Participant participant, GenerationProperties gp) throws BPMNException {
        for (QName itfQname : participant.getInterfaceRef()) {
            Interface itf = DefinitionsHelper.findBPMNObject(gp.getBPMNDefinitions(), itfQname, Interface.class);
            com.ebmwebsourcing.easywsdl11.api.element.Definitions abstractDesc = AbstractWSDLGenerator.generateAbstractWSDL(itf, gp);
            ConcreteWSDLGenerator.generateConcreteWSDL(itf, participant, abstractDesc, gp);
        }
    }
}

