/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.io;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public final class ByteChannelDumpHelper {
    private ByteChannelDumpHelper() {
    }

    public static final FileChannel createDumpFileChannel(File dumpFile) {
        FileOutputStream dumpFileOutputStream;
        assert (dumpFile != null);
        assert (!dumpFile.isDirectory()) : "Dump file can't be a directory";
        dumpFile.getParentFile().mkdirs();
        try {
            dumpFileOutputStream = new FileOutputStream(dumpFile);
        }
        catch (FileNotFoundException e) {
            throw new UncheckedException(e);
        }
        return dumpFileOutputStream.getChannel();
    }

    public static final int dumpAndRead(ReadableByteChannel channelToDump, ByteBuffer readBuffer, FileChannel dumpChannel) throws IOException {
        ByteChannelDumpHelper.ensureChannelIsOpen(channelToDump);
        ByteBuffer readBufferView = readBuffer.duplicate();
        int nbBytesRead = channelToDump.read(readBuffer);
        if (nbBytesRead != -1) {
            readBufferView.limit(readBufferView.position() + nbBytesRead);
            dumpChannel.write(readBufferView);
        }
        return nbBytesRead;
    }

    public static final int dumpAndWrite(WritableByteChannel channelToDump, ByteBuffer writeBuffer, FileChannel dumpChannel) throws IOException {
        ByteChannelDumpHelper.ensureChannelIsOpen(channelToDump);
        ByteBuffer writeBufferView = writeBuffer.duplicate();
        dumpChannel.write(writeBufferView);
        int nbBytesWritten = channelToDump.write(writeBuffer);
        return nbBytesWritten;
    }

    private static final void ensureChannelIsOpen(Channel channel) throws ClosedChannelException {
        if (!channel.isOpen()) {
            throw new ClosedChannelException();
        }
    }
}

