/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.io;

import java.io.File;
import java.io.IOException;
import java.util.Random;

public final class FileSystemHelper {
    private static final Random random = new Random();

    private FileSystemHelper() {
    }

    private static final File getSystemTempDir() {
        String tmpDirPath = System.getProperty("java.io.tmpdir");
        assert (tmpDirPath != null);
        File tmpDir = new File(tmpDirPath);
        assert (tmpDir != null);
        return tmpDir;
    }

    public static File createTempDir() throws IOException {
        return FileSystemHelper.createTempDir(FileSystemHelper.getSystemTempDir(), "tmp");
    }

    public static File createTempDir(String prefix) throws IOException {
        return FileSystemHelper.createTempDir(FileSystemHelper.getSystemTempDir(), prefix);
    }

    public static File createTempDir(File parentDir, String prefix) throws IOException {
        File tempDir = null;
        while ((tempDir = new File(parentDir, prefix + random.nextLong())).exists()) {
        }
        if (!tempDir.mkdir()) {
            throw new IOException(String.format("Impossible to create temp dir '%s'", tempDir.getAbsolutePath()));
        }
        tempDir.deleteOnExit();
        return tempDir;
    }

    public static void cleanDirectory(File directory) throws IOException {
        assert (directory != null);
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IOException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IOException(message);
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IOException("Failed to list contents of " + directory);
        }
        IOException exception = null;
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            try {
                FileSystemHelper.forceDelete(file);
                continue;
            }
            catch (IOException ioe) {
                exception = ioe;
            }
        }
        if (null != exception) {
            throw exception;
        }
    }

    public static void forceDelete(File file) throws IOException {
        assert (file != null);
        if (file.isDirectory()) {
            FileSystemHelper.deleteDirectory(file);
        } else {
            if (!file.exists()) {
                return;
            }
            if (!file.delete()) {
                String message = "Unable to delete file: " + file;
                throw new IOException(message);
            }
        }
    }

    private static void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        FileSystemHelper.cleanDirectory(directory);
        if (!directory.delete()) {
            String message = "Unable to delete directory " + directory + ".";
            throw new IOException(message);
        }
    }
}

