/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.sca.helper.impl;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAComponent;
import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.Binding;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.oasisopen.sca.ServiceReference;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalContentException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.api.control.NameController;
import org.objectweb.fractal.api.control.SuperController;
import org.objectweb.fractal.api.factory.Factory;
import org.objectweb.fractal.julia.ComponentInterface;
import org.objectweb.fractal.julia.Interceptor;
import org.objectweb.fractal.util.Fractal;
import org.ow2.frascati.tinfi.control.content.SCAExtendedContentController;
import org.ow2.frascati.tinfi.oasis.ServiceReferenceImpl;

public class SCAHelper {
    public static final String EXPLORER_COMPOSITE = "Explorer";
    public static final String CORE_EXPLORER_COMPOSITE = "CoreExplorer";
    public static final String FCAPPL_BINDING = "fcAppl";
    private static SCAHelper scaHelper = new SCAHelper();

    private SCAHelper() {
    }

    public static SCAHelper getSCAHelper() throws SCAException {
        return scaHelper;
    }

    public synchronized Component createNewComponent(String name, Map<Object, Object> ctxt) throws SCAException {
        try {
            String s = String.valueOf(name) + "Factory";
            Class<?> cl = Class.forName(s);
            Factory f = (Factory)cl.newInstance();
            Component c = f.newFcInstance();
            this.changeName(c, name);
            return c;
        }
        catch (Exception e) {
            throw new SCAException(e);
        }
    }

    public void changeName(Component comp, String name) throws SCAException {
        try {
            NameController nc = Fractal.getNameController(comp);
            nc.setFcName(name);
        }
        catch (NoSuchInterfaceException e) {
            throw new SCAException("Impossible to change the name ot this fractal componet: " + comp, e);
        }
    }

    public String getName(Component comp) {
        String res = null;
        try {
            if (comp != null) {
                NameController nc = Fractal.getNameController(comp);
                res = nc.getFcName();
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            // empty catch block
        }
        return res;
    }

    public List<Component> getComponentsByName(Component parent, String name) {
        ArrayList<Component> matchedComponents = new ArrayList<Component>();
        try {
            ContentController parentContentController = Fractal.getContentController(parent);
            ContentController subContentController = null;
            Component[] componentArray = parentContentController.getFcSubComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                block8: {
                    Component component = componentArray[n2];
                    try {
                        subContentController = Fractal.getContentController(component);
                        if (subContentController.getFcSubComponents().length > 0) {
                            matchedComponents.addAll(this.getComponentsByName(component, name));
                        }
                    }
                    catch (NoSuchInterfaceException noSuchInterfaceException) {
                        // empty catch block
                    }
                    try {
                        String componentName = Fractal.getNameController(component).getFcName();
                        if (componentName == null || !componentName.equals(name)) break block8;
                        matchedComponents.add(component);
                        break;
                    }
                    catch (NoSuchInterfaceException noSuchInterfaceException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            // empty catch block
        }
        return matchedComponents;
    }

    public Component getFirstComponentByName(Component parent, String name) {
        List<Component> comps = this.getComponentsByName(parent, name);
        Component comp = null;
        if (comps != null && comps.size() > 0) {
            comp = comps.get(0);
        }
        return comp;
    }

    public Interface getBoundInterface(ServiceReference<?> sr) {
        ServiceReferenceImpl cri = (ServiceReferenceImpl)sr;
        Object service = cri._getDelegate();
        ComponentInterface ci = (ComponentInterface)service;
        Interceptor intercep = (Interceptor)ci.getFcItfImpl();
        Interface itf = (Interface)intercep.getFcItfDelegate();
        return itf;
    }

    public Component getComponentByInterface(Component parent, ServiceReference<?> sr, String interfaceName) {
        Interface itf = this.getBoundInterface(sr);
        return this.getComponentByInterface(parent, itf, interfaceName);
    }

    public Component getComponentByInterface(Component parent, Interface itf, String interfaceName) {
        Component matchedComponent = null;
        try {
            ContentController parentContentController = Fractal.getContentController(parent);
            ContentController subContentController = null;
            Component[] componentArray = parentContentController.getFcSubComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                block9: {
                    Component component;
                    block7: {
                        component = componentArray[n2];
                        try {
                            subContentController = Fractal.getContentController(component);
                            if (subContentController.getFcSubComponents().length <= 0 || (matchedComponent = this.getComponentByInterface(component, itf, interfaceName)) == null) break block7;
                            break;
                        }
                        catch (NoSuchInterfaceException e1) {
                            matchedComponent = null;
                        }
                    }
                    try {
                        Interface itfC = (Interface)component.getFcInterface(interfaceName);
                        if (itfC != itf) break block9;
                        matchedComponent = component;
                        break;
                    }
                    catch (NoSuchInterfaceException e) {
                        matchedComponent = null;
                    }
                }
                ++n2;
            }
        }
        catch (NoSuchInterfaceException e1) {
            matchedComponent = null;
        }
        return matchedComponent;
    }

    public List<Component> getComponents(Component parent) {
        ArrayList<Component> res = new ArrayList<Component>();
        try {
            ContentController parentContentController = Fractal.getContentController(parent);
            Component[] componentArray = parentContentController.getFcSubComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component = componentArray[n2];
                res.add(component);
                ++n2;
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            // empty catch block
        }
        return res;
    }

    public List<Component> getAllSubComponents(Component parent) {
        ArrayList<Component> res = new ArrayList<Component>();
        try {
            ContentController parentContentController = Fractal.getContentController(parent);
            Component[] componentArray = parentContentController.getFcSubComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component = componentArray[n2];
                res.add(component);
                res.addAll(this.getComponents(component));
                ++n2;
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            // empty catch block
        }
        return res;
    }

    public Map<String, Interface> getServerInterfacesLinkedToClientInterfacesOfComponent(Component component) {
        HashMap<String, Interface> res = new HashMap<String, Interface>();
        try {
            BindingController componentBindingController = Fractal.getBindingController(component);
            String[] stringArray = componentBindingController.listFc();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String clientItfName = stringArray[n2];
                Interface itf = (Interface)componentBindingController.lookupFc(clientItfName);
                res.put(clientItfName, itf);
                ++n2;
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            // empty catch block
        }
        return res;
    }

    public List<Component> getClientComponentsLinkedToServerInterfacesOfComponent(Component parentComponent, Interface itfOfComponent) {
        ArrayList<Component> listOfcomponents = new ArrayList<Component>();
        try {
            ContentController componentContentController = Fractal.getContentController(parentComponent);
            Component[] componentArray = componentContentController.getFcSubComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component = componentArray[n2];
                Map<String, Interface> listOfItf = SCAHelper.getSCAHelper().getServerInterfacesLinkedToClientInterfacesOfComponent(component);
                for (Interface itf : listOfItf.values()) {
                    if (itf != itfOfComponent || listOfcomponents.contains(component)) continue;
                    listOfcomponents.add(component);
                }
                ++n2;
            }
        }
        catch (NoSuchInterfaceException componentContentController) {
        }
        catch (SCAException e) {
            e.printStackTrace();
        }
        return listOfcomponents;
    }

    public LifeCycleController getLifeCycleControllerByName(Component parent, String name) throws SCAException {
        LifeCycleController lifeCycleController = null;
        List<Component> comps = this.getComponentsByName(parent, name);
        if (comps != null && comps.size() > 1) {
            throw new SCAException("Several component with the same name");
        }
        Component comp = null;
        comp = comps.get(0);
        if (comp != null) {
            try {
                lifeCycleController = Fractal.getLifeCycleController(comp);
            }
            catch (NoSuchInterfaceException e) {
                lifeCycleController = null;
            }
        }
        return lifeCycleController;
    }

    public boolean isStarted(Component comp) {
        boolean res = false;
        if (comp != null) {
            try {
                LifeCycleController lifeCycleController = Fractal.getLifeCycleController(comp);
                if (lifeCycleController.getFcState() == "STARTED") {
                    res = true;
                }
            }
            catch (NoSuchInterfaceException e) {
                res = false;
            }
        }
        return res;
    }

    public boolean startComponent(Component component) throws SCAException {
        boolean result = false;
        if (component != null) {
            try {
                LifeCycleController lifeCycleController = Fractal.getLifeCycleController(component);
                if (lifeCycleController != null && lifeCycleController.getFcState().equals("STOPPED")) {
                    lifeCycleController.startFc();
                    result = true;
                }
            }
            catch (NoSuchInterfaceException e) {
                throw new SCAException("Impossible to start the component", e);
            }
            catch (IllegalLifeCycleException e) {
                throw new SCAException("Impossible to start the component", e);
            }
        }
        return result;
    }

    public boolean startComponentAndSubComponents(Component component) throws SCAException {
        boolean result = false;
        if (component != null) {
            try {
                LifeCycleController lifeCycleController = Fractal.getLifeCycleController(component);
                if (lifeCycleController != null) {
                    if (lifeCycleController.getFcState().equals("STOPPED")) {
                        lifeCycleController.startFc();
                        result = true;
                    }
                    List<Component> children = SCAHelper.getSCAHelper().getComponents(component);
                    for (Component child : children) {
                        this.startComponent(child);
                    }
                }
            }
            catch (NoSuchInterfaceException e) {
                throw new SCAException("Impossible to start the component", e);
            }
            catch (IllegalLifeCycleException e) {
                throw new SCAException("Impossible to start the component", e);
            }
        }
        return result;
    }

    public boolean stopComponent(Component component) throws SCAException {
        boolean result = false;
        try {
            LifeCycleController lifeCycleController = Fractal.getLifeCycleController(component);
            if (lifeCycleController.getFcState().equals("STARTED")) {
                lifeCycleController.stopFc();
                result = true;
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new SCAException("Impossible to stop the component", e);
        }
        catch (IllegalLifeCycleException e) {
            throw new SCAException("Impossible to stop the component", e);
        }
        return result;
    }

    public void stopAllSubComponents(Component composite) throws SCAException {
        try {
            ContentController subContentController = null;
            ContentController parentContentController = Fractal.getContentController(composite);
            int i = parentContentController.getFcSubComponents().length;
            while (i != 0) {
                block7: {
                    Component component = parentContentController.getFcSubComponents()[i - 1];
                    try {
                        subContentController = Fractal.getContentController(component);
                        if (subContentController.getFcSubComponents().length > 0) {
                            this.stopAllSubComponents(component);
                        }
                    }
                    catch (NoSuchInterfaceException e) {
                        LifeCycleController lifeCycleController = Fractal.getLifeCycleController(component);
                        if (!lifeCycleController.getFcState().equals("STARTED")) break block7;
                        lifeCycleController.stopFc();
                    }
                }
                --i;
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new SCAException("Impossible to stop the component", e);
        }
        catch (IllegalLifeCycleException e) {
            throw new SCAException("Impossible to stop the component", e);
        }
    }

    public void addComponent(Component newComponent, Component parentComponent, List<Binding> listOfBindings) throws SCAException {
        try {
            if (parentComponent == null) {
                throw new NullPointerException("The parent component of " + newComponent + " cannot be null");
            }
            ContentController parentContentController = Fractal.getContentController(parentComponent);
            parentContentController.addFcSubComponent(newComponent);
            SCAHelper.getSCAHelper().addBindings(newComponent, listOfBindings);
        }
        catch (NoSuchInterfaceException e) {
            throw new SCAException("Impossible to add a new fractal component", e);
        }
        catch (IllegalContentException e) {
            throw new SCAException("Impossible to add a new fractal component", e);
        }
        catch (IllegalLifeCycleException e) {
            throw new SCAException("Impossible to add a new fractal component", e);
        }
    }

    public synchronized void deleteComponent(Component oldComponent) throws SCAException {
        block11: {
            try {
                Component parentComponent = this.getParent(oldComponent);
                if (parentComponent == null) break block11;
                ArrayList<Binding> listOfBindings = new ArrayList<Binding>();
                BindingController bc = Fractal.getBindingController(oldComponent);
                String[] stringArray = bc.listFc();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String clientItf = stringArray[n2];
                    try {
                        bc.unbindFc(clientItf);
                    }
                    catch (IllegalBindingException illegalBindingException) {
                        // empty catch block
                    }
                    ++n2;
                }
                List<Component> clientsOfComp = this.getClientComponentsLinkedToServerInterfacesOfComponent(parentComponent, (Interface)oldComponent.getFcInterface("service"));
                for (Component clientComponent : clientsOfComp) {
                    BindingController bcClient = Fractal.getBindingController(clientComponent);
                    String[] stringArray2 = bcClient.listFc();
                    int n3 = stringArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String clientItf = stringArray2[n4];
                        if (bcClient.lookupFc(clientItf) == (Interface)oldComponent.getFcInterface("service")) {
                            try {
                                bcClient.unbindFc(clientItf);
                            }
                            catch (IllegalBindingException illegalBindingException) {
                                // empty catch block
                            }
                        }
                        ++n4;
                    }
                }
                this.deleteComponent(oldComponent, parentComponent, listOfBindings);
            }
            catch (NoSuchInterfaceException e) {
                throw new SCAException("Impossible to delete component", e);
            }
            catch (IllegalLifeCycleException e) {
                throw new SCAException("Impossible to delete component", e);
            }
        }
    }

    public synchronized void deleteComponent(Component oldComponent, Component parentComponent, List<Binding> listOfBindings) throws SCAException {
        try {
            if (parentComponent == null) {
                throw new NullPointerException("The parent component " + oldComponent + " cannot be null");
            }
            SCAExtendedContentController parentContentController = (SCAExtendedContentController)parentComponent.getFcInterface("/sca-content-controller");
            if (SCAHelper.getSCAHelper().isStarted(oldComponent)) {
                SCAHelper.getSCAHelper().stopComponent(oldComponent);
            }
            SCAHelper.getSCAHelper().deleteBindings(oldComponent, listOfBindings);
            parentContentController.releaseFcContent(oldComponent, true);
        }
        catch (NoSuchInterfaceException e) {
            throw new SCAException("Impossible to remove the fractal component", e);
        }
    }

    public void addBindings(Component component, List<Binding> listOfBindings) throws SCAException {
        try {
            BindingController cBindingController = Fractal.getBindingController(component);
            if (listOfBindings != null) {
                int i = 0;
                while (i < listOfBindings.size()) {
                    cBindingController.bindFc(listOfBindings.get(i).getClientInterfaceName(), listOfBindings.get(i).getServerInterface());
                    ++i;
                }
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new SCAException("Impossible to bind the fractal component", e);
        }
        catch (IllegalLifeCycleException e) {
            throw new SCAException("Impossible to bind the fractal component", e);
        }
        catch (IllegalBindingException e) {
            throw new SCAException("Impossible to bind the fractal component", e);
        }
    }

    public boolean isBinded(Component component, String clientItfName) throws SCAException {
        boolean res = true;
        try {
            BindingController cBindingController = Fractal.getBindingController(component);
            SCAComponent o = (SCAComponent)cBindingController.lookupFc(clientItfName);
            if (o == null) {
                res = false;
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new SCAException("Impossible to bind the fractal component", e);
        }
        return res;
    }

    public boolean isAlreadyBind(Component component, String clientItfName, ServiceReference<?> sr) throws SCAException {
        Interface itf = this.getBoundInterface(sr);
        return this.isAlreadyBind(component, clientItfName, itf);
    }

    public boolean isAlreadyBind(Component component, String clientItfName, Interface itf) throws SCAException {
        try {
            BindingController cBindingController = Fractal.getBindingController(component);
            Interface o = (Interface)cBindingController.lookupFc(clientItfName);
            return o == itf;
        }
        catch (NoSuchInterfaceException e) {
            throw new SCAException("Impossible to get the interface", e);
        }
    }

    public Map<String, Object> getListOfBindings(Component component) throws SCAException {
        HashMap<String, Object> res = new HashMap<String, Object>();
        try {
            BindingController cBindingController = Fractal.getBindingController(component);
            String[] binds = cBindingController.listFc();
            int i = 0;
            while (i < binds.length) {
                res.put(binds[i], cBindingController.lookupFc(cBindingController.listFc()[i]));
                ++i;
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new SCAException(e.getLocalizedMessage());
        }
        return res;
    }

    public List<String> getListOfBinds(Component component) throws SCAException {
        ArrayList<String> res = new ArrayList<String>();
        try {
            BindingController cBindingController = Fractal.getBindingController(component);
            int i = 0;
            while (i < cBindingController.listFc().length) {
                res.add(String.valueOf(cBindingController.listFc()[i]) + " link to " + cBindingController.lookupFc(cBindingController.listFc()[i]));
                ++i;
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new SCAException("Impossible to bind the fractal component", e);
        }
        return res;
    }

    public Component getParent(Component childrenComponent) throws SCAException {
        Component parent = null;
        try {
            SuperController superController = Fractal.getSuperController(childrenComponent);
            Component[] parents = superController.getFcSuperComponents();
            if (parents.length > 1) {
                throw new SCAException("This component (" + childrenComponent + ") has several parents: It is a shared component");
            }
            if (parents.length == 1) {
                parent = parents[0];
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new SCAException(e);
        }
        return parent;
    }

    public void deleteBindings(Component component, List<Binding> listOfBindings) throws SCAException {
        try {
            BindingController cBindingController = Fractal.getBindingController(component);
            if (listOfBindings != null) {
                int i = 0;
                while (i < listOfBindings.size()) {
                    Binding b = listOfBindings.get(i);
                    String cltItfName = b.getClientInterfaceName();
                    cBindingController.unbindFc(cltItfName);
                    ++i;
                }
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new SCAException("Impossible to bind the fractal component", e);
        }
        catch (IllegalLifeCycleException e) {
            throw new SCAException("Impossible to bind the fractal component", e);
        }
        catch (IllegalBindingException e) {
            throw new SCAException("Impossible to bind the fractal component", e);
        }
    }

    public void deleteAllClientBindingsOfComponent(Component component) throws SCAException {
        Map<String, Interface> map = this.getServerInterfacesLinkedToClientInterfacesOfComponent(component);
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        for (Map.Entry<String, Interface> entry : map.entrySet()) {
            bindings.add(new Binding(entry.getKey(), entry.getValue()));
        }
        this.deleteBindings(component, bindings);
    }

    public void deleteLinkWithAnItfClientOfComponent(Component component, String itfCLient) throws SCAException {
        Map<String, Interface> map = this.getServerInterfacesLinkedToClientInterfacesOfComponent(component);
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        for (Map.Entry<String, Interface> entry : map.entrySet()) {
            if (!entry.getKey().equals(itfCLient)) continue;
            bindings.add(new Binding(entry.getKey(), entry.getValue()));
            break;
        }
        this.deleteBindings(component, bindings);
    }

    public Component createExplorer(String fractalName, String fractalDefinition) throws SCAException {
        return null;
    }
}

