/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.Binding;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAComponentImpl;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.configuration.ConfigurationEngine;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalEnvironment;
import com.ebmwebsourcing.easyviper.core.api.marshalling.factory.MessageFactory;
import com.ebmwebsourcing.easyviper.core.api.model.Model;
import com.ebmwebsourcing.easyviper.core.api.soa.message.ExternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.impl.engine.EngineImpl;
import com.ebmwebsourcing.easyviper.core.impl.env.ExternalEnvironmentImpl;
import com.ebmwebsourcing.easyviper.extended.service.autoflush.api.AutoFlushMessageService;
import com.ebmwebsourcing.easyviper.extended.service.autoflush.impl.AutoFlushMessageServiceImpl;
import com.ebmwebsourcing.easyviper.extended.service.autotrash.api.AutoTrashProcessService;
import com.ebmwebsourcing.easyviper.extended.service.autotrash.impl.AutoTrashProcessServiceImpl;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.ow2.frascati.tinfi.api.control.ContentInstantiationException;
import org.ow2.frascati.tinfi.api.control.SCAContentController;

@Scope(value="COMPOSITE")
@Service(value={Core.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyCompositeWithContent"})
public class CoreImpl
extends SCAComponentImpl
implements Core {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_ENGINE_NAME = "WorkflowEngine";
    private Logger log = Logger.getLogger(CoreImpl.class.getCanonicalName());
    private Component engineComponent;
    private Component modelComponent;
    private Component externalEnvironmentComponent;
    private MessageFactory<ExternalMessage<?>, InternalMessage<?>> messageFactory;

    @Override
    public Engine createEngine(ConfigurationEngine conf, Class internalMessageType) throws CoreException {
        if (this.engineComponent != null) {
            throw new CoreException("Error: Workflow engine already exist!!!");
        }
        Engine engine = null;
        try {
            this.engineComponent = SCAHelper.getSCAHelper().createNewComponent(EngineImpl.class.getName(), null);
            SCAHelper.getSCAHelper().addComponent(this.engineComponent, this.getComponent(), null);
            SCAContentController scacc = (SCAContentController)this.engineComponent.getFcInterface("/sca-content-controller");
            try {
                engine = (Engine)scacc.getFcContent();
            }
            catch (ContentInstantiationException e) {
                throw new CoreException(e);
            }
            engine.setInternalMessageType(internalMessageType);
            if (!this.log.getName().equals(CoreImpl.class.getName())) {
                engine.setLog(this.log);
            }
            SCAHelper.getSCAHelper().startComponent(this.engineComponent);
            SCAHelper.getSCAHelper().changeName(this.engineComponent, DEFAULT_ENGINE_NAME);
            engine = (Engine)this.engineComponent.getFcInterface("service");
            if (conf.getAutoFlushMessageFrequency() != null && conf.getAutoFlushMessageFrequency() > 0) {
                AutoFlushMessageService autoFlush = engine.getServiceManager().getService(AutoFlushMessageServiceImpl.class);
                autoFlush.setRefreshFrequency(conf.getAutoFlushMessageFrequency());
                engine.getServiceManager().activateService(AutoFlushMessageServiceImpl.class);
            }
            if (conf.getAutoTrashProcessFrequency() != null && conf.getAutoTrashProcessFrequency() > 0) {
                AutoTrashProcessService autoTrash = engine.getServiceManager().getService(AutoTrashProcessServiceImpl.class);
                autoTrash.setRefreshFrequency(conf.getAutoTrashProcessFrequency());
                engine.getServiceManager().activateService(AutoTrashProcessServiceImpl.class);
            }
            if (conf.getAdditionnalServices() != null) {
                for (Class<? extends com.ebmwebsourcing.easyviper.core.api.engine.thread.service.Service> s : conf.getAdditionnalServices()) {
                    engine.getServiceManager().addService(s);
                }
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException(e);
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
        this.log.finest("workflow engine created and started");
        return engine;
    }

    @Override
    public Engine getEngine() throws CoreException {
        Engine res = null;
        try {
            if (this.engineComponent != null) {
                res = (Engine)this.engineComponent.getFcInterface("service");
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException(e);
        }
        return res;
    }

    @Override
    public Model createModel(String name, Class<? extends Model> modelClass) throws CoreException {
        if (this.modelComponent != null) {
            throw new CoreException("Error: Model already exist!!!");
        }
        Model model = null;
        try {
            this.modelComponent = SCAHelper.getSCAHelper().createNewComponent(modelClass.getName(), null);
            SCAHelper.getSCAHelper().addComponent(this.modelComponent, this.getComponent(), null);
            model = (Model)((SCAContentController)this.modelComponent.getFcInterface("/sca-content-controller")).getFcContent();
            if (!this.log.getName().equals(CoreImpl.class.getName())) {
                model.setLog(this.log);
            }
            SCAHelper.getSCAHelper().startComponent(this.modelComponent);
            SCAHelper.getSCAHelper().changeName(this.modelComponent, name);
            model = (Model)this.modelComponent.getFcInterface("service");
            if (model != null) {
                ArrayList<Binding> listOfBindings = new ArrayList<Binding>();
                listOfBindings.add(new Binding("model", (Interface)((Object)model)));
                SCAHelper.getSCAHelper().addBindings(this.engineComponent, listOfBindings);
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException(e);
        }
        catch (ContentInstantiationException e) {
            throw new CoreException(e);
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
        this.log.finest("model created and started");
        return model;
    }

    @Override
    public Model getModel() throws CoreException {
        Model res = null;
        try {
            if (this.modelComponent != null) {
                Object obj = this.modelComponent.getFcInterface("service");
                res = (Model)this.modelComponent.getFcInterface("service");
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException(e);
        }
        return res;
    }

    @Override
    public ExternalEnvironment createExternalEnvironment(String name) throws CoreException {
        ExternalEnvironment externalEnvironment = null;
        if (this.getEngine() == null) {
            throw new CoreException("You must create the engine before create an external environment!!!");
        }
        Component fractalExternalEnvironment = null;
        try {
            fractalExternalEnvironment = SCAHelper.getSCAHelper().createNewComponent(ExternalEnvironmentImpl.class.getName(), null);
            SCAHelper.getSCAHelper().addComponent(fractalExternalEnvironment, this.getComponent(), null);
            this.externalEnvironmentComponent = fractalExternalEnvironment;
            try {
                if (this.getEngine() != null) {
                    ArrayList<Binding> listOfBindings = new ArrayList<Binding>();
                    listOfBindings.add(new Binding("engine", (Interface)((Object)this.getEngine())));
                    SCAHelper.getSCAHelper().addBindings(this.externalEnvironmentComponent, listOfBindings);
                }
                SCAContentController scacc = (SCAContentController)fractalExternalEnvironment.getFcInterface("/sca-content-controller");
                try {
                    externalEnvironment = (ExternalEnvironment)scacc.getFcContent();
                }
                catch (ContentInstantiationException e) {
                    throw new CoreException(e);
                }
                if (!this.log.getName().equals(CoreImpl.class.getName())) {
                    externalEnvironment.setLog(this.log);
                }
                SCAHelper.getSCAHelper().startComponent(fractalExternalEnvironment);
                SCAHelper.getSCAHelper().changeName(fractalExternalEnvironment, name);
                externalEnvironment = (ExternalEnvironment)fractalExternalEnvironment.getFcInterface("service");
                ArrayList<Binding> listOfBindings = new ArrayList<Binding>();
                listOfBindings.add(new Binding("externalEnv", (Interface)((Object)externalEnvironment)));
                SCAHelper.getSCAHelper().addBindings(this.engineComponent, listOfBindings);
            }
            catch (NoSuchInterfaceException e) {
                throw new CoreException(e);
            }
            this.log.finest("external Environment created and started");
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
        return externalEnvironment;
    }

    @Override
    public ExternalEnvironment getExternalEnvironment() throws CoreException {
        ExternalEnvironment res = null;
        try {
            if (this.externalEnvironmentComponent != null) {
                Object obj = this.externalEnvironmentComponent.getFcInterface("service");
                res = (ExternalEnvironment)this.externalEnvironmentComponent.getFcInterface("service");
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException(e);
        }
        return res;
    }

    @Override
    public void setLog(Logger logger) {
        this.log = logger;
    }

    @Override
    public MessageFactory<ExternalMessage<?>, InternalMessage<?>> getMessageFactory() {
        return this.messageFactory;
    }

    @Override
    public void setMessageFactory(MessageFactory<ExternalMessage<?>, InternalMessage<?>> messageFactory) throws CoreException {
        this.messageFactory = messageFactory;
    }
}

