/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAComponent;
import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.Binding;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAComponentImpl;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.impl.engine.ExecutionMessage;
import com.ebmwebsourcing.easyviper.core.impl.engine.thread.ThreadExecution;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;
import org.oasisopen.sca.ServiceReference;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Service;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.fraclet.annotations.Lifecycle;
import org.objectweb.fractal.fraclet.types.Step;
import org.objectweb.fractal.julia.ComponentInterface;
import org.objectweb.fractal.julia.Interceptor;
import org.ow2.frascati.tinfi.oasis.ServiceReferenceImpl;

@org.oasisopen.sca.annotation.Scope(value="COMPOSITE")
@Service(value={Execution.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyPrimitive"})
public class ExecutionImpl
extends SCAComponentImpl
implements Execution {
    protected BlockingQueue<ExecutionMessage> executionMessages = new LinkedBlockingQueue<ExecutionMessage>();
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(ExecutionImpl.class.getName());
    private boolean stepByStep = false;
    private Execution.State currentState = Execution.State.INACTIVE;
    @Reference(name="currentTarget", required=false)
    private Node currentTarget;
    @Reference(name="parentExec", required=false)
    private Execution parent = null;
    @Reference(name="childs", required=false)
    private final List<Execution> childExecutions = new ArrayList<Execution>();
    private long speedTime;

    @Override
    public Node getCurrentTarget() {
        ServiceReference sr = (ServiceReference)((Object)this.currentTarget);
        if (sr != null) {
            ServiceReferenceImpl cri = (ServiceReferenceImpl)sr;
            Object service = cri._getDelegate();
            ComponentInterface ci = (ComponentInterface)service;
            Interceptor intercep = (Interceptor)ci.getFcItfImpl();
            Node itf = (Node)intercep.getFcItfDelegate();
            return itf;
        }
        return null;
    }

    @Override
    public Scope getParentScope() throws CoreException {
        Scope res = null;
        try {
            Component scopeComponent = SCAHelper.getSCAHelper().getParent(this.getComponent());
            res = (Scope)scopeComponent.getFcInterface("service");
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException(e);
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
        return res;
    }

    @Override
    public synchronized void run() throws CoreException {
        assert (this.currentTarget != null);
        this.init();
        if (this.currentTarget != null) {
            this.setNextExecutableElements(null, this.currentTarget);
            while (this.getState() != Execution.State.ENDED && this.getState() != Execution.State.CANCELLED && this.getState() != Execution.State.SUSPENDED) {
                this.step();
            }
        } else {
            throw new CoreException("Error initialization exception");
        }
    }

    @Override
    public void removeChildExecution(Execution execution) throws CoreException {
        if (execution != null) {
            try {
                Component exeComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getParentScope().getComponent(), (Interface)execution.getComponent().getFcInterface("service"), "service");
                if (exeComp != null) {
                    SCAHelper.getSCAHelper().deleteComponent(exeComp);
                }
            }
            catch (NoSuchInterfaceException e) {
                throw new CoreException(e);
            }
            catch (SCAException e) {
                throw new CoreException(e);
            }
        }
    }

    @Override
    public void end() throws CoreException {
        try {
            if (SCAHelper.getSCAHelper().isBinded(this.getComponent(), "currentTarget")) {
                ArrayList<Binding> listOfBindings = new ArrayList<Binding>();
                listOfBindings.add(new Binding("currentTarget", (Interface)this.currentTarget.getComponent().getFcInterface("service")));
                SCAHelper.getSCAHelper().deleteBindings(this.getComponent(), listOfBindings);
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException(e);
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
    }

    @Override
    public List<Execution> getChildExecutions() {
        ArrayList<Execution> res = new ArrayList<Execution>();
        res.addAll(this.childExecutions);
        return res;
    }

    @Override
    public Execution getParentExecution() {
        return this.parent;
    }

    @Override
    public Execution.State getState() {
        return this.currentState;
    }

    @Override
    public void setStateRecursively(Execution.State state) {
        this.setState(state);
        try {
            if (!this.getParentScope().getName().equals(this.getParentScope().getProcess().getName())) {
                Execution parentScopeExecution = this.getParentScope().getExecution();
                parentScopeExecution.setStateRecursively(state);
            } else if (this.getParentExecution() != null) {
                this.getParentExecution().setStateRecursively(state);
            }
        }
        catch (CoreException e) {
            this.log.severe("error: " + e.getMessage());
        }
    }

    @Override
    public void setState(Execution.State state) {
        this.currentState = state;
    }

    public Execution createChildExecution(String name) throws CoreException {
        Execution childExecution = this.getParentScope().createExecution(String.valueOf(this.getName()) + "_child_" + this.childExecutions.size());
        try {
            Component exeChildComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getParentScope().getComponent(), (Interface)((Object)childExecution), "service");
            SCAHelper.getSCAHelper().startComponent(exeChildComp);
            childExecution.setStepByStep(this.stepByStep);
            childExecution.setSpeedTime(this.speedTime);
            this.log.finest("creating " + childExecution.getName());
            this.addExecution(childExecution);
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
        return childExecution;
    }

    @Override
    public void addExecution(Execution childExecution) throws CoreException {
        try {
            ArrayList<Binding> listOfBindings = new ArrayList<Binding>();
            listOfBindings.add(new Binding("childs_" + String.valueOf(this.childExecutions.size()), (Interface)childExecution.getComponent().getFcInterface("service")));
            SCAHelper.getSCAHelper().addBindings(this.getComponent(), listOfBindings);
            listOfBindings = new ArrayList();
            listOfBindings.add(new Binding("parentExec", (Interface)this.getComponent().getFcInterface("service")));
            SCAHelper.getSCAHelper().addBindings(childExecution.getComponent(), listOfBindings);
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException(e);
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
    }

    @Override
    public void removeChildExecutions() throws CoreException {
        Execution child = null;
        while (this.childExecutions != null && this.childExecutions.size() > 0) {
            child = this.childExecutions.iterator().next();
            this.log.finest("remove execution: " + child.getName());
            this.removeChildExecution(child);
        }
    }

    public void setParent(Execution parent) {
        this.parent = parent;
    }

    @Override
    public final boolean hasNextExecutableElement() {
        return !this.executionMessages.isEmpty();
    }

    @Override
    public final void setNextExecutableElements(SCAComponent sender, Collection<? extends Node> nextExecutableElements) {
        assert (nextExecutableElements != null);
        this.executionMessages.add(new ExecutionMessage(sender, nextExecutableElements));
    }

    @Override
    public final void setNextExecutableElements(SCAComponent sender, Node nextExecutableElement) {
        this.setNextExecutableElements(sender, (Collection<? extends Node>)Collections.singletonList(nextExecutableElement));
    }

    private final void notifyParentExecution() throws CoreException {
        this.getParentExecution().setNextExecutableElements((SCAComponent)this, this.getParentExecution().getCurrentTarget());
    }

    @Override
    public final synchronized void step() throws CoreException {
        block16: {
            if (this.getState().equals((Object)Execution.State.ENDED)) {
                return;
            }
            try {
                ExecutionMessage nextExecutionMessage;
                ExecutionMessage executionMessage = this.executionMessages.take();
                Collection<? extends Node> nextExecutableElements = executionMessage.getNextExecutableElements();
                SCAComponent sender = executionMessage.getSender();
                if (sender != null && sender instanceof Execution) {
                    this.removeChildExecution((Execution)sender);
                }
                if (nextExecutableElements.size() == 1) {
                    this.nextSequentially(nextExecutableElements.iterator().next());
                } else if (nextExecutableElements.size() > 1) {
                    try {
                        this.nextConcurrently(nextExecutableElements);
                    }
                    catch (NoSuchInterfaceException e) {
                        throw new CoreException(e);
                    }
                }
                if (!this.hasNextExecutableElement() && this.getChildExecutions().isEmpty() && this.getState() != Execution.State.SUSPENDED && this.getState() != Execution.State.CANCELLED) {
                    this.currentTarget.selectDefaultNextTarget();
                }
                if ((nextExecutionMessage = (ExecutionMessage)this.executionMessages.peek()) == null) {
                    return;
                }
                Collection<? extends Node> after = nextExecutionMessage.getNextExecutableElements();
                if (!after.isEmpty()) {
                    return;
                }
                this.executionMessages.clear();
                this.setState(Execution.State.ENDED);
                if (this.getParentExecution() != null) {
                    this.notifyParentExecution();
                    break block16;
                }
                Process p = null;
                try {
                    Scope parentScope = this.getParentScope();
                    Component parentScopeComp = parentScope.getComponent();
                    p = (Process)parentScopeComp.getFcInterface("service");
                    p = (Process)this.getParentScope().getComponent().getFcInterface("service");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (p != null && p.getState().equals((Object)Process.State.PROCESS_ACTIVE)) {
                    p.end(false);
                }
            }
            catch (InterruptedException ie) {
                throw new CoreException(ie);
            }
        }
    }

    private final void nextSequentially(Node nextExecutableElement) throws CoreException {
        this.execute(nextExecutableElement);
    }

    private final void nextConcurrently(Collection<? extends Node> nextExecutableElements) throws CoreException, NoSuchInterfaceException {
        try {
            for (Node node : nextExecutableElements) {
                Execution childExecution = this.createChildExecution(String.valueOf(this.getName()) + "_child_" + this.childExecutions.size());
                Component targetComp = SCAHelper.getSCAHelper().getComponentByInterface(SCAHelper.getSCAHelper().getParent(this.getComponent()), (ServiceReference)((Object)node), "service");
                if (!SCAHelper.getSCAHelper().isAlreadyBind(childExecution.getComponent(), "currentTarget", (ServiceReference)((Object)node))) {
                    this.getParentScope().linkedExecution2ExecutableElement((Execution)childExecution.getComponent().getFcInterface("service"), node);
                }
                if (!SCAHelper.getSCAHelper().isAlreadyBind(targetComp, "execution", (Interface)((Object)((Execution)childExecution.getComponent().getFcInterface("service"))))) {
                    this.getParentScope().linkedExecutableElement2Execution((Node)targetComp.getFcInterface("service"), (Execution)childExecution.getComponent().getFcInterface("service"));
                }
                childExecution.setStepByStep(this.isStepByStep());
                ThreadExecution threadChildExecution = new ThreadExecution(childExecution);
                threadChildExecution.start();
            }
        }
        catch (SCAException sCAException) {
            throw new CoreException(sCAException);
        }
    }

    public synchronized void execute(Node execElmt) throws CoreException {
        this.log.finest("Entering in execute method");
        try {
            if (execElmt != null) {
                Node target = null;
                if (execElmt instanceof ServiceReference) {
                    ServiceReference sr = (ServiceReference)((Object)execElmt);
                    target = (Node)((Object)SCAHelper.getSCAHelper().getBoundInterface(sr));
                } else {
                    target = execElmt;
                }
                Component targetComp = SCAHelper.getSCAHelper().getComponentByInterface(SCAHelper.getSCAHelper().getParent(this.getComponent()), (Interface)((Object)target), "service");
                SCAHelper.getSCAHelper().deleteLinkWithAnItfClientOfComponent(this.getComponent(), "currentTarget");
                if (targetComp != null && !SCAHelper.getSCAHelper().isStarted(targetComp)) {
                    SCAHelper.getSCAHelper().startComponent(targetComp);
                }
                this.log.finest("run the next elmt for execution: " + this.getName() + " => " + target.getName());
                if (!SCAHelper.getSCAHelper().isAlreadyBind(this.getComponent(), "currentTarget", (Interface)((Object)target))) {
                    this.getParentScope().linkedExecution2ExecutableElement((Execution)this.getComponent().getFcInterface("service"), target);
                }
                if (!SCAHelper.getSCAHelper().isAlreadyBind(targetComp, "execution", (Interface)((Object)((Execution)this.getComponent().getFcInterface("service"))))) {
                    this.getParentScope().linkedExecutableElement2Execution((Node)targetComp.getFcInterface("service"), (Execution)this.getComponent().getFcInterface("service"));
                }
                execElmt.execute();
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException(e);
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
        this.log.finest("Exit of execute method");
    }

    @Override
    public long getSpeedTime() {
        return this.speedTime;
    }

    @Override
    public void setSpeedTime(long time) {
        this.speedTime = time;
    }

    @Override
    public void runSlowly(long time) throws CoreException {
        this.setSpeedTime(time);
        this.run();
    }

    public void init() throws CoreException {
        try {
            Component targetComp = SCAHelper.getSCAHelper().getComponentByInterface(SCAHelper.getSCAHelper().getParent(this.getComponent()), (ServiceReference)((Object)this.currentTarget), "service");
            if (targetComp != null && !SCAHelper.getSCAHelper().isStarted(targetComp)) {
                SCAHelper.getSCAHelper().startComponent(targetComp);
            }
            this.setState(Execution.State.ACTIVE);
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
    }

    @Override
    public void runStepByStep() throws CoreException {
        this.stepByStep = true;
        this.init();
        if (this.currentTarget == null) {
            throw new CoreException("Error initialization exception");
        }
        this.setNextExecutableElements(null, this.currentTarget);
    }

    @Override
    public synchronized void signal() throws CoreException {
        this.step();
    }

    @Override
    public boolean isStepByStep() {
        return this.stepByStep;
    }

    @Override
    public void setStepByStep(boolean stepByStep) {
        this.stepByStep = stepByStep;
    }

    @Override
    public void setLog(Logger logger) {
        this.log = logger;
    }

    @Override
    @Lifecycle(step=Step.DESTROY)
    public void destroySCAComponent() throws SCAException {
        this.log.fine("Fractal execution destroyed: " + this.getName());
        this.setState(Execution.State.CANCELLED);
    }

    public String toString() {
        String res = super.toString();
        if (this.getName() != null) {
            res = this.getName();
        }
        return res;
    }
}

