/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.Binding;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.AssignBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.EmptyBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.ExitBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.ForkBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.IfBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.LoopBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.ReceiverBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.ScopeBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.SenderBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.WaitBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.Fault;
import com.ebmwebsourcing.easyviper.core.api.engine.handler.TerminationHandler;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.soa.Endpoint;
import com.ebmwebsourcing.easyviper.core.api.soa.correlation.CorrelationGroup;
import com.ebmwebsourcing.easyviper.core.impl.engine.ExecutionImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.NodeImpl;
import com.ebmwebsourcing.easyviper.tools.InstanceOfUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.oasisopen.sca.ServiceReference;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Service;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.ow2.frascati.tinfi.api.control.ContentInstantiationException;
import org.ow2.frascati.tinfi.api.control.SCAContentController;

@org.oasisopen.sca.annotation.Scope(value="COMPOSITE")
@Service(value={Scope.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyCompositeWithContent"})
public class ScopeImpl
extends NodeImpl
implements Scope {
    private static final long serialVersionUID = 1L;
    private static int cpt_childsNode = 0;
    private static int cpt_incomingNode = 0;
    private static int cpt_outgoingNode = 0;
    private static Logger log = Logger.getLogger(ScopeImpl.class.getName());
    protected Component initialNode;
    protected Component parentExecution;
    protected Map<Fault, Scope> exceptions = new HashMap<Fault, Scope>();
    protected Map<Object, Endpoint> endpoints = new HashMap<Object, Endpoint>();
    protected List<CorrelationGroup> correlationGroups = new ArrayList<CorrelationGroup>();
    protected Exception faultScope = null;
    protected TerminationHandler th = null;
    private final Map<QName, Variable> variables = new HashMap<QName, Variable>();

    @Override
    public Node createNode(String behaviourName, Behaviour behaviourContext) throws CoreException {
        log.finest("start create node");
        Node node = null;
        String nodeName = null;
        try {
            if (behaviourName == null) {
                behaviourName = this.getActivityName(behaviourContext);
                nodeName = "node_supporting_" + behaviourName + "_" + this.getAllNodes().size();
            } else {
                nodeName = "node_supporting_" + behaviourName;
            }
            Component fractalNode = SCAHelper.getSCAHelper().createNewComponent(NodeImpl.class.getName(), null);
            SCAHelper.getSCAHelper().addComponent(fractalNode, this.getComponent(), null);
            SCAContentController scacc = (SCAContentController)fractalNode.getFcInterface("/sca-content-controller");
            try {
                node = (Node)scacc.getFcContent();
            }
            catch (ContentInstantiationException e) {
                throw new CoreException(e);
            }
            node.setName(nodeName);
            if (!log.getName().equals(ScopeImpl.class.getName())) {
                node.setLog(log);
            }
            node = (Node)fractalNode.getFcInterface("service");
            Component fractalBehaviour = SCAHelper.getSCAHelper().createNewComponent(behaviourContext.getClass().getName(), behaviourContext.getInitializationContext());
            SCAHelper.getSCAHelper().changeName(fractalBehaviour, behaviourName);
            SCAHelper.getSCAHelper().addComponent(fractalBehaviour, this.getComponent(), null);
            Behaviour behaviour = null;
            scacc = (SCAContentController)fractalBehaviour.getFcInterface("/sca-content-controller");
            try {
                behaviour = (Behaviour)scacc.getFcContent();
            }
            catch (ContentInstantiationException e) {
                throw new CoreException(e);
            }
            behaviour.setInitializationContext(behaviourContext.getInitializationContext());
            if (!log.getName().equals(ScopeImpl.class.getName())) {
                behaviour.setLog(log);
            }
            behaviour = (Behaviour)fractalBehaviour.getFcInterface("service");
            this.linkedNodeAndFunctionnalBehaviour(node, behaviour);
            log.fine("Creation of the fractal node: " + behaviourName);
        }
        catch (NoSuchInterfaceException e) {
            log.severe(e.getMessage());
            throw new CoreException(e);
        }
        catch (SCAException e) {
            log.severe(e.getMessage());
            throw new CoreException(e);
        }
        log.finest("end of create node");
        return node;
    }

    private String getActivityName(Behaviour behaviourContext) {
        String res = "unknownactivity";
        if (behaviourContext instanceof AssignBehaviour) {
            res = "assign";
        } else if (behaviourContext instanceof EmptyBehaviour) {
            res = "empty";
        } else if (behaviourContext instanceof ExitBehaviour) {
            res = "exit";
        } else if (behaviourContext instanceof ForkBehaviour) {
            res = "flow";
        } else if (behaviourContext instanceof LoopBehaviour) {
            res = "loop";
        } else if (behaviourContext instanceof IfBehaviour) {
            res = "if";
        } else if (behaviourContext instanceof SenderBehaviour) {
            res = "sender";
        } else if (behaviourContext instanceof ReceiverBehaviour) {
            res = "receiver";
        } else if (behaviourContext instanceof ScopeBehaviour) {
            res = "scope";
        } else if (behaviourContext instanceof WaitBehaviour) {
            res = "wait";
        }
        return res;
    }

    @Override
    public Node getInitialNode() throws CoreException {
        Node res = null;
        try {
            if (this.initialNode != null) {
                res = (Node)this.initialNode.getFcInterface("service");
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException(e);
        }
        return res;
    }

    public Node getNode(String name) throws CoreException {
        Node res = null;
        try {
            List<Component> comps = SCAHelper.getSCAHelper().getComponentsByName(this.getComponent(), name);
            ArrayList<Node> nodes = new ArrayList<Node>();
            if (comps != null) {
                for (Component comp : comps) {
                    if (!(comp.getFcInterface("service") instanceof Node)) continue;
                    nodes.add((Node)comp.getFcInterface("service"));
                }
            }
            if (nodes.size() > 1) {
                throw new CoreException("Several node components are the same name");
            }
            if (nodes.size() > 0) {
                res = (Node)nodes.get(0);
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException(e);
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
        return res;
    }

    @Override
    public void deleteExecution(Execution exec) throws CoreException {
        ArrayList<Binding> listOfBindings = new ArrayList<Binding>();
        try {
            listOfBindings.add(new Binding("service", (Interface)exec.getComponent().getFcInterface("service")));
            SCAHelper.getSCAHelper().deleteBindings(this.getComponent(), listOfBindings);
            SCAHelper.getSCAHelper().deleteComponent(exec.getComponent());
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException("impossible to delete binding", e);
        }
        catch (SCAException e) {
            throw new CoreException("impossible to delete binding", e);
        }
    }

    @Override
    public void stopAllExecutions() throws CoreException {
        try {
            for (Execution execution : this.getParentExecution().getChildExecutions()) {
                execution.stopSCAComponent();
            }
            this.getParentExecution().stopSCAComponent();
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
    }

    @Override
    public void end(boolean clean) throws CoreException {
        try {
            if (this.th != null) {
                this.th.end(this);
            }
            if (clean) {
                log.finest("clean all scopes");
                this.cleanScopes(this);
                log.finest("stop all sub components");
                SCAHelper.getSCAHelper().stopAllSubComponents(this.getComponent());
            }
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
    }

    protected void cleanScopes(Scope scope) throws CoreException {
        for (Scope faultScope : scope.getExceptions().values()) {
            this.cleanScopes(faultScope);
        }
        scope.setFaultScope(null);
        this.cleanVariables(scope);
        this.cleanBehaviours(scope);
        try {
            log.finest("remove all executions");
            if (scope.getParentExecution() != null) {
                scope.getParentExecution().removeChildExecutions();
                Component exeComp = SCAHelper.getSCAHelper().getComponentByInterface(scope.getComponent(), (Interface)((Object)scope.getParentExecution()), "service");
                if (exeComp != null) {
                    SCAHelper.getSCAHelper().deleteComponent(exeComp);
                }
            }
            scope.setParentExecution(null);
            List<Component> components = SCAHelper.getSCAHelper().getComponents(scope.getComponent());
            for (Component component : components) {
                if (!SCAHelper.getSCAHelper().isStarted(component)) continue;
                try {
                    if (!(component.getFcInterface("service") instanceof Scope)) continue;
                    Scope underScope = (Scope)component.getFcInterface("service");
                    this.cleanScopes(underScope);
                }
                catch (NoSuchInterfaceException noSuchInterfaceException) {
                    // empty catch block
                }
            }
        }
        catch (CoreException e) {
            throw new CoreException(e);
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
    }

    private void cleanBehaviours(Scope scope) throws CoreException {
        try {
            List<Component> components = SCAHelper.getSCAHelper().getComponents(scope.getComponent());
            for (Component component : components) {
                if (!SCAHelper.getSCAHelper().isStarted(component)) continue;
                try {
                    Behaviour behaviour = (Behaviour)component.getFcInterface("service");
                    behaviour.setState(Behaviour.State.ACTIVITY_ENDED);
                    if (!(behaviour instanceof ReceiverBehaviour)) continue;
                    ((ReceiverBehaviour)behaviour).setMessage(null);
                }
                catch (NoSuchInterfaceException noSuchInterfaceException) {
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
    }

    private void cleanVariables(Scope scope) throws CoreException {
        log.finest("Clean all variables of scope: " + scope.getName());
        for (Variable var : scope.getVariables().values()) {
            var.setValue(null);
        }
    }

    @Override
    public boolean removeNode(Node node) throws CoreException {
        boolean res = true;
        try {
            Component nodeComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)((Object)node), "service");
            Node child = null;
            String clientItfName = "childNodes_";
            Map<String, Interface> map = SCAHelper.getSCAHelper().getServerInterfacesLinkedToClientInterfacesOfComponent(nodeComp);
            Iterator<Map.Entry<String, Interface>> entries = map.entrySet().iterator();
            Map.Entry<String, Interface> entry = null;
            while (entries != null && entries.hasNext()) {
                entry = entries.next();
                if (!entry.getKey().startsWith("childNodes_")) continue;
                child = (Node)((Object)entry.getValue());
                this.removeNode(child);
                map = SCAHelper.getSCAHelper().getServerInterfacesLinkedToClientInterfacesOfComponent(nodeComp);
                entries = map.entrySet().iterator();
            }
            SCAHelper.getSCAHelper().deleteComponent(nodeComp);
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
        return true;
    }

    @Override
    public void setInitialNode(Node initial) throws CoreException {
        try {
            this.initialNode = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)((Object)initial), "service");
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
    }

    @Override
    public Execution getParentExecution() throws CoreException {
        Execution res = null;
        try {
            if (this.parentExecution != null) {
                res = (Execution)this.parentExecution.getFcInterface("service");
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException(e);
        }
        return res;
    }

    @Override
    public List<Node> getAllNodes() throws CoreException {
        ArrayList<Node> nodes = new ArrayList<Node>();
        try {
            List<Component> comps = SCAHelper.getSCAHelper().getComponents(this.getComponent());
            for (Component component : comps) {
                try {
                    if (!(component.getFcInterface("service") instanceof Node)) continue;
                    nodes.add((Node)component.getFcInterface("service"));
                }
                catch (NoSuchInterfaceException noSuchInterfaceException) {
                    // empty catch block
                }
            }
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
        return nodes;
    }

    @Override
    public List<Scope> getAllScopes() throws CoreException {
        ArrayList<Scope> scope = new ArrayList<Scope>();
        try {
            List<Component> comps = SCAHelper.getSCAHelper().getComponents(this.getComponent());
            for (Component component : comps) {
                try {
                    if (!(component.getFcInterface("service") instanceof Scope)) continue;
                    scope.add((Scope)component.getFcInterface("service"));
                }
                catch (NoSuchInterfaceException noSuchInterfaceException) {
                    // empty catch block
                }
            }
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
        return scope;
    }

    @Override
    public Node getNodeByName(String name) throws CoreException {
        Node res = null;
        try {
            List<Component> comps = SCAHelper.getSCAHelper().getComponentsByName(this.getComponent(), name);
            ArrayList<Node> nodes = new ArrayList<Node>();
            if (comps != null) {
                for (Component comp : comps) {
                    if (!(comp.getFcInterface("service") instanceof Node)) continue;
                    nodes.add((Node)comp.getFcInterface("service"));
                }
            }
            if (nodes.size() > 1) {
                throw new CoreException("Several node components are the same name");
            }
            if (nodes.size() > 0) {
                res = (Node)nodes.get(0);
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException(e);
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
        return res;
    }

    @Override
    public void linkedNodeAndFunctionnalBehaviour(Node targetNode, Behaviour behaviour) throws CoreException {
        try {
            if (behaviour != null && targetNode != null) {
                Component targetComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)((Object)targetNode), "service");
                Component activityComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)((Object)behaviour), "service");
                if (targetComp == null || activityComp == null) {
                    throw new CoreException("Impossible to link node to a transition");
                }
                ArrayList<Binding> listOfBindings = new ArrayList<Binding>();
                listOfBindings.add(new Binding("behaviour", (Interface)activityComp.getFcInterface("service")));
                SCAHelper.getSCAHelper().addBindings(targetComp, listOfBindings);
                listOfBindings = new ArrayList();
                listOfBindings.add(new Binding("node", (Interface)targetComp.getFcInterface("service")));
                SCAHelper.getSCAHelper().addBindings(activityComp, listOfBindings);
            }
        }
        catch (NoSuchInterfaceException e) {
            log.finest(e.getMessage());
            throw new CoreException(e);
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
    }

    @Override
    public void unlinkedNodeAndFunctionnalBehaviour(Node targetNode, Behaviour behaviour) throws CoreException {
        try {
            if (behaviour != null && targetNode != null) {
                Component targetComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)((Object)targetNode), "service");
                Component activityComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)((Object)behaviour), "service");
                if (targetComp == null || activityComp == null) {
                    throw new CoreException("Impossible to link node to a transition");
                }
                ArrayList<Binding> listOfBindings = new ArrayList<Binding>();
                listOfBindings.add(new Binding("behaviour", (Interface)activityComp.getFcInterface("service")));
                SCAHelper.getSCAHelper().deleteBindings(targetComp, listOfBindings);
                listOfBindings = new ArrayList();
                listOfBindings.add(new Binding("node", (Interface)targetComp.getFcInterface("service")));
                SCAHelper.getSCAHelper().deleteBindings(activityComp, listOfBindings);
            }
        }
        catch (NoSuchInterfaceException e) {
            log.finest(e.getMessage());
            throw new CoreException(e);
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
    }

    @Override
    public void unlinkedNodeAndExecution(Node targetNode, Execution execution) throws CoreException {
        try {
            if (execution != null && targetNode != null) {
                Component targetComp = null;
                targetComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)((Object)targetNode), "service");
                Component execComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)((Object)execution), "service");
                if (targetComp == null || execComp == null) {
                    throw new CoreException("Impossible to unlink node to the execution ");
                }
                ArrayList<Binding> listOfBindings = new ArrayList<Binding>();
                listOfBindings.add(new Binding("execution", (Interface)execComp.getFcInterface("service")));
                SCAHelper.getSCAHelper().deleteBindings(targetComp, listOfBindings);
                listOfBindings = new ArrayList();
                listOfBindings.add(new Binding("currentTarget", (Interface)targetComp.getFcInterface("service")));
                SCAHelper.getSCAHelper().deleteBindings(execComp, listOfBindings);
            }
        }
        catch (NoSuchInterfaceException e) {
            log.finest(e.getMessage());
            throw new CoreException(e);
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
    }

    @Override
    public Node unlinkBrotherNodes(Node sourceNode, Node targetNode) throws CoreException {
        Node res = null;
        try {
            Map<String, Object> mapOfBindings = SCAHelper.getSCAHelper().getListOfBindings(sourceNode.getComponent());
            Node afterNode = null;
            String afterName = null;
            for (Map.Entry<String, Object> e : mapOfBindings.entrySet()) {
                if (!e.getKey().startsWith("outgoingNodes")) continue;
                afterName = e.getKey();
                afterNode = (Node)e.getValue();
                break;
            }
            res = afterNode;
            List<Component> cs = SCAHelper.getSCAHelper().getClientComponentsLinkedToServerInterfacesOfComponent(this.getComponent(), (Interface)sourceNode.getComponent().getFcInterface("service"));
            ArrayList<Boolean> started = new ArrayList<Boolean>();
            for (Component css : cs) {
                if (!SCAHelper.getSCAHelper().isStarted(css)) {
                    SCAHelper.getSCAHelper().startComponent(css);
                    started.add(Boolean.FALSE);
                    continue;
                }
                started.add(Boolean.TRUE);
            }
            Binding b = new Binding(afterName, (Interface)afterNode.getComponent().getFcInterface("service"));
            ArrayList<Binding> bindToDelete = new ArrayList<Binding>();
            bindToDelete.add(b);
            SCAHelper.getSCAHelper().deleteBindings(sourceNode.getComponent(), bindToDelete);
            int i = 0;
            for (Component css : cs) {
                if (!((Boolean)started.get(i)).booleanValue()) {
                    SCAHelper.getSCAHelper().stopComponent(css);
                }
                ++i;
            }
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException(e);
        }
        return res;
    }

    @Override
    public void linkedBrotherNodes(Node sourceNode, Node targetNode) throws CoreException {
        try {
            Component sourceComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)((Object)sourceNode), "service");
            Component targetComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)((Object)targetNode), "service");
            if (sourceComp == null || targetComp == null) {
                throw new CoreException("Impossible to link brother nodes");
            }
            ArrayList<Binding> listOfBindings = new ArrayList<Binding>();
            listOfBindings.add(new Binding("incomingNodes_" + this.formatCounter(cpt_incomingNode), (Interface)sourceComp.getFcInterface("service")));
            SCAHelper.getSCAHelper().addBindings(targetComp, listOfBindings);
            ++cpt_incomingNode;
            listOfBindings = new ArrayList();
            listOfBindings.add(new Binding("outgoingNodes" + this.formatCounter(cpt_outgoingNode), (Interface)targetComp.getFcInterface("service")));
            SCAHelper.getSCAHelper().addBindings(sourceComp, listOfBindings);
            ++cpt_outgoingNode;
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException(e);
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
    }

    @Override
    public void linkedChildNodeToParent(Node parentNode, Node childrenNode) throws CoreException {
        try {
            Component parentComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)((Object)parentNode), "service");
            Component childrenComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)((Object)childrenNode), "service");
            if (parentComp == null || childrenComp == null) {
                throw new CoreException("Impossible to link parent and children node");
            }
            ArrayList<Binding> listOfBindings = new ArrayList<Binding>();
            listOfBindings.add(new Binding("childNodes_" + this.formatCounter(cpt_childsNode), (Interface)childrenComp.getFcInterface("service")));
            SCAHelper.getSCAHelper().addBindings(parentComp, listOfBindings);
            ++cpt_childsNode;
            listOfBindings = new ArrayList();
            listOfBindings.add(new Binding("parentNode", (Interface)parentComp.getFcInterface("service")));
            SCAHelper.getSCAHelper().addBindings(childrenComp, listOfBindings);
            SCAContentController scacc = (SCAContentController)childrenComp.getFcInterface("/sca-content-controller");
            NodeImpl nodeContent = null;
            try {
                nodeContent = (NodeImpl)scacc.getFcContent();
            }
            catch (ContentInstantiationException e) {
                throw new CoreException(e);
            }
            if (nodeContent.getParentNode() == null) {
                nodeContent.setParentNode(parentNode);
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException(e);
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
    }

    @Override
    public void linkedExecution2ExecutableElement(Execution exe, Node target) throws CoreException {
        try {
            Component targetComp = null;
            targetComp = target instanceof Interface ? SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)((Object)target), "service") : SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (ServiceReference)((Object)target), "service");
            Component exeComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)((Object)exe), "service");
            if (exeComp == null || targetComp == null) {
                throw new CoreException("Impossible to link the execution and the target node: exeComp = " + exeComp + " or targetComp = " + targetComp);
            }
            ArrayList<Binding> listOfBindings = new ArrayList<Binding>();
            listOfBindings.add(new Binding("currentTarget", (Interface)targetComp.getFcInterface("service")));
            if (SCAHelper.getSCAHelper().isBinded(exeComp, "currentTarget")) {
                throw new CoreException("Execution already bind");
            }
            SCAHelper.getSCAHelper().addBindings(exeComp, listOfBindings);
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException(e);
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
    }

    @Override
    public void linkedExecutableElement2Execution(Node source, Execution exe) throws CoreException {
        try {
            Component sourceComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)((Object)source), "service");
            Component exeComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)((Object)exe), "service");
            if (exeComp == null || sourceComp == null) {
                throw new CoreException("Impossible to link the axecution and the target node");
            }
            if (!SCAHelper.getSCAHelper().isBinded(sourceComp, "execution")) {
                ArrayList<Binding> listOfBindings = new ArrayList<Binding>();
                listOfBindings = new ArrayList();
                listOfBindings.add(new Binding("execution", (Interface)exeComp.getFcInterface("service")));
                SCAHelper.getSCAHelper().addBindings(sourceComp, listOfBindings);
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException(e);
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
    }

    @Override
    public synchronized Execution createExecution(String execName) throws CoreException {
        log.finest("start the creation of execution: " + execName);
        Execution execution = null;
        Component fractalExecution = null;
        try {
            fractalExecution = SCAHelper.getSCAHelper().createNewComponent(ExecutionImpl.class.getName(), null);
            SCAHelper.getSCAHelper().addComponent(fractalExecution, this.getComponent(), null);
            SCAHelper.getSCAHelper().changeName(fractalExecution, execName);
            SCAContentController scacc = (SCAContentController)fractalExecution.getFcInterface("/sca-content-controller");
            try {
                execution = (Execution)scacc.getFcContent();
            }
            catch (ContentInstantiationException e) {
                throw new CoreException(e);
            }
            if (!log.getName().equals(ScopeImpl.class.getName())) {
                execution.setLog(log);
            }
            execution = (Execution)fractalExecution.getFcInterface("service");
            log.finest("execution created: " + execName);
            if (this.getParentExecution() == null) {
                log.finest(String.valueOf(execName) + " is a parent execution");
                this.parentExecution = fractalExecution;
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException(e);
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
        return execution;
    }

    @Override
    public Map<QName, Variable> getVariables() {
        return this.variables;
    }

    @Override
    public Variable findVariable(QName name) throws CoreException {
        Variable v = null;
        v = this.variables.get(name);
        if (v == null) {
            Scope current = this.getParentScope(this);
            while (v == null && current != null) {
                v = current.getVariables().get(name);
                current = this.getParentScope(current);
            }
        }
        return v;
    }

    @Override
    public List<CorrelationGroup> findCorrelationGroups(String name) throws CoreException {
        ArrayList<CorrelationGroup> res = new ArrayList<CorrelationGroup>();
        for (CorrelationGroup correlationGroup : this.correlationGroups) {
            if (correlationGroup.getCorrelations().get(name) == null) continue;
            res.add(correlationGroup);
        }
        Scope current = this.getParentScope(this);
        if (current != null) {
            res.addAll(current.findCorrelationGroups(name));
            current = this.getParentScope(current);
        }
        return res;
    }

    @Override
    public Endpoint findEndpoint(Object key) throws CoreException {
        Endpoint ep = null;
        ep = this.endpoints.get(key);
        if (ep == null) {
            Scope current = this.getParentScope(this);
            while (ep == null && current != null) {
                ep = current.getEndpoints().get(key);
                current = this.getParentScope(current);
            }
        }
        return ep;
    }

    @Override
    public Object findEndpointKey(Endpoint edp) {
        Object key = null;
        for (Map.Entry<Object, Endpoint> currentEntry : this.getEndpoints().entrySet()) {
            if (!currentEntry.getValue().equals(edp)) continue;
            return currentEntry.getKey();
        }
        return key;
    }

    @Override
    public <B extends Behaviour> List<B> findBehaviours(Class<B> behaviourClass) throws CoreException {
        return ScopeImpl.findBehaviours(behaviourClass, this.getComponent(), false);
    }

    public static <B extends Behaviour> List<B> findBehaviours(Class<B> behaviourClass, Component comp, boolean ignoreStopComponent) throws CoreException {
        ArrayList<Behaviour> behaviours = new ArrayList<Behaviour>();
        try {
            List<Component> components = SCAHelper.getSCAHelper().getAllSubComponents(comp);
            for (Component component : components) {
                boolean isStarted = SCAHelper.getSCAHelper().isStarted(component);
                try {
                    Behaviour behaviour = (Behaviour)component.getFcInterface("service");
                    if (InstanceOfUtil.isClassExtendOfClass2found(behaviour.getClass(), behaviourClass)) {
                        if (ignoreStopComponent) {
                            behaviours.add(behaviour);
                        } else if (isStarted) {
                            behaviours.add(behaviour);
                        }
                    }
                }
                catch (NoSuchInterfaceException noSuchInterfaceException) {
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                try {
                    if (!(component.getFcInterface("service") instanceof Scope)) continue;
                    behaviours.addAll(ScopeImpl.findBehaviours(behaviourClass, component, ignoreStopComponent));
                }
                catch (NoSuchInterfaceException noSuchInterfaceException) {
                    // empty catch block
                }
            }
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
        return behaviours;
    }

    @Override
    public void setVariable(Variable v) throws CoreException {
        Scope current = this;
        Variable var = current.getVariables().get(v.getQName());
        if (var == null) {
            while (var == null && current != null) {
                var = current.getVariables().get(v.getQName());
                current = this.getParentScope();
            }
        }
        if (current != null) {
            current.getVariables().put(v.getQName(), v);
        } else {
            this.getVariables().put(v.getQName(), v);
        }
    }

    @Override
    public Scope getParentScope() throws CoreException {
        Scope parent = null;
        try {
            Component parentComp;
            if (!(this instanceof Process) && (parentComp = SCAHelper.getSCAHelper().getParent(this.getComponent())) != null) {
                try {
                    parent = (Process)parentComp.getFcInterface("service");
                }
                catch (NoSuchInterfaceException e) {
                    parent = (Scope)parentComp.getFcInterface("service");
                }
                catch (ClassCastException e) {
                    parent = (Scope)parentComp.getFcInterface("service");
                }
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException(e);
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
        return parent;
    }

    private Scope getParentScope(Scope child) throws CoreException {
        Scope parent = null;
        try {
            Component parentComp;
            if (!(child instanceof Process) && (parentComp = SCAHelper.getSCAHelper().getParent(child.getComponent())) != null) {
                parent = (Scope)parentComp.getFcInterface("service");
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
        }
        catch (SCAException sCAException) {
            // empty catch block
        }
        return parent;
    }

    @Override
    public Process getProcess() throws CoreException {
        Process res = null;
        Scope current = this;
        ScopeImpl topScope = this;
        while (current != null) {
            if ((current = this.getParentScope(current)) == null) continue;
            topScope = current;
        }
        try {
            res = (Process)topScope.getComponent().getFcInterface("service");
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            // empty catch block
        }
        return res;
    }

    @Override
    public void linkInitialNodeAndExecution() throws CoreException {
        log.finest("start linkInitialNodeAndExecution");
        try {
            if (this.initialNode != null) {
                if (!SCAHelper.getSCAHelper().isBinded(this.parentExecution, "currentTarget")) {
                    log.finest("bind execution to initial node");
                    ArrayList<Binding> listOfBindings = new ArrayList<Binding>();
                    listOfBindings.add(new Binding("currentTarget", (Interface)((Object)this.getInitialNode())));
                    SCAHelper.getSCAHelper().addBindings(this.parentExecution, listOfBindings);
                    log.finest("execution and initial node binded");
                }
                if (!SCAHelper.getSCAHelper().isAlreadyBind(this.initialNode, "execution", (Interface)((Object)this.parentExecution))) {
                    this.linkedExecutableElement2Execution((Node)this.initialNode.getFcInterface("service"), (Execution)this.parentExecution.getFcInterface("service"));
                    log.finest("initial and execution linked");
                }
            } else {
                log.finest("Initial node not setted");
            }
        }
        catch (NoSuchInterfaceException e) {
            log.severe(e.getMessage());
            throw new CoreException(e);
        }
        catch (SCAException e) {
            log.severe(e.getMessage());
            throw new CoreException(e);
        }
        log.finest("end of linkInitialNodeAndExecution");
    }

    @Override
    public void setLog(Logger logger) {
        super.setLog(logger);
        log = logger;
    }

    private String formatCounter(int cpt) {
        String res = "";
        res = cpt < 10 ? "000" + cpt : (cpt < 100 ? "00" + cpt : (cpt < 1000 ? "0" + cpt : String.valueOf(cpt)));
        return res;
    }

    @Override
    public Map<Object, Endpoint> getEndpoints() {
        return this.endpoints;
    }

    @Override
    public List<CorrelationGroup> getCorrelationGroups() {
        return this.correlationGroups;
    }

    @Override
    public Map<Fault, Scope> getExceptions() {
        return this.exceptions;
    }

    @Override
    public void setExceptions(Map<Fault, Scope> exceptions) {
        this.exceptions = exceptions;
    }

    @Override
    public Exception isFaultScope() {
        return this.faultScope;
    }

    @Override
    public Node getParentNode() {
        return this.parentNode;
    }

    @Override
    public void setParentNode(Node parentNode) {
        this.parentNode = parentNode;
    }

    @Override
    public void setFaultScope(Exception faultScope) {
        this.faultScope = faultScope;
    }

    @Override
    public void setParentExecution(Component parentExecution) {
        this.parentExecution = parentExecution;
    }

    @Override
    public void setTerminationHandler(TerminationHandler th) {
        this.th = th;
    }

    @Override
    public TerminationHandler getTerminationHandler() {
        return this.th;
    }
}

