/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAComponent;
import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.ReceiverBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.soa.Endpoint;
import com.ebmwebsourcing.easyviper.core.api.soa.correlation.CorrelationMatcher;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageMatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Service;

@org.oasisopen.sca.annotation.Scope(value="COMPOSITE")
@Service(value={ReceiverBehaviour.class}, names={"service"})
public class ReceiverBehaviourImpl
extends AbstractBehaviourImpl
implements ReceiverBehaviour {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(ReceiverBehaviourImpl.class.getName());
    private InternalMessage<?> message;
    private List<QName> variableNames = new ArrayList<QName>();
    private MessageMatcher messageMatcher = null;
    private List<CorrelationMatcher> correlationsMatcher = null;
    private Object providerEndpointKey;
    @Reference(name="node", required=false)
    protected Node node;
    private Node childNodeSelected = null;
    private boolean isSuspended = false;

    @Override
    public Map<String, Object> getInitializationContext() throws SCAException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("message", this.message);
        context.put("variableNames", this.variableNames);
        context.put("correlationsMatcher", this.correlationsMatcher);
        context.put("messageMatcher", this.messageMatcher);
        return context;
    }

    @Override
    public void setInitializationContext(Map<String, Object> context) throws SCAException {
        this.message = (InternalMessage)context.get("message");
        this.variableNames = (List)context.get("variableNames");
        this.correlationsMatcher = (List)context.get("correlationsMatcher");
        this.messageMatcher = (MessageMatcher)context.get("messageMatcher");
    }

    @Override
    public String toString() {
        return "Receive Behaviour";
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public boolean accept(InternalMessage<?> message, ExternalContext context) throws CoreException {
        boolean accept = false;
        this.log.finest("Message received on node: " + this.node.getName());
        Scope scope = this.node.getExecution().getParentScope();
        int cptChild = 0;
        for (QName variableName : this.getVariableNames()) {
            Variable v = scope.findVariable(variableName);
            if (v == null) {
                throw new CoreException("Impossible to find in process, the variable used in the received : " + this.getName());
            }
            boolean check = false;
            if (this.getMessageMatcher() != null) {
                check = this.getMessageMatcher().match(v, message);
            } else {
                this.log.warning("no matcher found");
                check = true;
            }
            if (!check) {
                this.log.finest("message not valid for variable: " + variableName);
            } else {
                boolean correlationOK = false;
                if (this.correlationsMatcher != null) {
                    this.log.finest("Correlation found: execute correlation for receiver: " + this.getName());
                    for (CorrelationMatcher corr : this.correlationsMatcher) {
                        correlationOK = corr.match(scope, variableName, message);
                        if (!correlationOK) {
                            continue;
                        }
                        break;
                    }
                } else {
                    this.log.finest("No correlation ");
                    correlationOK = true;
                }
                if (check && correlationOK) {
                    v.setValue(message);
                    accept = true;
                    this.log.finest("Message accepted on receive by variable: " + variableName);
                    if (this.node.getChildNodes().size() <= 0) break;
                    this.childNodeSelected = this.node.getChildNodes().get(cptChild);
                    break;
                }
            }
            ++cptChild;
        }
        return accept;
    }

    @Override
    public List<QName> getVariableNames() {
        if (this.variableNames == null) {
            this.variableNames = new ArrayList<QName>();
        }
        return this.variableNames;
    }

    @Override
    public void addVariableName(QName variableName) {
        this.getVariableNames().add(variableName);
    }

    @Override
    public void setMessage(InternalMessage<?> message) {
        this.message = message;
    }

    @Override
    public InternalMessage<?> getMessage() {
        return this.message;
    }

    @Override
    public void setLog(Logger logger) {
        super.setLog(logger);
        this.log = logger;
    }

    @Override
    public Node getChildNodeSelected() {
        return this.childNodeSelected;
    }

    @Override
    public List<CorrelationMatcher> getCorrelationsMatchers() {
        return this.correlationsMatcher;
    }

    @Override
    public void setCorrelationsMatchers(List<CorrelationMatcher> correlationMatcher) {
        this.correlationsMatcher = correlationMatcher;
    }

    @Override
    public MessageMatcher getMessageMatcher() {
        return this.messageMatcher;
    }

    @Override
    public void setMessageMatcher(MessageMatcher messageMatcher) {
        this.messageMatcher = messageMatcher;
    }

    private final void executeOnSuspended() throws CoreException {
        this.isSuspended = false;
        this.log.finest("execute receive behaviour on node: " + this.node.getName());
        this.state = Behaviour.State.ACTIVITY_STARTED;
        if (this.message != null) {
            Endpoint endpoint = this.getNode().getExecution().getParentScope().findEndpoint(this.getClientEndpointKey());
            ExternalContext context = this.getNode().getExecution().getParentScope().getProcess().getExternalContext(endpoint, this.message.getOperationName());
            boolean accept = this.accept(this.message, context);
            if (accept) {
                this.log.finest("Message accepted by the receive activity: " + this.getName());
                if (this.getChildNodeSelected() != null) {
                    this.getNode().getExecution().setNextExecutableElements((SCAComponent)this, this.getChildNodeSelected());
                } else {
                    this.state = Behaviour.State.ACTIVITY_ENDED;
                }
            } else {
                this.getNode().getExecution().setStateRecursively(Execution.State.SUSPENDED);
                this.isSuspended = true;
                this.log.finest("Message does not correspond - execution suspended: " + (Object)((Object)this.getNode().getExecution().getState()));
            }
            this.message = null;
        } else {
            this.getNode().getExecution().setStateRecursively(Execution.State.SUSPENDED);
            this.isSuspended = true;
            this.log.finest("No Message - execution suspended: " + (Object)((Object)this.getNode().getExecution().getState()));
        }
    }

    @Override
    protected void executeOnEnded() throws CoreException {
    }

    @Override
    protected void executeOnInactive() throws CoreException {
        this.executeOnSuspended();
    }

    @Override
    protected void executeOnStarted() throws CoreException {
        if (this.isSuspended) {
            this.executeOnSuspended();
        } else {
            this.log.finest("end receive behaviour on node: " + this.node.getName());
            this.state = Behaviour.State.ACTIVITY_ENDED;
            this.log.finest("received activity ended");
            this.setMessage(null);
            this.childNodeSelected = null;
        }
    }

    @Override
    public Object getClientEndpointKey() {
        return this.providerEndpointKey;
    }

    @Override
    public void setClientEndpointKey(Object providerEndpointKey) {
        this.providerEndpointKey = providerEndpointKey;
    }
}

