/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAComponent;
import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.SequenceBehaviour;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.oasisopen.sca.ServiceReference;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.objectweb.fractal.api.Component;

@Scope(value="COMPOSITE")
@Service(value={SequenceBehaviour.class}, names={"service"})
public class SequenceBehaviourImpl
extends AbstractBehaviourImpl
implements SequenceBehaviour {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(SequenceBehaviourImpl.class.getName());
    @Reference(name="node", required=false)
    protected Node node;

    @Override
    public Map<String, Object> getInitializationContext() throws SCAException {
        return null;
    }

    @Override
    public void setInitializationContext(Map<String, Object> context) throws SCAException {
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public String toString() {
        return "Sequence";
    }

    @Override
    public void setLog(Logger logger) {
        super.setLog(logger);
        this.log = logger;
    }

    @Override
    protected void executeOnEnded() throws CoreException {
    }

    @Override
    protected void executeOnInactive() throws CoreException {
        this.log.finest("start sequence behaviour on node: " + this.node.getName());
        this.state = Behaviour.State.ACTIVITY_STARTED;
        try {
            List<Node> childs = this.node.getChildNodes();
            if (childs != null && childs.size() > 0) {
                Node firstNode = null;
                for (Node node : childs) {
                    Component nodeComp = SCAHelper.getSCAHelper().getComponentByInterface(SCAHelper.getSCAHelper().getParent(this.getComponent()), (ServiceReference)((Object)node), "service");
                    if (nodeComp != null && !SCAHelper.getSCAHelper().isStarted(nodeComp)) {
                        SCAHelper.getSCAHelper().startComponent(nodeComp);
                    }
                    if (node.getIncomingNodes() != null && (node.getIncomingNodes() == null || node.getIncomingNodes().size() != 0)) continue;
                    firstNode = node;
                    break;
                }
                this.getNode().getExecution().setNextExecutableElements((SCAComponent)this, firstNode);
            } else {
                this.state = Behaviour.State.ACTIVITY_ENDED;
            }
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
    }

    @Override
    protected void executeOnStarted() throws CoreException {
        this.log.finest("end sequence behaviour on node: " + this.node.getName());
        this.state = Behaviour.State.ACTIVITY_ENDED;
    }
}

