/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.WaitBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.DateExpression;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.LongExpression;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;

@Scope(value="COMPOSITE")
@Service(value={WaitBehaviour.class}, names={"service"})
public class WaitBehaviourImpl
extends AbstractBehaviourImpl
implements WaitBehaviour {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(WaitBehaviourImpl.class.getName());
    @Reference(name="node", required=false)
    protected Node node;
    private LongExpression<?> time;
    private DateExpression<?> date;

    @Override
    public Map<String, Object> getInitializationContext() throws SCAException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("time", this.time);
        context.put("date", this.date);
        return context;
    }

    @Override
    public void setInitializationContext(Map<String, Object> context) throws SCAException {
        this.time = (LongExpression)context.get("time");
        this.date = (DateExpression)context.get("date");
    }

    @Override
    public LongExpression<?> getDuration() {
        return this.time;
    }

    @Override
    public void setDuration(LongExpression<?> time) {
        this.time = time;
    }

    @Override
    public DateExpression<?> getDate() {
        return this.date;
    }

    @Override
    public void setDate(DateExpression<?> date) {
        this.date = date;
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public String toString() {
        return "WaitActivity";
    }

    @Override
    public void setLog(Logger logger) {
        super.setLog(logger);
        this.log = logger;
    }

    @Override
    protected void executeOnEnded() throws CoreException {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void executeOnInactive() throws CoreException {
        this.log.finest("start wait behaviour on node: " + this.node.getName());
        this.state = Behaviour.State.ACTIVITY_STARTED;
        try {
            try {
                if (this.time != null) {
                    Long time = (Long)this.time.evaluate(this.getNode().getExecution().getParentScope());
                    if (time == null) {
                        throw new CoreException("Impossible to evaluate long expression: " + this.time.getContent());
                    }
                    this.log.finest("execute wait behaviour on node: " + this.node.getName() + " => wait during " + time + " ms");
                    Thread.currentThread();
                    Thread.sleep(time);
                } else if (this.date != null) {
                    try {
                        Date date = (Date)this.date.evaluate(this.getNode().getExecution().getParentScope());
                        if (date == null) {
                            throw new CoreException("Impossible to evaluate date expression: " + this.date.getContent());
                        }
                        this.log.finest("execute wait behaviour on node: " + this.node.getName() + " => wait until " + date);
                        Thread.currentThread();
                        Thread.sleep(date.getTime() - System.currentTimeMillis());
                    }
                    catch (IllegalArgumentException e) {
                        this.log.warning("wait behaviour: " + e.getMessage());
                    }
                }
            }
            catch (InterruptedException e) {
                throw new CoreException(e);
            }
        }
        catch (Throwable throwable) {
            Object var2_6 = null;
            this.log.finest("wait finished");
            this.state = Behaviour.State.ACTIVITY_ENDED;
            throw throwable;
        }
        {
            Object var2_7 = null;
            this.log.finest("wait finished");
            this.state = Behaviour.State.ACTIVITY_ENDED;
            return;
        }
    }

    @Override
    protected void executeOnStarted() throws CoreException {
    }
}

