/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine.pattern;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.ReceiverBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.ConditionalExpression;
import com.ebmwebsourcing.easyviper.core.api.soa.correlation.CorrelationMatcher;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageMatcher;
import com.ebmwebsourcing.easyviper.core.impl.engine.ScopeImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ForkBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.IfBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.LoopBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ReceiverBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ScopeBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.SequenceBehaviourImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.ow2.frascati.tinfi.api.control.ContentInstantiationException;
import org.ow2.frascati.tinfi.api.control.SCAContentController;

public class CreationPatternFactory {
    private static CreationPatternFactory instance;

    private CreationPatternFactory() {
    }

    public static CreationPatternFactory getInstance() {
        if (instance == null) {
            instance = new CreationPatternFactory();
        }
        return instance;
    }

    public Node createSequencePattern(String name, List<Node> childNodes, Scope scope) throws CoreException {
        Node parentNode = null;
        try {
            if (scope == null) {
                throw new CoreException("scope cannot be null");
            }
            parentNode = scope.createNode(name, new SequenceBehaviourImpl());
            if (childNodes != null) {
                Iterator<Node> it = childNodes.iterator();
                Node source = null;
                Node target = null;
                Node lastNode = null;
                Component sourceComp = null;
                Component targetComp = null;
                Component lastComp = null;
                while (it.hasNext()) {
                    source = it.next();
                    sourceComp = SCAHelper.getSCAHelper().getComponentByInterface(scope.getComponent(), (Interface)((Object)source), "service");
                    String sourceName = SCAHelper.getSCAHelper().getName(sourceComp);
                    if (lastNode != null) {
                        scope.linkedBrotherNodes(lastNode, source);
                    }
                    if (it.hasNext()) {
                        target = it.next();
                        targetComp = SCAHelper.getSCAHelper().getComponentByInterface(scope.getComponent(), (Interface)((Object)target), "service");
                        scope.linkedBrotherNodes(source, target);
                        lastNode = target;
                        lastComp = targetComp;
                        continue;
                    }
                    lastNode = null;
                    lastComp = null;
                }
                if (childNodes != null) {
                    for (Node children : childNodes) {
                        scope.linkedChildNodeToParent(parentNode, children);
                    }
                }
            }
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
        return parentNode;
    }

    public Node createScopePattern(String name, Scope scope) throws CoreException {
        Node underscope = null;
        try {
            Behaviour behaviour;
            if (scope == null) {
                throw new CoreException("scope cannot be null");
            }
            Component underscopeComp = SCAHelper.getSCAHelper().createNewComponent(ScopeImpl.class.getName(), null);
            SCAHelper.getSCAHelper().addComponent(underscopeComp, scope.getComponent(), null);
            SCAContentController scacc = (SCAContentController)underscopeComp.getFcInterface("/sca-content-controller");
            try {
                underscope = (Scope)scacc.getFcContent();
            }
            catch (ContentInstantiationException e) {
                throw new CoreException(e);
            }
            underscope.setName(name);
            if (!scope.getLogger().getName().equals(ScopeImpl.class.getName())) {
                underscope.setLog(scope.getLogger());
            }
            SCAHelper.getSCAHelper().startComponent(underscopeComp);
            underscope = (Node)underscopeComp.getFcInterface("service");
            Component fractalActivity = SCAHelper.getSCAHelper().createNewComponent(ScopeBehaviourImpl.class.getName(), null);
            SCAHelper.getSCAHelper().changeName(fractalActivity, String.valueOf(ScopeBehaviourImpl.class.getSimpleName()) + "4" + SCAHelper.getSCAHelper().getName(underscopeComp));
            SCAHelper.getSCAHelper().addComponent(fractalActivity, scope.getComponent(), null);
            scacc = (SCAContentController)fractalActivity.getFcInterface("/sca-content-controller");
            try {
                behaviour = (Behaviour)scacc.getFcContent();
            }
            catch (ContentInstantiationException e) {
                throw new CoreException(e);
            }
            if (!scope.getLogger().getName().equals(ScopeImpl.class.getName())) {
                behaviour.setLog(scope.getLogger());
            }
            behaviour = (Behaviour)fractalActivity.getFcInterface("service");
            scope.linkedNodeAndFunctionnalBehaviour(underscope, behaviour);
            underscope.setActivity(behaviour);
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException(e);
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
        return underscope;
    }

    public Node createIfPattern(String name, List<ConditionalExpression> expressions, List<Node> childNodes, Scope scope) throws CoreException {
        Node parentNode = null;
        if (scope == null) {
            throw new CoreException("scope cannot be null");
        }
        if (expressions == null || expressions.size() == 0 || childNodes.size() == expressions.size() && childNodes.size() == expressions.size() + 1) {
            throw new CoreException("Invalid if pattern");
        }
        IfBehaviourImpl ifBehaviour = new IfBehaviourImpl();
        ifBehaviour.setConditions(expressions);
        parentNode = scope.createNode(name, ifBehaviour);
        if (childNodes != null) {
            for (Node children : childNodes) {
                scope.linkedChildNodeToParent(parentNode, children);
            }
        }
        return parentNode;
    }

    public Node createSeveralReceiversPattern(String name, List<ReceiverBehaviour> receivers, List<Node> childNodes, Scope scope) throws CoreException {
        Node parentNode = null;
        if (scope == null) {
            throw new CoreException("scope cannot be null");
        }
        if (receivers == null || receivers.size() == 0 || childNodes.size() != receivers.size()) {
            throw new CoreException("Invalid several receivers pattern");
        }
        ArrayList<QName> variableNames = new ArrayList<QName>();
        for (ReceiverBehaviour receiver : receivers) {
            variableNames.addAll(receiver.getVariableNames());
        }
        ReceiverBehaviourImpl severalReceiversBehaviour = new ReceiverBehaviourImpl();
        severalReceiversBehaviour.getVariableNames().addAll(variableNames);
        MessageMatcher matcher = receivers.get(0).getMessageMatcher();
        for (ReceiverBehaviour receiver : receivers) {
            if (matcher == receiver.getMessageMatcher()) continue;
            throw new CoreException("Sorry but all receivers must have the same message matcher");
        }
        severalReceiversBehaviour.setMessageMatcher(matcher);
        ArrayList<CorrelationMatcher> correlationsMatcher = null;
        for (ReceiverBehaviour receiver : receivers) {
            if (receiver.getCorrelationsMatchers() == null) continue;
            if (correlationsMatcher == null) {
                correlationsMatcher = new ArrayList<CorrelationMatcher>();
            }
            correlationsMatcher.addAll(receiver.getCorrelationsMatchers());
        }
        severalReceiversBehaviour.setCorrelationsMatchers(correlationsMatcher);
        parentNode = scope.createNode(name, severalReceiversBehaviour);
        if (childNodes != null) {
            for (Node children : childNodes) {
                scope.linkedChildNodeToParent(parentNode, children);
            }
        }
        return parentNode;
    }

    public Node createLoopPattern(String name, ConditionalExpression condition, boolean applyConditionAtBegin, List<Node> childNodes, Scope scope) throws CoreException {
        Node parentNode = null;
        try {
            if (scope == null) {
                throw new CoreException("scope cannot be null");
            }
            if (condition == null) {
                throw new CoreException("condition cannot be null");
            }
            LoopBehaviourImpl loopBehaviour = new LoopBehaviourImpl();
            loopBehaviour.setCondition(condition);
            loopBehaviour.setApplyConditionAtBegin(applyConditionAtBegin);
            parentNode = scope.createNode(name, loopBehaviour);
            if (childNodes != null) {
                Iterator<Node> it = childNodes.iterator();
                Node source = null;
                Node target = null;
                Node lastNode = null;
                Component sourceComp = null;
                Component targetComp = null;
                Component lastComp = null;
                String transitionName = "t";
                while (it.hasNext()) {
                    source = it.next();
                    sourceComp = SCAHelper.getSCAHelper().getComponentByInterface(scope.getComponent(), (Interface)((Object)source), "service");
                    if (lastNode != null) {
                        scope.linkedBrotherNodes(lastNode, source);
                    }
                    if (it.hasNext()) {
                        target = it.next();
                        targetComp = SCAHelper.getSCAHelper().getComponentByInterface(scope.getComponent(), (Interface)((Object)target), "service");
                        scope.linkedBrotherNodes(source, target);
                        lastNode = target;
                        lastComp = targetComp;
                        continue;
                    }
                    lastNode = null;
                    lastComp = null;
                }
                if (childNodes != null) {
                    for (Node children : childNodes) {
                        scope.linkedChildNodeToParent(parentNode, children);
                    }
                }
            }
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
        return parentNode;
    }

    public Node createForkPattern(String name, List<Node> childNodes, Scope scope) throws CoreException {
        Node parentNode = null;
        if (scope == null) {
            throw new CoreException("scope cannot be null");
        }
        parentNode = scope.createNode(name, new ForkBehaviourImpl());
        if (childNodes != null) {
            for (Node children : childNodes) {
                scope.linkedChildNodeToParent(parentNode, children);
            }
        }
        return parentNode;
    }
}

