/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine.thread.service;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.thread.service.Service;
import com.ebmwebsourcing.easyviper.core.api.engine.thread.service.ServiceManager;
import com.ebmwebsourcing.easyviper.extended.service.autoflush.impl.AutoFlushMessageServiceImpl;
import com.ebmwebsourcing.easyviper.extended.service.autotrash.impl.AutoTrashProcessServiceImpl;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class ServiceManagerImpl
implements ServiceManager {
    private Logger log = Logger.getLogger(ServiceManagerImpl.class.getName());
    private List<Service> services = new ArrayList<Service>();
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    private Engine engine = null;

    public ServiceManagerImpl(Engine engine) throws CoreException {
        this.engine = engine;
        this.addService(AutoFlushMessageServiceImpl.class);
        this.addService(AutoTrashProcessServiceImpl.class);
        this.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(this.services.size());
    }

    @Override
    public void shutdownAllServices() {
        this.scheduledThreadPoolExecutor.shutdown();
        try {
            this.scheduledThreadPoolExecutor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void restartAllServices() {
        this.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(this.services.size());
        for (Service service : this.services) {
            this.scheduledThreadPoolExecutor.scheduleWithFixedDelay(service, 0L, 1L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public List<Service> getServices() {
        return this.services;
    }

    @Override
    public void addService(Class<? extends Service> serviceClass) throws CoreException {
        Service s = this.findService(serviceClass);
        if (s != null) {
            this.log.warning("This service already exist: " + s);
        } else if (serviceClass != null) {
            this.log.fine("creation and adding of service: " + serviceClass);
            Constructor<?> constructor = serviceClass.getConstructors()[0];
            try {
                Service service = (Service)constructor.newInstance(this.engine);
                this.services.add(service);
            }
            catch (IllegalArgumentException e) {
                throw new CoreException(e);
            }
            catch (InstantiationException e) {
                throw new CoreException(e);
            }
            catch (IllegalAccessException e) {
                throw new CoreException(e);
            }
            catch (InvocationTargetException e) {
                throw new CoreException(e);
            }
        }
    }

    private Service findService(Class<? extends Service> serviceClass) {
        Service serviceFound = null;
        for (Service service : this.services) {
            if (!service.getClass().equals(serviceClass)) continue;
            serviceFound = service;
            break;
        }
        return serviceFound;
    }

    @Override
    public Service removeService(Class<? extends Service> serviceClass) {
        Service serviceToRemove = this.findService(serviceClass);
        if (serviceToRemove != null) {
            this.scheduledThreadPoolExecutor.remove(serviceToRemove);
            this.scheduledThreadPoolExecutor.setCorePoolSize(this.services.size());
            this.services.remove(serviceToRemove);
        }
        return serviceToRemove;
    }

    @Override
    public void activateService(Class<? extends Service> serviceClass) throws CoreException {
        Service service = this.findService(serviceClass);
        if (service != null && service.getRefreshFrequency() > 0) {
            this.log.finest("this service is activated: " + serviceClass.getSimpleName());
            this.scheduledThreadPoolExecutor.setCorePoolSize(this.services.size());
            this.scheduledThreadPoolExecutor.scheduleWithFixedDelay(service, 0L, 1L, TimeUnit.MILLISECONDS);
        } else {
            this.log.warning("Impossible to find this service: " + serviceClass.getSimpleName());
        }
    }

    @Override
    public <S extends Service> S getService(Class<S> serviceClass) {
        Service service = this.findService(serviceClass);
        return (S)service;
    }
}

