/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.marshalling;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.model.ObjectFactory;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBContext;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.impl.SchemaJAXBContext;

public class ViperJAXBContext {
    private static final List<Object> defaultObjectFactoriesObjects = new ArrayList<Object>();
    private static final List<Class> defaultObjectFactoriesClasses = new ArrayList<Class>((Collection)Arrays.asList(ObjectFactory.class));
    private List<Class> currentObjectFactories = new ArrayList<Class>(defaultObjectFactoriesClasses);
    private static ViperJAXBContext instance = null;

    public static List<Class> getDefaultObjectFactories() {
        return defaultObjectFactoriesClasses;
    }

    private ViperJAXBContext() throws CoreException {
        try {
            SchemaJAXBContext.getInstance().addOtherObjectFactory(defaultObjectFactoriesClasses);
            SchemaJAXBContext.getInstance().getJaxbContext();
        }
        catch (SchemaException e) {
            throw new CoreException(e);
        }
    }

    public static <F> F getObjectFactory(Class<F> clazz) throws CoreException {
        Object res = null;
        Class c = null;
        boolean found = false;
        for (Class current : defaultObjectFactoriesClasses) {
            if (!current.equals(clazz)) continue;
            found = true;
            c = current;
            break;
        }
        if (found) {
            found = false;
            for (Object o : defaultObjectFactoriesObjects) {
                if (!o.getClass().equals(clazz)) continue;
                res = o;
                found = true;
                break;
            }
            if (!found) {
                try {
                    Constructor constructor = c.getConstructor(new Class[0]);
                    res = c.newInstance();
                }
                catch (SecurityException e) {
                    throw new CoreException(e.getMessage());
                }
                catch (NoSuchMethodException e) {
                    throw new CoreException(e.getMessage());
                }
                catch (InstantiationException e) {
                    throw new CoreException(e.getMessage());
                }
                catch (IllegalAccessException e) {
                    throw new CoreException(e.getMessage());
                }
            }
        } else {
            throw new CoreException("The class " + clazz.getName() + " is not in the factories list of EasyViper.");
        }
        return (F)res;
    }

    public static ViperJAXBContext getInstance() throws CoreException {
        if (instance == null) {
            instance = new ViperJAXBContext();
        }
        return instance;
    }

    public JAXBContext getJaxbContext() throws CoreException {
        try {
            return SchemaJAXBContext.getInstance().getJaxbContext();
        }
        catch (SchemaException e) {
            throw new CoreException(e);
        }
    }
}

