/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.SimpleTimeZone;
import com.ibm.icu.util.SimpleTimeZoneAdapter;
import com.ibm.icu.util.TimeZoneData;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.text.ParsePosition;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;

public abstract class TimeZone
implements Serializable,
Cloneable {
    public static final int SHORT = 0;
    public static final int LONG = 1;
    private static final int ONE_MINUTE = 60000;
    private static final int ONE_HOUR = 3600000;
    private static Hashtable cachedLocaleData = new Hashtable(3);
    static final long serialVersionUID = 3581463369166924961L;
    private String ID;
    private static TimeZone defaultZone = null;
    static final String GMT_ID = "GMT";
    private static final int GMT_ID_LENGTH = 3;
    private static final String CUSTOM_ID = "Custom";
    private static NumberFormat numberFormat = null;
    private static final TimeZone GMT = new SimpleTimeZone(0, "GMT");
    static /* synthetic */ Class class$com$ibm$icu$util$TimeZone;

    public abstract int getOffset(int var1, int var2, int var3, int var4, int var5, int var6);

    int getOffset(int era, int year, int month, int day, int dayOfWeek, int milliseconds, int monthLength, int prevMonthLength) {
        return this.getOffset(era, year, month, day, dayOfWeek, milliseconds);
    }

    int getOffset(int eyear, int month, int dayOfMonth, int dayOfWeek, int milliseconds, int monthLength, int prevMonthLength) {
        int era = 1;
        if (eyear < 1) {
            era = 0;
            eyear = 1 - eyear;
        }
        return this.getOffset(era, eyear, month, dayOfMonth, dayOfWeek, milliseconds, monthLength, prevMonthLength);
    }

    public abstract void setRawOffset(int var1);

    public abstract int getRawOffset();

    public String getID() {
        return this.ID;
    }

    public void setID(String ID2) {
        if (ID2 == null) {
            throw new NullPointerException();
        }
        this.ID = ID2;
    }

    public final String getDisplayName() {
        return this.getDisplayName(false, 1, Locale.getDefault());
    }

    public final String getDisplayName(Locale locale) {
        return this.getDisplayName(false, 1, locale);
    }

    public final String getDisplayName(boolean daylight, int style) {
        return this.getDisplayName(daylight, style, Locale.getDefault());
    }

    public String getDisplayName(boolean daylight, int style, Locale locale) {
        SimpleTimeZone tz;
        SimpleDateFormat format;
        if (style != 0 && style != 1) {
            throw new IllegalArgumentException("Illegal style: " + style);
        }
        SoftReference data = (SoftReference)cachedLocaleData.get(locale);
        if (data == null || (format = (SimpleDateFormat)data.get()) == null) {
            format = new SimpleDateFormat(null, locale);
            cachedLocaleData.put(locale, new SoftReference<SimpleDateFormat>(format));
        }
        if (daylight && this.useDaylightTime()) {
            int savings = 3600000;
            try {
                savings = ((SimpleTimeZone)this).getDSTSavings();
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            tz = new SimpleTimeZone(this.getRawOffset(), this.getID(), 0, 1, 0, 0, 1, 1, 0, 0, savings);
        } else {
            tz = new SimpleTimeZone(this.getRawOffset(), this.getID());
        }
        format.applyPattern(style == 1 ? "zzzz" : "z");
        format.setTimeZone(tz);
        return format.format(new Date(864000000L));
    }

    public abstract boolean useDaylightTime();

    public abstract boolean inDaylightTime(Date var1);

    public static synchronized TimeZone getTimeZone(String ID2) {
        TimeZone zone = TimeZoneData.get(ID2);
        if (zone == null) {
            zone = TimeZone.parseCustomTimeZone(ID2);
        }
        if (zone == null) {
            zone = (TimeZone)GMT.clone();
        }
        return zone;
    }

    public static String[] getAvailableIDs(int rawOffset) {
        return TimeZoneData.getAvailableIDs(rawOffset);
    }

    public static String[] getAvailableIDs(String country) {
        return TimeZoneData.getAvailableIDs(country);
    }

    public static String[] getAvailableIDs() {
        return TimeZoneData.getAvailableIDs();
    }

    public static int countEquivalentIDs(String id) {
        return TimeZoneData.countEquivalentIDs(id);
    }

    public static String getEquivalentID(String id, int index) {
        return TimeZoneData.getEquivalentID(id, index);
    }

    public static synchronized TimeZone getDefault() {
        if (defaultZone == null) {
            java.util.TimeZone _default = java.util.TimeZone.getDefault();
            String zoneID = _default.getID();
            defaultZone = TimeZoneData.get(zoneID);
            if (defaultZone == null) {
                try {
                    java.util.SimpleTimeZone s = (java.util.SimpleTimeZone)_default;
                    defaultZone = new SimpleTimeZone(s.getRawOffset(), s.getID());
                }
                catch (ClassCastException classCastException) {}
            } else if (zoneID == null) {
                zoneID = GMT_ID;
            }
            if (defaultZone == null) {
                defaultZone = TimeZone.getTimeZone(zoneID);
            }
        }
        return (TimeZone)defaultZone.clone();
    }

    public static synchronized void setDefault(TimeZone zone) {
        defaultZone = zone;
        try {
            java.util.TimeZone.setDefault(new SimpleTimeZoneAdapter((SimpleTimeZone)zone));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public boolean hasSameRules(TimeZone other) {
        return other != null && this.getRawOffset() == other.getRawOffset() && this.useDaylightTime() == other.useDaylightTime();
    }

    public Object clone() {
        try {
            TimeZone other = (TimeZone)super.clone();
            other.ID = this.ID;
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    private static final SimpleTimeZone parseCustomTimeZone(String id) {
        if (id.length() > 3 && id.regionMatches(true, 0, GMT_ID, 0, 3)) {
            ParsePosition pos = new ParsePosition(3);
            boolean negative = false;
            if (id.charAt(pos.getIndex()) == '-') {
                negative = true;
            } else if (id.charAt(pos.getIndex()) != '+') {
                return null;
            }
            pos.setIndex(pos.getIndex() + 1);
            Class clazz = class$com$ibm$icu$util$TimeZone == null ? (class$com$ibm$icu$util$TimeZone = TimeZone.class$("com.ibm.icu.util.TimeZone")) : class$com$ibm$icu$util$TimeZone;
            synchronized (clazz) {
                if (numberFormat == null) {
                    numberFormat = NumberFormat.getInstance();
                    numberFormat.setParseIntegerOnly(true);
                }
            }
            NumberFormat numberFormat = TimeZone.numberFormat;
            synchronized (numberFormat) {
                int start = pos.getIndex();
                Number n = TimeZone.numberFormat.parse(id, pos);
                if (n == null) {
                    SimpleTimeZone simpleTimeZone = null;
                    return simpleTimeZone;
                }
                int offset = n.intValue();
                if (pos.getIndex() < id.length() && id.charAt(pos.getIndex()) == ':') {
                    offset *= 60;
                    pos.setIndex(pos.getIndex() + 1);
                    n = TimeZone.numberFormat.parse(id, pos);
                    if (n == null) {
                        SimpleTimeZone simpleTimeZone = null;
                        return simpleTimeZone;
                    }
                    offset += n.intValue();
                } else {
                    offset = offset < 30 && pos.getIndex() - start <= 2 ? (offset *= 60) : offset % 100 + offset / 100 * 60;
                }
                if (negative) {
                    offset = -offset;
                }
                SimpleTimeZone simpleTimeZone = new SimpleTimeZone(offset * 60000, CUSTOM_ID);
                return simpleTimeZone;
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

