/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Stack;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.OutputURIResolver;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SaxonOutputKeys;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.SerializerFactory;
import net.sf.saxon.event.StandardOutputResolver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.functions.Document;
import net.sf.saxon.functions.EscapeURI;
import net.sf.saxon.instruct.DivisibleInstruction;
import net.sf.saxon.instruct.DocumentInstr;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.sort.IntIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Whitespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultDocument
extends Instruction
implements DivisibleInstruction {
    private Expression href;
    private Expression formatExpression;
    private Expression content;
    private Properties globalProperties;
    private Properties localProperties;
    private String baseURI;
    private int validationAction;
    private SchemaType schemaType;
    private IntHashMap<Expression> serializationAttributes;
    private NamespaceResolver nsResolver;
    private Expression dynamicOutputElement;
    private boolean resolveAgainstStaticBase = false;

    public ResultDocument(Properties globalProperties, Properties localProperties, Expression href, Expression formatExpression, String baseURI, int validationAction, SchemaType schemaType, IntHashMap<Expression> serializationAttributes, NamespaceResolver nsResolver) {
        this.globalProperties = globalProperties;
        this.localProperties = localProperties;
        this.href = href;
        this.formatExpression = formatExpression;
        this.baseURI = baseURI;
        this.validationAction = validationAction;
        this.schemaType = schemaType;
        this.serializationAttributes = serializationAttributes;
        this.nsResolver = nsResolver;
        this.adoptChildExpression(href);
        Iterator it = serializationAttributes.valueIterator();
        while (it.hasNext()) {
            this.adoptChildExpression((Expression)it.next());
        }
    }

    public void setContentExpression(Expression content) {
        this.content = content;
        this.adoptChildExpression(content);
    }

    public Expression getContentExpression() {
        return this.content;
    }

    public void setDynamicOutputElement(Expression exp) {
        this.dynamicOutputElement = exp;
    }

    public void setUseStaticBaseUri(boolean staticBase) {
        this.resolveAgainstStaticBase = staticBase;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.content = visitor.simplify(this.content);
        this.href = visitor.simplify(this.href);
        IntIterator it = this.serializationAttributes.keyIterator();
        while (it.hasNext()) {
            int key = it.next();
            Expression value = this.serializationAttributes.get(key);
            if (value instanceof Literal) continue;
            value = visitor.simplify(value);
            this.serializationAttributes.put(key, value);
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.content = visitor.typeCheck(this.content, contextItemType);
        this.adoptChildExpression(this.content);
        if (this.href != null) {
            this.href = visitor.typeCheck(this.href, contextItemType);
            this.adoptChildExpression(this.href);
        }
        if (this.formatExpression != null) {
            this.formatExpression = visitor.typeCheck(this.formatExpression, contextItemType);
            this.adoptChildExpression(this.formatExpression);
        }
        IntIterator it = this.serializationAttributes.keyIterator();
        while (it.hasNext()) {
            int key = it.next();
            Expression value = this.serializationAttributes.get(key);
            if (value instanceof Literal) continue;
            value = visitor.typeCheck(value, contextItemType);
            this.adoptChildExpression(value);
            this.serializationAttributes.put(key, value);
        }
        try {
            DocumentInstr.checkContentSequence(visitor.getStaticContext(), this.content, this.validationAction, this.schemaType);
        }
        catch (XPathException err) {
            err.maybeSetLocation(this);
            throw err;
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.content = visitor.optimize(this.content, contextItemType);
        this.adoptChildExpression(this.content);
        if (this.href != null) {
            this.href = visitor.optimize(this.href, contextItemType);
            this.adoptChildExpression(this.href);
        }
        if (this.formatExpression != null) {
            this.formatExpression = visitor.optimize(this.formatExpression, contextItemType);
            this.adoptChildExpression(this.formatExpression);
        }
        IntIterator it = this.serializationAttributes.keyIterator();
        while (it.hasNext()) {
            int key = it.next();
            Expression value = this.serializationAttributes.get(key);
            if (value instanceof Literal) continue;
            value = visitor.optimize(value, contextItemType);
            this.adoptChildExpression(value);
            this.serializationAttributes.put(key, value);
        }
        return this;
    }

    @Override
    public int getIntrinsicDependencies() {
        return 0x1000000;
    }

    @Override
    public Expression copy() {
        throw new UnsupportedOperationException("copy");
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        this.content = this.doPromotion(this, this.content, offer);
        if (this.href != null) {
            this.href = this.doPromotion(this, this.href, offer);
        }
        IntIterator it = this.serializationAttributes.keyIterator();
        while (it.hasNext()) {
            int key = it.next();
            Expression value = this.serializationAttributes.get(key);
            if (value instanceof Literal) continue;
            value = this.doPromotion(this, value, offer);
            this.serializationAttributes.put(key, value);
        }
    }

    @Override
    public int getInstructionNameCode() {
        return 174;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return EmptySequenceTest.getInstance();
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        ArrayList<Expression> list = new ArrayList<Expression>(6);
        list.add(this.content);
        if (this.href != null) {
            list.add(this.href);
        }
        if (this.formatExpression != null) {
            list.add(this.formatExpression);
        }
        Iterator it = this.serializationAttributes.valueIterator();
        while (it.hasNext()) {
            list.add((Expression)it.next());
        }
        if (this.dynamicOutputElement != null) {
            list.add(this.dynamicOutputElement);
        }
        return list.iterator();
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.content == original) {
            this.content = replacement;
            found = true;
        }
        if (this.href == original) {
            this.href = replacement;
            found = true;
        }
        IntIterator it = this.serializationAttributes.keyIterator();
        while (it.hasNext()) {
            int k = it.next();
            if (this.serializationAttributes.get(k) != original) continue;
            this.serializationAttributes.put(k, replacement);
            found = true;
        }
        if (this.dynamicOutputElement == original) {
            this.dynamicOutputElement = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        Result result;
        OutputURIResolver resolver2;
        Controller controller = context.getController();
        XPathContextMinor c2 = context.newMinorContext();
        c2.setOrigin(this);
        OutputURIResolver outputURIResolver = resolver2 = this.href == null ? null : controller.getOutputURIResolver();
        if (this.href == null) {
            result = controller.getPrincipalResult();
        } else {
            try {
                String base = this.resolveAgainstStaticBase ? this.baseURI : controller.getCookedBaseOutputURI();
                String hrefValue = ((Object)EscapeURI.iriToUri(this.href.evaluateAsString(context))).toString();
                try {
                    result = resolver2 == null ? null : resolver2.resolve(hrefValue, base);
                }
                catch (TransformerException err) {
                    throw XPathException.makeXPathException(err);
                }
                catch (Exception err) {
                    err.printStackTrace();
                    throw new XPathException("Exception thrown by OutputURIResolver", err);
                }
                if (result == null) {
                    resolver2 = StandardOutputResolver.getInstance();
                    result = resolver2.resolve(hrefValue, base);
                }
            }
            catch (TransformerException e) {
                throw XPathException.makeXPathException(e);
            }
        }
        this.checkAcceptableUri(context, result);
        this.traceDestination(context, result);
        Properties computedLocalProps = this.gatherOutputProperties(context);
        String nextInChain = computedLocalProps.getProperty("{http://saxon.sf.net/}next-in-chain");
        if (nextInChain != null && nextInChain.length() > 0) {
            try {
                result = controller.prepareNextStylesheet(nextInChain, this.baseURI, result);
            }
            catch (TransformerException e) {
                throw XPathException.makeXPathException(e);
            }
        }
        SerializerFactory sf = c2.getConfiguration().getSerializerFactory();
        PipelineConfiguration pipe = controller.makePipelineConfiguration();
        pipe.setHostLanguage(50);
        Receiver receiver = sf.getReceiver(result, pipe, computedLocalProps);
        c2.changeOutputDestination(receiver, true, this.validationAction, this.schemaType);
        SequenceReceiver out = c2.getReceiver();
        out.open();
        try {
            out.startDocument(0);
            this.content.process(c2);
            out.endDocument();
        }
        catch (XPathException err) {
            err.setXPathContext(context);
            err.maybeSetLocation(this);
            throw err;
        }
        out.close();
        if (resolver2 != null) {
            try {
                resolver2.close(result);
            }
            catch (TransformerException e) {
                throw XPathException.makeXPathException(e);
            }
        }
        return null;
    }

    @Override
    public void processLeft(Stack<XPathContext> contextStack, Stack state) throws XPathException {
        Result result;
        OutputURIResolver resolver2;
        XPathContext context = contextStack.peek();
        Controller controller = context.getController();
        XPathContextMinor c2 = context.newMinorContext();
        c2.setOrigin(this);
        OutputURIResolver outputURIResolver = resolver2 = this.href == null ? null : controller.getOutputURIResolver();
        if (this.href == null) {
            result = controller.getPrincipalResult();
        } else {
            try {
                String base = this.resolveAgainstStaticBase ? this.baseURI : controller.getCookedBaseOutputURI();
                String hrefValue = ((Object)EscapeURI.iriToUri(this.href.evaluateAsString(context))).toString();
                try {
                    result = resolver2.resolve(hrefValue, base);
                }
                catch (Exception err) {
                    throw new XPathException("Exception thrown by OutputURIResolver", err);
                }
                if (result == null) {
                    resolver2 = StandardOutputResolver.getInstance();
                    result = resolver2.resolve(hrefValue, base);
                }
            }
            catch (TransformerException e) {
                throw XPathException.makeXPathException(e);
            }
        }
        this.checkAcceptableUri(context, result);
        this.traceDestination(context, result);
        Properties computedLocalProps = this.gatherOutputProperties(context);
        String nextInChain = computedLocalProps.getProperty("{http://saxon.sf.net/}next-in-chain");
        if (nextInChain != null && nextInChain.length() > 0) {
            try {
                result = controller.prepareNextStylesheet(nextInChain, this.baseURI, result);
            }
            catch (TransformerException e) {
                throw XPathException.makeXPathException(e);
            }
        }
        SerializerFactory sf = c2.getConfiguration().getSerializerFactory();
        PipelineConfiguration pipe = controller.makePipelineConfiguration();
        pipe.setHostLanguage(50);
        Receiver receiver = sf.getReceiver(result, pipe, computedLocalProps);
        c2.changeOutputDestination(receiver, true, this.validationAction, this.schemaType);
        SequenceReceiver out = c2.getReceiver();
        out.open();
        state.push(out);
        state.push(resolver2);
        state.push(result);
        contextStack.push(c2);
    }

    @Override
    public void processRight(Stack<XPathContext> contextStack, Stack state) throws XPathException {
        XPathContext context = contextStack.pop();
        Result result = (Result)state.pop();
        OutputURIResolver resolver2 = (OutputURIResolver)state.pop();
        SequenceReceiver out = (SequenceReceiver)state.pop();
        try {
            out.endDocument();
        }
        catch (XPathException err) {
            err.setXPathContext(context);
            err.maybeSetLocation(this);
            throw err;
        }
        out.close();
        if (resolver2 != null) {
            try {
                resolver2.close(result);
            }
            catch (TransformerException e) {
                throw XPathException.makeXPathException(e);
            }
        }
    }

    private void traceDestination(XPathContext context, Result result) {
        boolean timing = context.getConfiguration().isTiming();
        if (timing) {
            String dest = result.getSystemId();
            if (dest == null) {
                dest = result instanceof StreamResult ? "anonymous output stream" : (result instanceof SAXResult ? "SAX2 ContentHandler" : (result instanceof DOMResult ? "DOM tree" : result.getClass().getName()));
            }
            System.err.println("Writing to " + dest);
        }
    }

    private void checkAcceptableUri(XPathContext context, Result result) throws XPathException {
        Controller controller = context.getController();
        if (controller.getDocumentPool().find(result.getSystemId()) != null) {
            XPathException err = new XPathException("Cannot write to a URI that has already been read: " + result.getSystemId());
            err.setXPathContext(context);
            err.setLocator(this);
            err.setErrorCode("XTRE1500");
            throw err;
        }
        String documentKey = Document.normalizeURI(result.getSystemId());
        if (!controller.checkUniqueOutputDestination(documentKey)) {
            XPathException err = new XPathException("Cannot write more than one result document to the same URI: " + result.getSystemId());
            err.setXPathContext(context);
            err.setLocator(this);
            err.setErrorCode("XTDE1490");
            throw err;
        }
        controller.addUnavailableOutputDestination(documentKey);
        controller.setThereHasBeenAnExplicitResultDocument();
    }

    private Properties gatherOutputProperties(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        Configuration config = context.getConfiguration();
        NamePool namePool = config.getNamePool();
        Properties computedGlobalProps = this.globalProperties;
        if (this.formatExpression != null) {
            String[] parts;
            CharSequence format = this.formatExpression.evaluateAsString(context);
            try {
                parts = controller.getConfiguration().getNameChecker().getQNameParts(format);
            }
            catch (QNameException e) {
                XPathException xPathException = new XPathException("The requested output format " + Err.wrap(format) + " is not a valid QName");
                xPathException.setErrorCode("XTDE1460");
                xPathException.setXPathContext(context);
                throw xPathException;
            }
            String uri = this.nsResolver.getURIForPrefix(parts[0], false);
            if (uri == null) {
                XPathException xPathException = new XPathException("The namespace prefix in the format name " + format + " is undeclared");
                xPathException.setErrorCode("XTDE1460");
                xPathException.setXPathContext(context);
                throw xPathException;
            }
            StructuredQName structuredQName = new StructuredQName(parts[0], uri, parts[1]);
            computedGlobalProps = this.getExecutable().getOutputProperties(structuredQName);
            if (computedGlobalProps == null) {
                XPathException err = new XPathException("There is no xsl:output format named " + format);
                err.setErrorCode("XTDE1460");
                err.setXPathContext(context);
                throw err;
            }
        }
        Properties computedLocalProps = new Properties(computedGlobalProps);
        NameChecker checker = config.getNameChecker();
        for (String string : this.localProperties.keySet()) {
            String[] parts = NamePool.parseClarkName(string);
            try {
                ResultDocument.setSerializationProperty(computedLocalProps, parts[0], parts[1], this.localProperties.getProperty(string), this.nsResolver, true, config);
            }
            catch (XPathException xPathException) {
                xPathException.maybeSetLocation(this);
                throw xPathException;
            }
        }
        if (this.serializationAttributes.size() > 0) {
            IntIterator it = this.serializationAttributes.keyIterator();
            while (it.hasNext()) {
                int n = it.next();
                Expression exp = this.serializationAttributes.get(n);
                String string = ((Object)exp.evaluateAsString(context)).toString();
                String lname = namePool.getLocalName(n);
                String uri = namePool.getURI(n);
                try {
                    ResultDocument.setSerializationProperty(computedLocalProps, uri, lname, string, this.nsResolver, false, config);
                }
                catch (XPathException e) {
                    e.maybeSetLocation(this);
                    e.maybeSetContext(context);
                    if ("http://saxon.sf.net/".equals(e.getErrorCodeNamespace()) && "SXWN".equals(e.getErrorCodeLocalPart().substring(0, 4))) {
                        try {
                            context.getController().getErrorListener().warning(e);
                            continue;
                        }
                        catch (TransformerException e2) {
                            throw XPathException.makeXPathException(e2);
                        }
                    }
                    throw e;
                }
            }
        }
        if (this.dynamicOutputElement != null) {
            Item outputArg = this.dynamicOutputElement.evaluateItem(context);
            if (!(outputArg instanceof NodeInfo) || ((NodeInfo)outputArg).getNodeKind() != 1 || ((NodeInfo)outputArg).getFingerprint() != 165) {
                XPathException xPathException = new XPathException("The third argument of saxon:result-document must be an <xsl:output> element");
                xPathException.setLocator(this);
                xPathException.setXPathContext(context);
                throw xPathException;
            }
            Properties properties = new Properties();
            ResultDocument.processXslOutputElement((NodeInfo)outputArg, properties, context);
            for (String string : properties.keySet()) {
                StructuredQName name = StructuredQName.fromClarkName(string);
                String value = properties.getProperty(string);
                try {
                    ResultDocument.setSerializationProperty(computedLocalProps, name.getNamespaceURI(), name.getLocalName(), value, this.nsResolver, false, config);
                }
                catch (XPathException e) {
                    e.maybeSetLocation(this);
                    e.maybeSetContext(context);
                    throw e;
                }
            }
        }
        return computedLocalProps;
    }

    public static void setSerializationProperty(Properties details, String uri, String lname, String value, NamespaceResolver nsResolver, boolean prevalidated, Configuration config) throws XPathException {
        NameChecker checker = config.getNameChecker();
        if (uri.length() == 0 || "http://saxon.sf.net/".equals(uri)) {
            if (lname.equals("method")) {
                if (value.equals("xml") || value.equals("html") || value.equals("text") || value.equals("xhtml") || prevalidated) {
                    details.setProperty("method", value);
                } else {
                    try {
                        String[] parts = checker.getQNameParts(value);
                        String prefix = parts[0];
                        if (prefix.length() == 0) {
                            XPathException err = new XPathException("method must be xml, html, xhtml, or text, or a prefixed name");
                            err.setErrorCode("XTSE1570");
                            err.setIsStaticError(true);
                            throw err;
                        }
                        String muri = nsResolver.getURIForPrefix(prefix, false);
                        if (muri == null) {
                            XPathException err = new XPathException("Namespace prefix '" + prefix + "' has not been declared");
                            err.setErrorCode("XTSE1570");
                            err.setIsStaticError(true);
                            throw err;
                        }
                        details.setProperty("method", '{' + muri + '}' + parts[1]);
                    }
                    catch (QNameException e) {
                        XPathException err = new XPathException("Invalid method name. " + e.getMessage());
                        err.setErrorCode("XTSE1570");
                        err.setIsStaticError(true);
                        throw err;
                    }
                }
            } else if (lname.equals("use-character-maps")) {
                String existing = details.getProperty("use-character-maps");
                if (existing == null) {
                    existing = "";
                }
                details.setProperty("use-character-maps", existing + value);
            } else if (lname.equals("cdata-section-elements")) {
                ResultDocument.processListOfElementNames(details, "cdata-section-elements", value, nsResolver, prevalidated, checker);
            } else if (lname.equals("suppress-indentation")) {
                ResultDocument.processListOfElementNames(details, "{http://saxon.sf.net/}suppress-indentation", value, nsResolver, prevalidated, checker);
            } else if (lname.equals("double-space")) {
                ResultDocument.processListOfElementNames(details, "{http://saxon.sf.net/}double-space", value, nsResolver, prevalidated, checker);
            } else {
                if (lname.equals("next-in-chain")) {
                    XPathException e = new XPathException("saxon:next-in-chain value cannot be specified dynamically");
                    e.setErrorCodeQName(new StructuredQName("saxon", "http://saxon.sf.net/", "SXWN9004"));
                    throw e;
                }
                if (lname.equals("output-version")) {
                    lname = "version";
                }
                String clarkName = lname;
                if (uri.length() != 0) {
                    clarkName = '{' + uri + '}' + lname;
                }
                if (!prevalidated) {
                    try {
                        SaxonOutputKeys.checkOutputProperty(clarkName, value, config);
                    }
                    catch (XPathException err) {
                        err.setErrorCode("XTDE0030");
                        throw err;
                    }
                }
                details.setProperty(clarkName, value);
            }
        } else {
            details.setProperty('{' + uri + '}' + lname, value);
        }
    }

    private static void processListOfElementNames(Properties details, String key, String value, NamespaceResolver nsResolver, boolean prevalidated, NameChecker checker) throws XPathException {
        String existing = details.getProperty(key);
        if (existing == null) {
            existing = "";
        }
        String s = SaxonOutputKeys.parseListOfElementNames(value, nsResolver, prevalidated, checker, "XTDE0030");
        details.setProperty(key, existing + s);
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("resultDocument");
        this.content.explain(out);
        out.endElement();
    }

    public static void processXslOutputElement(NodeInfo element, Properties props, XPathContext c) throws XPathException {
        NodeInfo att;
        AxisIterator iter = element.iterateAxis((byte)2);
        InscopeNamespaceResolver resolver2 = new InscopeNamespaceResolver(element);
        while ((att = (NodeInfo)iter.next()) != null) {
            String uri = att.getURI();
            String local = att.getLocalPart();
            String val = Whitespace.trim(att.getStringValueCS());
            ResultDocument.setSerializationProperty(props, uri, local, val, resolver2, false, c.getConfiguration());
        }
    }
}

