/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.io.Serializable;
import javax.xml.namespace.QName;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class StructuredQName
implements Serializable {
    private static final String EMPTY_STRING = "";
    private char[] content;
    private int localNameStart;
    private int prefixStart;

    public StructuredQName(String prefix, String uri, String localName) {
        if (uri == null) {
            uri = EMPTY_STRING;
        }
        int plen = prefix.length();
        int ulen = uri.length();
        int llen = localName.length();
        this.localNameStart = ulen;
        this.prefixStart = ulen + llen;
        this.content = new char[ulen + llen + plen];
        uri.getChars(0, ulen, this.content, 0);
        localName.getChars(0, llen, this.content, ulen);
        prefix.getChars(0, plen, this.content, ulen + llen);
    }

    public StructuredQName(NamePool pool, int nameCode) {
        this(pool.getPrefix(nameCode), pool.getURI(nameCode), pool.getLocalName(nameCode));
    }

    public static StructuredQName fromClarkName(String expandedName) {
        String localName;
        String namespace;
        if (expandedName.charAt(0) == '{') {
            int closeBrace = expandedName.indexOf(125);
            if (closeBrace < 0) {
                throw new IllegalArgumentException("No closing '}' in Clark name");
            }
            namespace = expandedName.substring(1, closeBrace);
            if (closeBrace == expandedName.length()) {
                throw new IllegalArgumentException("Missing local part in Clark name");
            }
            localName = expandedName.substring(closeBrace + 1);
        } else {
            namespace = EMPTY_STRING;
            localName = expandedName;
        }
        return new StructuredQName(EMPTY_STRING, namespace, localName);
    }

    public static StructuredQName fromLexicalQName(CharSequence lexicalName, boolean useDefault, NameChecker checker, NamespaceResolver resolver2) throws XPathException {
        try {
            String[] parts = checker.getQNameParts(Whitespace.trimWhitespace(lexicalName));
            String uri = resolver2.getURIForPrefix(parts[0], useDefault);
            if (uri == null) {
                XPathException de = new XPathException("Namespace prefix '" + parts[0] + "' has not been declared");
                de.setErrorCode("FONS0004");
                throw de;
            }
            return new StructuredQName(parts[0], uri, parts[1]);
        }
        catch (QNameException e) {
            XPathException de = new XPathException(e.getMessage());
            de.setErrorCode("FOCA0002");
            throw de;
        }
    }

    public String getPrefix() {
        return new String(this.content, this.prefixStart, this.content.length - this.prefixStart);
    }

    public String getNamespaceURI() {
        if (this.localNameStart == 0) {
            return EMPTY_STRING;
        }
        return new String(this.content, 0, this.localNameStart);
    }

    public String getLocalName() {
        return new String(this.content, this.localNameStart, this.prefixStart - this.localNameStart);
    }

    public String getDisplayName() {
        if (this.prefixStart == this.content.length) {
            return this.getLocalName();
        }
        FastStringBuffer buff = new FastStringBuffer(this.content.length - this.localNameStart + 1);
        buff.append(this.content, this.prefixStart, this.content.length - this.prefixStart);
        buff.append(':');
        buff.append(this.content, this.localNameStart, this.prefixStart - this.localNameStart);
        return buff.toString();
    }

    public String getClarkName() {
        FastStringBuffer buff = new FastStringBuffer(this.content.length - this.prefixStart + 2);
        if (this.localNameStart > 0) {
            buff.append('{');
            buff.append(this.content, 0, this.localNameStart);
            buff.append('}');
        }
        buff.append(this.content, this.localNameStart, this.prefixStart - this.localNameStart);
        return buff.toString();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean equals(Object other) {
        if (other instanceof StructuredQName) {
            StructuredQName sq2 = (StructuredQName)other;
            if (this.localNameStart != sq2.localNameStart || this.prefixStart != sq2.prefixStart) {
                return false;
            }
            for (int i = this.prefixStart - 1; i >= 0; --i) {
                if (this.content[i] == sq2.content[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int h = -2147180533;
        h ^= this.prefixStart;
        h ^= this.localNameStart;
        for (int i = this.prefixStart - 1; i >= 0; --i) {
            h ^= this.content[i] << (i & 0x1F);
        }
        return h;
    }

    public QName toJaxpQName() {
        return new QName(this.getNamespaceURI(), this.getLocalName(), this.getPrefix());
    }
}

