/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.io.PrintStream;
import java.util.HashMap;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.StandardErrorListener;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DateTimeValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicQueryContext {
    private Item contextItem;
    private HashMap<String, Object> parameters;
    private Configuration config;
    private URIResolver uriResolver;
    private ErrorListener errorListener;
    private TraceListener traceListener;
    private DateTimeValue currentDateTime;
    private PrintStream traceFunctionDestination = System.err;
    private int validationMode = 0;

    public DynamicQueryContext(Configuration config) {
        this.config = config;
        this.uriResolver = config.getURIResolver();
        this.errorListener = config.getErrorListener();
        try {
            this.traceListener = config.makeTraceListener();
        }
        catch (XPathException err) {
            throw new IllegalStateException(err.getMessage());
        }
        if (this.errorListener instanceof StandardErrorListener) {
            this.errorListener = ((StandardErrorListener)this.errorListener).makeAnother(51);
            ((StandardErrorListener)this.errorListener).setRecoveryPolicy(2);
        }
    }

    public int getSchemaValidationMode() {
        return this.validationMode;
    }

    public void setSchemaValidationMode(int validationMode) {
        this.validationMode = validationMode;
    }

    public void setContextNode(NodeInfo node) {
        if (node == null) {
            throw new NullPointerException("Context node cannot be null");
        }
        this.setContextItem(node);
    }

    public void setContextItem(Item item) {
        if (item == null) {
            throw new NullPointerException("Context item cannot be null");
        }
        if (item instanceof NodeInfo && !((NodeInfo)item).getConfiguration().isCompatible(this.config)) {
            throw new IllegalArgumentException("Supplied node must be built using the same or a compatible Configuration");
        }
        this.contextItem = item;
    }

    public Item getContextItem() {
        return this.contextItem;
    }

    public void setParameter(String expandedName, Object value) {
        if (this.parameters == null) {
            this.parameters = new HashMap(10);
        }
        this.parameters.put(expandedName, value);
    }

    public void setParameterValue(String expandedName, ValueRepresentation value) {
        if (this.parameters == null) {
            this.parameters = new HashMap(10);
        }
        this.parameters.put(expandedName, value);
    }

    public void clearParameters() {
        this.parameters = null;
    }

    public Object getParameter(String expandedName) {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.get(expandedName);
    }

    public HashMap<String, Object> getParameters() {
        if (this.parameters == null) {
            return new HashMap<String, Object>(4);
        }
        return this.parameters;
    }

    public void setURIResolver(URIResolver resolver2) {
        this.uriResolver = resolver2;
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public void setErrorListener(ErrorListener listener) {
        this.errorListener = listener;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void setTraceListener(TraceListener listener) {
        this.traceListener = listener;
    }

    public TraceListener getTraceListener() {
        return this.traceListener;
    }

    public void setTraceFunctionDestination(PrintStream stream) {
        this.traceFunctionDestination = stream;
    }

    public PrintStream getTraceFunctionDestination() {
        return this.traceFunctionDestination;
    }

    public DateTimeValue getCurrentDateTime() {
        return this.currentDateTime;
    }

    public void setCurrentDateTime(DateTimeValue dateTime) throws XPathException {
        this.currentDateTime = dateTime;
        if (dateTime.getComponent(7) == null) {
            throw new XPathException("Supplied date/time must include a timezone");
        }
    }

    public Configuration getConfiguration() {
        return this.config;
    }
}

