/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xpath;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.Source;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.sxpath.AbstractStaticContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.xpath.JAXPVariable;
import net.sf.saxon.xpath.XPathFunctionLibrary;

public class JAXPXPathStaticContext
extends AbstractStaticContext
implements StaticContext,
NamespaceResolver,
Container {
    private SlotManager stackFrameMap;
    private XPathFunctionLibrary xpathFunctionLibrary;
    private NamespaceContext namespaceContext = new MinimalNamespaceContext();
    private XPathVariableResolver variableResolver;

    public JAXPXPathStaticContext(Configuration config) {
        this.setConfiguration(config);
        this.stackFrameMap = config.makeSlotManager();
        this.setDefaultFunctionLibrary();
        this.xpathFunctionLibrary = new XPathFunctionLibrary();
        this.addFunctionLibrary(this.xpathFunctionLibrary);
    }

    public int getContainerGranularity() {
        return 1;
    }

    public void setNamespaceContext(NamespaceContext context) {
        this.namespaceContext = context;
    }

    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    public SlotManager getStackFrameMap() {
        return this.stackFrameMap;
    }

    public void setXPathVariableResolver(XPathVariableResolver resolver2) {
        this.variableResolver = resolver2;
    }

    public XPathVariableResolver getXPathVariableResolver() {
        return this.variableResolver;
    }

    public void setXPathFunctionResolver(XPathFunctionResolver xPathFunctionResolver) {
        if (this.xpathFunctionLibrary != null) {
            this.xpathFunctionLibrary.setXPathFunctionResolver(xPathFunctionResolver);
        }
    }

    public XPathFunctionResolver getXPathFunctionResolver() {
        if (this.xpathFunctionLibrary != null) {
            return this.xpathFunctionLibrary.getXPathFunctionResolver();
        }
        return null;
    }

    public String getURIForPrefix(String prefix) throws XPathException {
        String uri = this.getURIForPrefix(prefix, false);
        if (uri == null) {
            throw new XPathException("Prefix " + prefix + " has not been declared");
        }
        return uri;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this;
    }

    public String getURIForPrefix(String prefix, boolean useDefault) {
        if (prefix.equals("")) {
            if (useDefault) {
                return this.getDefaultElementNamespace();
            }
            return "";
        }
        return this.namespaceContext.getNamespaceURI(prefix);
    }

    public Iterator iteratePrefixes() {
        if (this.namespaceContext instanceof NamespaceResolver) {
            return ((NamespaceResolver)((Object)this.namespaceContext)).iteratePrefixes();
        }
        throw new UnsupportedOperationException();
    }

    public final Expression bindVariable(StructuredQName qName) throws XPathException {
        if (this.variableResolver != null) {
            return new VariableReference(new JAXPVariable(qName, this.variableResolver));
        }
        throw new XPathException("Variable is used in XPath expression, but no JAXP VariableResolver is available");
    }

    public void importSchema(Source source) throws SchemaException {
        this.getConfiguration().addSchemaSource(source, this.getConfiguration().getErrorListener());
        this.getExecutable().setSchemaAware(true);
    }

    public boolean isImportedSchema(String namespace) {
        return this.getConfiguration().isSchemaAvailable(namespace);
    }

    public Set getImportedSchemaNamespaces() {
        return this.getConfiguration().getImportedNamespaces();
    }

    private static class MinimalNamespaceContext
    implements NamespaceContext,
    NamespaceResolver {
        private MinimalNamespaceContext() {
        }

        public String getNamespaceURI(String prefix) {
            if (prefix == null) {
                throw new IllegalArgumentException("prefix");
            }
            if (prefix.equals("")) {
                return "";
            }
            if (prefix.equals("xml")) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            if (prefix.equals("xs")) {
                return "http://www.w3.org/2001/XMLSchema";
            }
            if (prefix.equals("xsi")) {
                return "http://www.w3.org/2001/XMLSchema-instance";
            }
            if (prefix.equals("saxon")) {
                return "http://saxon.sf.net/";
            }
            return null;
        }

        public String getPrefix(String namespaceURI) {
            throw new UnsupportedOperationException();
        }

        public Iterator getPrefixes(String namespaceURI) {
            throw new UnsupportedOperationException();
        }

        public Iterator iteratePrefixes() {
            String[] prefixes = new String[]{"", "xml", "xs", "xsi", "saxon"};
            return Arrays.asList(prefixes).iterator();
        }

        public String getURIForPrefix(String prefix, boolean useDefault) {
            return this.getNamespaceURI(prefix);
        }
    }
}

