/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import javax.mail.Header;
import org.apache.axiom.attachments.MIMEBodyPartInputStream;
import org.apache.axiom.attachments.Part;
import org.apache.axiom.attachments.impl.BufferUtils;
import org.apache.axiom.attachments.impl.PartOnFile;
import org.apache.axiom.attachments.impl.PartOnMemoryEnhanced;
import org.apache.axiom.attachments.lifecycle.LifecycleManager;
import org.apache.axiom.attachments.utils.BAAInputStream;
import org.apache.axiom.attachments.utils.BAAOutputStream;
import org.apache.axiom.om.OMException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PartFactory {
    private static Log log = LogFactory.getLog(class$org$apache$axiom$attachments$impl$PartFactory == null ? (class$org$apache$axiom$attachments$impl$PartFactory = PartFactory.class$("org.apache.axiom.attachments.impl.PartFactory")) : class$org$apache$axiom$attachments$impl$PartFactory);
    static /* synthetic */ Class class$org$apache$axiom$attachments$impl$PartFactory;

    public static Part createPart(LifecycleManager manager, MIMEBodyPartInputStream in, boolean isSOAPPart, int threshholdSize, String attachmentDir, int messageContentLength) throws OMException {
        if (log.isDebugEnabled()) {
            log.debug("Start createPart()");
            log.debug("  isSOAPPart=" + isSOAPPart);
            log.debug("  threshholdSize= " + threshholdSize);
            log.debug("  attachmentDir=" + attachmentDir);
            log.debug("  messageContentLength " + messageContentLength);
        }
        try {
            int t2;
            Hashtable headers = new Hashtable();
            InputStream dross = PartFactory.readHeaders(in, headers);
            if (isSOAPPart || threshholdSize <= 0 || messageContentLength > 0 && messageContentLength < threshholdSize) {
                BAAOutputStream baaos = new BAAOutputStream();
                BufferUtils.inputStream2OutputStream(dross, baaos);
                BufferUtils.inputStream2OutputStream(in, baaos);
                return new PartOnMemoryEnhanced(headers, baaos.buffers(), baaos.length());
            }
            BAAOutputStream baaos = new BAAOutputStream();
            int t1 = BufferUtils.inputStream2OutputStream(dross, baaos, threshholdSize);
            int total = t1 + (t2 = BufferUtils.inputStream2OutputStream(in, baaos, threshholdSize - t1));
            if (total < threshholdSize) {
                return new PartOnMemoryEnhanced(headers, baaos.buffers(), baaos.length());
            }
            BAAInputStream baais = new BAAInputStream(baaos.buffers(), baaos.length());
            return new PartOnFile(manager, headers, baais, in, attachmentDir);
        }
        catch (Exception e) {
            throw new OMException(e);
        }
    }

    private static InputStream readHeaders(InputStream in, Map headers) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("initHeaders");
        }
        boolean done = false;
        int BUF_SIZE = 1024;
        byte[] headerBytes = new byte[1024];
        int size = in.read(headerBytes);
        int index = 0;
        StringBuffer sb = new StringBuffer(50);
        while (!done && index < size) {
            byte ch = headerBytes[index];
            if (++index == size) {
                size = in.read(headerBytes);
                index = 0;
            }
            if (ch == 13) {
                ch = headerBytes[index];
                if (++index == size) {
                    size = in.read(headerBytes);
                    index = 0;
                }
                if (ch == 10) {
                    ch = headerBytes[index];
                    if (++index == size) {
                        size = in.read(headerBytes);
                        index = 0;
                    }
                    if (ch == 13) {
                        ch = headerBytes[index];
                        if (++index == size) {
                            size = in.read(headerBytes);
                            index = 0;
                        }
                        if (ch != 10) continue;
                        PartFactory.readHeader(sb, headers);
                        sb.delete(0, sb.length());
                        done = true;
                        continue;
                    }
                    PartFactory.readHeader(sb, headers);
                    sb.delete(0, sb.length());
                    sb.append((char)ch);
                    continue;
                }
                sb.append(13);
                sb.append((char)ch);
                continue;
            }
            sb.append((char)ch);
        }
        if (log.isDebugEnabled()) {
            log.debug("End initHeaders");
        }
        if (index >= size) {
            index = size;
        }
        ByteArrayInputStream dross = new ByteArrayInputStream(headerBytes, index, size - index);
        return dross;
    }

    private static void readHeader(StringBuffer header, Map headers) {
        int delimiter = header.indexOf(":");
        String name = header.substring(0, delimiter).trim();
        String value = header.substring(delimiter + 1, header.length()).trim();
        if (log.isDebugEnabled()) {
            log.debug("addHeader: (" + name + ") value=(" + value + ")");
        }
        Header headerObj = new Header(name, value);
        String key = name.toLowerCase();
        headers.put(key, headerObj);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class BAOS
    extends ByteArrayOutputStream {
        public BAOS() {
            super(16384);
        }

        public byte[] toByteArray() {
            return this.buf;
        }
    }
}

