/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments.lifecycle.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.mail.MessagingException;
import org.apache.axiom.attachments.CachedFileDataSource;
import org.apache.axiom.attachments.lifecycle.LifecycleManager;
import org.apache.axiom.attachments.lifecycle.impl.LifecycleEventHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileAccessor
implements LifecycleEventHandler {
    private static final Log log = LogFactory.getLog(class$org$apache$axiom$attachments$lifecycle$impl$FileAccessor == null ? (class$org$apache$axiom$attachments$lifecycle$impl$FileAccessor = FileAccessor.class$("org.apache.axiom.attachments.lifecycle.impl.FileAccessor")) : class$org$apache$axiom$attachments$lifecycle$impl$FileAccessor);
    File file = null;
    LifecycleManager manager;
    private static final int DELETE_INTERVAL = 1800;
    static /* synthetic */ Class class$org$apache$axiom$attachments$lifecycle$impl$FileAccessor;

    public FileAccessor(LifecycleManager manager, File file) {
        this.manager = manager;
        this.file = file;
    }

    public DataHandler getDataHandler(String contentType) throws MessagingException {
        if (log.isDebugEnabled()) {
            log.debug("getDataHandler()");
        }
        CachedFileDataSource dataSource = new CachedFileDataSource(this.file);
        dataSource.setContentType(contentType);
        return new DataHandler(dataSource);
    }

    public String getFileName() throws MessagingException {
        if (log.isDebugEnabled()) {
            log.debug("getFileName()");
        }
        return this.file.getAbsolutePath();
    }

    public InputStream getInputStream() throws IOException, MessagingException {
        if (log.isDebugEnabled()) {
            log.debug("getInputStream()");
        }
        return new FileInputStream(this.file);
    }

    public OutputStream getOutputStream() throws FileNotFoundException {
        if (log.isDebugEnabled()) {
            log.debug("getOutputStream()");
        }
        return new FileOutputStream(this.file);
    }

    public long getSize() {
        return this.file.length();
    }

    public void handleEvent(int eventId) throws IOException {
        switch (eventId) {
            case 1: {
                this.manager.deleteOnExit(this.file);
                break;
            }
            case 3: {
                this.manager.deleteOnTimeInterval(1800, this.file);
                break;
            }
            case 2: {
                this.manager.delete(this.file);
                break;
            }
            default: {
                this.manager.delete(this.file);
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

