/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.julia.control.lifecycle;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.julia.control.content.Util;
import org.objectweb.fractal.julia.control.lifecycle.ChainedIllegalLifeCycleException;
import org.objectweb.fractal.julia.control.lifecycle.LifeCycleCoordinator;

public abstract class BasicLifeCycleCoordinatorMixin
implements LifeCycleCoordinator {
    public List fcActive;
    public Component _this_weaveableC;

    private BasicLifeCycleCoordinatorMixin() {
    }

    public void setFcState(boolean started) throws IllegalLifeCycleException {
        Component thisComponent;
        try {
            thisComponent = (Component)this._this_weaveableC.getFcInterface("component");
        }
        catch (NoSuchInterfaceException e) {
            throw new ChainedIllegalLifeCycleException(e, this._this_weaveableC, "Cannot set the lifecycle state");
        }
        List allSubComponents = Util.getAllSubComponents(thisComponent);
        int i = 0;
        while (i < allSubComponents.size()) {
            block9: {
                LifeCycleCoordinator lc;
                Component c = (Component)allSubComponents.get(i);
                try {
                    lc = (LifeCycleCoordinator)c.getFcInterface("lifecycle-controller");
                }
                catch (Exception e) {
                    try {
                        lc = (LifeCycleCoordinator)c.getFcInterface("/lifecycle-coordinator");
                    }
                    catch (NoSuchInterfaceException f) {
                        break block9;
                    }
                }
                if (started) {
                    lc.setFcStarted();
                } else {
                    lc.setFcStopped();
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fcActivated(LifeCycleCoordinator component) {
        List list = this.fcActive;
        synchronized (list) {
            if (this.fcActive.size() > 0) {
                if (!this.fcActive.contains(component)) {
                    this.fcActive.add(component);
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fcInactivated(LifeCycleCoordinator component) {
        List list = this.fcActive;
        synchronized (list) {
            this.fcActive.remove(component);
            this.fcActive.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopFc(LifeCycleCoordinator[] components) throws IllegalLifeCycleException {
        LifeCycleCoordinator c;
        this.fcActive = new ArrayList();
        int i = 0;
        while (i < components.length) {
            if (components[i].getFcState().equals("STARTED")) {
                this.fcActive.add(components[i]);
            }
            ++i;
        }
        try {
            c = (LifeCycleCoordinator)this._this_weaveableC.getFcInterface("lifecycle-controller");
        }
        catch (Exception e) {
            try {
                c = (LifeCycleCoordinator)this._this_weaveableC.getFcInterface("/lifecycle-coordinator");
            }
            catch (NoSuchInterfaceException f) {
                throw new ChainedIllegalLifeCycleException(f, this._this_weaveableC, "Cannot stop components");
            }
        }
        int i2 = 0;
        while (i2 < components.length) {
            if (components[i2].getFcState().equals("STARTED")) {
                components[i2].setFcStopping(c);
            }
            ++i2;
        }
        List list = this.fcActive;
        synchronized (list) {
            while (this.fcActive.size() > 0) {
                try {
                    this.fcActive.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        int i3 = 0;
        while (i3 < components.length) {
            if (components[i3].getFcState().equals("STARTED")) {
                components[i3].setFcStopped();
            }
            ++i3;
        }
        this.fcActive = null;
    }
}

