/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.julia.control.lifecycle;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.julia.control.binding.Util;
import org.objectweb.fractal.julia.control.lifecycle.ChainedIllegalLifeCycleException;
import org.objectweb.fractal.julia.control.lifecycle.LifeCycleCoordinator;

public abstract class OptimizedLifeCycleControllerMixin
implements LifeCycleCoordinator {
    public boolean fcStarted;
    public Component _this_weaveableC;

    private OptimizedLifeCycleControllerMixin() {
    }

    public String getFcState() {
        return this.fcStarted ? "STARTED" : "STOPPED";
    }

    public void startFc() throws IllegalLifeCycleException {
        Component id;
        try {
            id = (Component)this._this_weaveableC.getFcInterface("component");
        }
        catch (NoSuchInterfaceException e) {
            throw new ChainedIllegalLifeCycleException(e, this._this_weaveableC, "Cannot start component");
        }
        LifeCycleCoordinator[] clccs = this.getFcLifeCycleControllers(id);
        int i = 0;
        while (i < clccs.length) {
            clccs[i].setFcStarted();
            ++i;
        }
        this._this_setFcState(true);
    }

    public void stopFc() throws IllegalLifeCycleException {
        Component id;
        try {
            id = (Component)this._this_weaveableC.getFcInterface("component");
        }
        catch (NoSuchInterfaceException e) {
            throw new ChainedIllegalLifeCycleException(e, this._this_weaveableC, "Cannot stop component");
        }
        LifeCycleCoordinator[] clccs = this.getFcLifeCycleControllers(id);
        this._this_stopFc(clccs);
        this._this_setFcState(false);
    }

    public boolean setFcStarted() {
        if (!this.fcStarted) {
            this.fcStarted = true;
            return true;
        }
        return false;
    }

    public void setFcStopping(LifeCycleCoordinator coordinator) throws IllegalLifeCycleException {
        throw new Error("Internal error");
    }

    public boolean setFcStopped() {
        if (this.fcStarted) {
            this.fcStarted = false;
            return true;
        }
        return false;
    }

    public LifeCycleCoordinator[] getFcLifeCycleControllers(Component id) throws IllegalLifeCycleException {
        List clccList = this.getFcInternalLifeCycleControllers();
        Object[] sItfs = id.getFcInterfaces();
        HashSet visited = new HashSet();
        int i = 0;
        while (i < sItfs.length) {
            Interface sItf = (Interface)sItfs[i];
            if (!((InterfaceType)sItf.getFcItfType()).isFcClientItf()) {
                this.getSExtLifeCycleControllers(sItf, clccList, visited);
            }
            ++i;
        }
        LifeCycleCoordinator[] clccs = new LifeCycleCoordinator[clccList.size()];
        return clccList.toArray(clccs);
    }

    private void getSExtLifeCycleControllers(Interface serverItf, List clccList, Set visited) throws IllegalLifeCycleException {
        Object[] comps;
        try {
            comps = Util.getFcPotentialClientsOf(serverItf).toArray();
        }
        catch (Exception e) {
            throw new ChainedIllegalLifeCycleException(e, serverItf.getFcItfOwner(), "Cannot get the LifeCycleCoordinator interfaces");
        }
        int i = 0;
        while (i < comps.length) {
            Interface[] clientItfs;
            Component comp = (Component)comps[i];
            try {
                List l = Util.getFcClientItfsBoundTo(comp, serverItf);
                clientItfs = l.toArray(new Interface[l.size()]);
            }
            catch (Exception e) {
                throw new ChainedIllegalLifeCycleException(e, serverItf.getFcItfOwner(), "Cannot get the LifeCycleCoordinator interfaces");
            }
            int j = 0;
            while (j < clientItfs.length) {
                this.getCExtLifeCycleControllers(clientItfs[j], clccList, visited);
                ++j;
            }
            ++i;
        }
    }

    private void getCExtLifeCycleControllers(Interface clientItf, List clccList, Set visited) throws IllegalLifeCycleException {
        Component component = clientItf.getFcItfOwner();
        ContentController cc = null;
        try {
            cc = (ContentController)component.getFcInterface("content-controller");
        }
        catch (NoSuchInterfaceException e) {
            // empty catch block
        }
        if (cc != null) {
            Interface itf;
            String name = clientItf.getFcItfName();
            try {
                itf = !clientItf.isFcInternalItf() ? (Interface)cc.getFcInternalInterface(name) : (Interface)component.getFcInterface(name);
            }
            catch (NoSuchInterfaceException e) {
                throw new ChainedIllegalLifeCycleException(e, component, "Cannot find the LifeCycleCoordinator interfaces");
            }
            if (!visited.contains(itf)) {
                visited.add(itf);
                this.getSExtLifeCycleControllers(itf, clccList, visited);
            }
        } else if (!visited.contains(clientItf)) {
            LifeCycleCoordinator lcc;
            visited.add(clientItf);
            Component c = clientItf.getFcItfOwner();
            try {
                lcc = (LifeCycleCoordinator)c.getFcInterface("lifecycle-controller");
            }
            catch (Exception e) {
                try {
                    lcc = (LifeCycleCoordinator)c.getFcInterface("/lifecycle-coordinator");
                }
                catch (NoSuchInterfaceException f) {
                    throw new ChainedIllegalLifeCycleException(f, component, "Primitive client without a LifeCycleCoordinator");
                }
            }
            if (!clccList.contains(lcc)) {
                clccList.add(lcc);
            }
        }
    }

    public List getFcInternalLifeCycleControllers() throws IllegalLifeCycleException {
        Component thisComponent;
        try {
            thisComponent = (Component)this._this_weaveableC.getFcInterface("component");
        }
        catch (NoSuchInterfaceException e) {
            throw new ChainedIllegalLifeCycleException(e, this._this_weaveableC, "The OptimizedLifeCycleControllerMixin requires components to provide the Component interface");
        }
        List allSubComponents = org.objectweb.fractal.julia.control.content.Util.getAllSubComponents(thisComponent);
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < allSubComponents.size()) {
            Component c = (Component)allSubComponents.get(i);
            try {
                c.getFcInterface("content-controller");
            }
            catch (NoSuchInterfaceException e) {
                try {
                    result.add((LifeCycleCoordinator)c.getFcInterface("lifecycle-controller"));
                }
                catch (Exception f) {
                    try {
                        result.add(c.getFcInterface("/lifecycle-coordinator"));
                    }
                    catch (NoSuchInterfaceException ignored) {
                        // empty catch block
                    }
                }
            }
            ++i;
        }
        return result;
    }

    public abstract void _this_setFcState(boolean var1) throws IllegalLifeCycleException;

    public abstract void _this_stopFc(LifeCycleCoordinator[] var1) throws IllegalLifeCycleException;
}

