/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.julia.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Fractal;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.Type;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalContentException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.factory.GenericFactory;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.api.type.ComponentType;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.julia.Controller;
import org.objectweb.fractal.julia.InitializationContext;
import org.objectweb.fractal.julia.control.content.Util;
import org.objectweb.fractal.julia.factory.ChainedInstantiationException;
import org.objectweb.fractal.julia.factory.Template;
import org.objectweb.fractal.julia.type.BasicComponentType;

public abstract class BasicTemplateMixin
implements Controller,
Template {
    public Type fcInstanceType;
    public Object[] fcContent;
    public Component _this_weaveableC;

    private BasicTemplateMixin() {
    }

    public void initFcController(InitializationContext ic) throws InstantiationException {
        this.fcContent = (Object[])ic.content;
        ComponentType tmplType = (ComponentType)ic.type;
        InterfaceType[] itfTypes = tmplType.getFcInterfaceTypes();
        ArrayList<InterfaceType> itfList = new ArrayList<InterfaceType>();
        int j = 0;
        while (j < itfTypes.length) {
            String n = itfTypes[j].getFcItfName();
            if (!n.equals("factory") && !n.equals("/template")) {
                if (n.equals("attribute-controller")) {
                    itfList.add(itfTypes[j]);
                } else if (!n.equals("component") && !n.endsWith("-controller")) {
                    itfList.add(itfTypes[j]);
                }
            }
            ++j;
        }
        itfTypes = new InterfaceType[itfList.size()];
        itfTypes = itfList.toArray(itfTypes);
        this.fcInstanceType = new BasicComponentType(itfTypes);
        this._super_initFcController(ic);
    }

    public Type getFcInstanceType() {
        return this.fcInstanceType;
    }

    public Object getFcControllerDesc() {
        return this.fcContent[0];
    }

    public Object getFcContentDesc() {
        return this.fcContent[1];
    }

    public Component newFcInstance() throws InstantiationException {
        int j;
        Component instance;
        Component thisComponent;
        try {
            thisComponent = (Component)this._this_weaveableC.getFcInterface("component");
        }
        catch (NoSuchInterfaceException e) {
            throw new ChainedInstantiationException(e, this._this_weaveableC, "The template component must provide the Component interface");
        }
        List allSubTemplates = Util.getAllSubComponents(thisComponent);
        HashMap<Component, Component> instances = new HashMap<Component, Component>();
        int i = 0;
        while (i < allSubTemplates.size()) {
            Template t;
            Component tmpl = (Component)allSubTemplates.get(i);
            try {
                t = (Template)tmpl.getFcInterface("factory");
            }
            catch (Exception e) {
                try {
                    t = (Template)tmpl.getFcInterface("/template");
                }
                catch (NoSuchInterfaceException f) {
                    throw new ChainedInstantiationException(f, this._this_weaveableC, "All the (sub) templates must provide the Template interface");
                }
            }
            instance = t.newFcControllerInstance();
            instances.put(tmpl, instance);
            ++i;
        }
        int i2 = 0;
        while (i2 < allSubTemplates.size()) {
            block39: {
                ContentController instanceCC;
                ContentController tmplCC;
                Component tmpl = (Component)allSubTemplates.get(i2);
                instance = (Component)instances.get(tmpl);
                try {
                    tmplCC = (ContentController)tmpl.getFcInterface("content-controller");
                }
                catch (NoSuchInterfaceException e) {
                    break block39;
                }
                try {
                    instanceCC = (ContentController)instance.getFcInterface("content-controller");
                }
                catch (NoSuchInterfaceException e) {
                    throw new ChainedInstantiationException(e, tmpl, "A component instantiated from a template with a ContentController interface must provide the ContentController interface");
                }
                Component[] subTemplates = tmplCC.getFcSubComponents();
                Component[] subInstances = instanceCC.getFcSubComponents();
                j = 0;
                while (j < subTemplates.length) {
                    Component subInstance = (Component)instances.get(subTemplates[j]);
                    boolean add = true;
                    int k = 0;
                    while (k < subInstances.length) {
                        if (subInstances[k].equals(subInstance)) {
                            add = false;
                        }
                        ++k;
                    }
                    if (add) {
                        try {
                            instanceCC.addFcSubComponent(subInstance);
                        }
                        catch (IllegalContentException e) {
                            throw new ChainedInstantiationException(e, tmpl, "Cannot set the component hierarchy from the template hierarchy");
                        }
                        catch (IllegalLifeCycleException e) {
                            throw new ChainedInstantiationException(e, tmpl, "Cannot set the component hierarchy from the template hierarchy");
                        }
                    }
                    ++j;
                }
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < allSubTemplates.size()) {
            block40: {
                BindingController instanceBC;
                BindingController tmplBC;
                Component tmpl = (Component)allSubTemplates.get(i3);
                Component instance2 = (Component)instances.get(tmpl);
                try {
                    tmplBC = (BindingController)tmpl.getFcInterface("binding-controller");
                }
                catch (NoSuchInterfaceException e) {
                    break block40;
                }
                try {
                    instanceBC = (BindingController)instance2.getFcInterface("binding-controller");
                }
                catch (NoSuchInterfaceException e) {
                    throw new ChainedInstantiationException(e, tmpl, "A component instantiated from a template with a BindingController interface must provide the BindingController interface");
                }
                String[] itfNames = tmplBC.listFc();
                j = 0;
                while (j < itfNames.length) {
                    block42: {
                        Component serverTmpl;
                        Component serverInstance;
                        Interface serverItf;
                        String itfName = itfNames[j];
                        try {
                            serverItf = (Interface)tmplBC.lookupFc(itfName);
                        }
                        catch (ClassCastException e) {
                            throw new ChainedInstantiationException(e, tmpl, "The server interface of each binding between templates must implement the Interface interface");
                        }
                        catch (NoSuchInterfaceException e) {
                            throw new ChainedInstantiationException(e, tmpl, "The '" + itfName + "' interface returned by the listFc method does not exist");
                        }
                        if (serverItf != null && (serverInstance = (Component)instances.get(serverTmpl = serverItf.getFcItfOwner())) != null) {
                            Object itfValue;
                            block41: {
                                try {
                                    if (serverItf.isFcInternalItf()) {
                                        ContentController cc = (ContentController)serverInstance.getFcInterface("content-controller");
                                        itfValue = cc.getFcInternalInterface(serverItf.getFcItfName());
                                    } else {
                                        itfValue = serverInstance.getFcInterface(serverItf.getFcItfName());
                                    }
                                }
                                catch (NoSuchInterfaceException e) {
                                    throw new ChainedInstantiationException(e, serverTmpl, "The server interface '" + serverItf.getFcItfName() + "'is missing in the component instantiated from the template");
                                }
                                try {
                                    if (!instanceBC.lookupFc(itfName).equals(itfValue)) break block41;
                                    break block42;
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            try {
                                instanceBC.bindFc(itfName, itfValue);
                            }
                            catch (NoSuchInterfaceException e) {
                                throw new ChainedInstantiationException(e, tmpl, "Cannot set the component bindings from the template bindings");
                            }
                            catch (IllegalBindingException e) {
                                throw new ChainedInstantiationException(e, tmpl, "Cannot set the component bindings from the template bindings");
                            }
                            catch (IllegalLifeCycleException e) {
                                throw new ChainedInstantiationException(e, tmpl, "Cannot set the component bindings from the template bindings");
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i3;
        }
        return (Component)instances.get(allSubTemplates.get(0));
    }

    public Component newFcControllerInstance() throws InstantiationException {
        GenericFactory factory;
        if (this.fcContent[1] instanceof Component) {
            return (Component)this.fcContent[1];
        }
        try {
            factory = (GenericFactory)Fractal.getBootstrapComponent().getFcInterface("generic-factory");
        }
        catch (InstantiationException e) {
            throw new ChainedInstantiationException(e, this._this_weaveableC, "Cannot find the GenericFactory interface of the bootstrap component, which is needed to instantiate the template");
        }
        catch (NoSuchInterfaceException e) {
            throw new ChainedInstantiationException(e, this._this_weaveableC, "Cannot find the GenericFactory interface of the bootstrap component, which is needed to instantiate the template");
        }
        return factory.newFcInstance(this.fcInstanceType, this.fcContent[0], this.fcContent[1]);
    }

    public abstract void _super_initFcController(InitializationContext var1) throws InstantiationException;
}

