/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.julia.factory;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.julia.Util;

public class ChainedInstantiationException
extends InstantiationException {
    private final Throwable exception;
    private transient Component factory;

    public ChainedInstantiationException(Throwable exception, Component factory, String message) {
        super(message);
        this.exception = exception;
        this.factory = factory;
    }

    public Throwable getException() {
        return this.exception;
    }

    public Component getFactory() {
        if (this.factory != null && !(this.factory instanceof Interface)) {
            try {
                return (Component)this.factory.getFcInterface("component");
            }
            catch (NoSuchInterfaceException ignored) {
            }
        }
        return this.factory;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("InstantiationException: ");
        buf.append(this.getMessage());
        if (this.getFactory() != null) {
            buf.append(" (template = ");
            Util.toString(this.getFactory(), buf);
            buf.append(')');
        }
        return buf.toString();
    }

    public void printStackTrace() {
        if (this.exception != null) {
            System.err.println(this);
            this.exception.printStackTrace();
        } else {
            super.printStackTrace();
        }
    }

    public void printStackTrace(PrintStream s) {
        if (this.exception != null) {
            s.println(this);
            this.exception.printStackTrace(s);
        } else {
            super.printStackTrace(s);
        }
    }

    public void printStackTrace(PrintWriter s) {
        if (this.exception != null) {
            s.write(this + "\n");
            this.exception.printStackTrace(s);
        } else {
            super.printStackTrace(s);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        Component c = this.getFactory();
        out.writeObject(c instanceof Interface ? c : null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.factory = (Component)in.readObject();
    }
}

