/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.julia.factory;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Type;
import org.objectweb.fractal.api.factory.GenericFactory;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.api.type.ComponentType;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.julia.factory.ChainedInstantiationException;
import org.objectweb.fractal.julia.loader.Initializable;
import org.objectweb.fractal.julia.loader.Tree;

public abstract class CheckGenericFactoryMixin
implements GenericFactory,
Initializable {
    private boolean useContextClassLoader;

    private CheckGenericFactoryMixin() {
    }

    public void initialize(Tree args) throws Exception {
        Tree t = args.getValue("use-context-class-loader");
        if (t != null && t.equals("true")) {
            this.useContextClassLoader = true;
        }
    }

    public Component newFcInstance(Type type, Object controllerDesc, Object contentDesc) throws InstantiationException {
        ClassLoader loader = null;
        if (controllerDesc instanceof Object[]) {
            loader = (ClassLoader)((Object[])controllerDesc)[0];
        }
        loader = (ClassLoader)this.getFcLoader(loader);
        this.checkFcType(type, loader);
        Object content = contentDesc;
        if (content instanceof Object[]) {
            content = ((Object[])content)[1];
        }
        if (content instanceof String) {
            this.checkFcContentClass(type, (String)content, loader);
        }
        return this._super_newFcInstance(type, controllerDesc, contentDesc);
    }

    public Object getFcLoader(Object loader) {
        if (loader == null) {
            if (this.useContextClassLoader) {
                return Thread.currentThread().getContextClassLoader();
            }
            return this.getClass().getClassLoader();
        }
        return this._super_getFcLoader(loader);
    }

    public void checkFcType(Type type, ClassLoader loader) throws InstantiationException {
        if (type instanceof ComponentType) {
            InterfaceType[] itfTypes = ((ComponentType)type).getFcInterfaceTypes();
            int i = 0;
            while (i < itfTypes.length) {
                Class<?> itf;
                InterfaceType itfType = itfTypes[i];
                String name = itfType.getFcItfName();
                String signature = itfType.getFcItfSignature();
                try {
                    itf = loader.loadClass(signature);
                }
                catch (ClassNotFoundException e) {
                    throw new ChainedInstantiationException(e, null, "No such interface: " + signature);
                }
                if (!itf.isInterface() || !Modifier.isPublic(itf.getModifiers())) {
                    throw new ChainedInstantiationException(null, null, signature + " is not a public interface");
                }
                if (name.equals("attribute-controller")) {
                    Class<?> ac;
                    try {
                        ac = loader.loadClass("org.objectweb.fractal.api.control.AttributeController");
                    }
                    catch (ClassNotFoundException e) {
                        throw new ChainedInstantiationException(e, null, "Cannot check this operation");
                    }
                    if (ac.isAssignableFrom(itf) && !this.checkFcAttributeControllerInterface(itf)) {
                        throw new ChainedInstantiationException(null, null, signature + " is not a valid attribute controller interface");
                    }
                }
                ++i;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkFcAttributeControllerInterface(Class itf) {
        HashMap types = new HashMap();
        Method[] meths = itf.getMethods();
        int i = 0;
        while (i < meths.length) {
            Method m = meths[i];
            String name = m.getName();
            Class<?>[] formals = m.getParameterTypes();
            Class<?> result = m.getReturnType();
            if (name.startsWith("get")) {
                if (formals.length != 0 || result.equals(Void.TYPE)) return false;
                types.put(name, result);
            } else {
                if (!name.startsWith("set") || formals.length != 1 || !result.equals(Void.TYPE)) return false;
                types.put(name, formals[0]);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < meths.length) {
            Class type;
            Method m = meths[i2];
            String name = m.getName();
            if (!(name.startsWith("get") ? (type = (Class)types.get("set" + name.substring(3))) == null || m.getReturnType().equals(type) : (type = (Class)types.get("get" + name.substring(3))) == null || m.getParameterTypes()[0].equals(type))) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public void checkFcContentClass(Type type, String content, ClassLoader loader) throws InstantiationException {
        Class<?> contentClass;
        try {
            contentClass = loader.loadClass(content);
        }
        catch (ClassNotFoundException e) {
            throw new ChainedInstantiationException(e, null, "Cannot find the component implementation class '" + content + "'");
        }
        int mods = contentClass.getModifiers();
        if (!Modifier.isPublic(mods) || Modifier.isAbstract(mods) || Modifier.isInterface(mods)) {
            throw new ChainedInstantiationException(null, null, "The component implementation class '" + content + "' is a not public, non abstract class");
        }
        try {
            contentClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ChainedInstantiationException(null, null, "The component implementation class '" + content + "' does not have a default public constructor");
        }
        boolean hasDependencies = false;
        ComponentType compType = (ComponentType)type;
        InterfaceType[] itfTypes = compType.getFcInterfaceTypes();
        int i = 0;
        while (i < itfTypes.length) {
            InterfaceType itfType = itfTypes[i];
            if (itfType.isFcClientItf()) {
                hasDependencies = true;
            }
            ++i;
        }
        if (hasDependencies) {
            Class<?> bc;
            try {
                bc = loader.loadClass("org.objectweb.fractal.api.control.BindingController");
            }
            catch (ClassNotFoundException e) {
                throw new ChainedInstantiationException(e, null, "Cannot find the BindingController class");
            }
            if (!bc.isAssignableFrom(contentClass)) {
                throw new ChainedInstantiationException(null, null, "The component implementation class '" + content + "' must implement the BindingController interface, " + "since the component type contains client interfaces");
            }
        }
        int i2 = 0;
        while (i2 < itfTypes.length) {
            InterfaceType itfType = itfTypes[i2];
            String itfName = itfType.getFcItfName();
            if (!(itfType.isFcClientItf() || itfType.isFcOptionalItf() || itfName.equals("component") || itfName.endsWith("-controller"))) {
                Class<?> itf;
                try {
                    itf = loader.loadClass(itfType.getFcItfSignature());
                }
                catch (ClassNotFoundException e) {
                    throw new ChainedInstantiationException(e, null, "Cannot find the Java interface '" + itfType.getFcItfSignature() + "' declared in the component type");
                }
                if (!itf.isAssignableFrom(contentClass)) {
                    throw new ChainedInstantiationException(null, null, "The component implementation class '" + content + "' does not implement the '" + itf.getName() + "' server interface declared in the component type");
                }
            }
            ++i2;
        }
    }

    public abstract void _super_initialize(Tree var1) throws Exception;

    public abstract Component _super_newFcInstance(Type var1, Object var2, Object var3) throws InstantiationException;

    public abstract Object _super_getFcLoader(Object var1);
}

