/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.objectweb.fractal.api.Type;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.julia.type.BasicComponentType;
import org.objectweb.fractal.julia.type.BasicInterfaceType;
import org.objectweb.fractal.juliac.CmdLineArgs;
import org.objectweb.fractal.juliac.CmdLineFlags;
import org.objectweb.fractal.juliac.CmdLineOptions;
import org.objectweb.fractal.juliac.CompilationRound;
import org.objectweb.fractal.juliac.CompilationRounds;
import org.objectweb.fractal.juliac.JuliacRuntimeException;
import org.objectweb.fractal.juliac.SourceFile;
import org.objectweb.fractal.juliac.Utils;
import org.objectweb.fractal.juliac.api.ADLParserSupportItf;
import org.objectweb.fractal.juliac.api.ClassGeneratorItf;
import org.objectweb.fractal.juliac.api.CompileSupportItf;
import org.objectweb.fractal.juliac.api.FCSourceCodeGeneratorItf;
import org.objectweb.fractal.juliac.api.SpoonSupportItf;
import org.objectweb.fractal.juliac.conf.ADLParser;
import org.objectweb.fractal.juliac.conf.Compiler;
import org.objectweb.fractal.juliac.conf.JDKLevel;
import org.objectweb.fractal.juliac.conf.JuliacConfig;
import org.objectweb.fractal.juliac.conf.JuliacGeneratorMap;
import org.objectweb.fractal.juliac.conf.JuliacInterceptorSourceCodeGeneratorMap;
import org.objectweb.fractal.juliac.opt.InitializerClassGenerator;
import org.objectweb.fractal.juliac.proxy.InterceptorClassGenerator;
import org.objectweb.fractal.juliac.ucf.UClassFactory;
import org.objectweb.fractal.juliac.ucf.UnifiedClass;
import org.objectweb.fractal.juliac.ucf.UnifiedClassFactoryItf;
import org.objectweb.fractal.juliac.visit.FileSourceCodeWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Juliac {
    private JuliacConfig jconf;
    private CompileSupportItf compiler;
    private SpoonSupportItf spoon;
    private List<UnifiedClassFactoryItf> ucfs = new ArrayList<UnifiedClassFactoryItf>();

    public static void main(String[] args) throws IOException, InstantiationException, ClassNotFoundException {
        boolean debug;
        String classJarFileName;
        String target;
        String source;
        String classDirName;
        String genDirName;
        String s;
        String[] adlParsers;
        CmdLineOptions[] options;
        if (args.length == 0) {
            Juliac.usage();
            return;
        }
        CmdLineArgs cla = new CmdLineArgs();
        for (CmdLineOptions option : options = CmdLineOptions.values()) {
            cla.registerOption(option);
            String[] domain = option.getDomain();
            if (domain == null) continue;
            cla.setOptionDomain(option, domain);
        }
        cla.registerFlags(CmdLineFlags.values());
        Juliac jc = new Juliac();
        JuliacConfig jconf = new JuliacConfig(jc);
        Logger logger = jconf.getLogger();
        jc.setJuliacConfig(jconf);
        try {
            cla.parse(args);
        }
        catch (IllegalArgumentException iae) {
            String msg = iae.getMessage();
            logger.severe(msg);
            return;
        }
        String opt = cla.getOptionValue(CmdLineOptions.OPT);
        if (opt == null) {
            opt = "";
        }
        jconf.setOptLevel(opt);
        jconf.loadOptLevels();
        JuliacGeneratorMap<InterceptorClassGenerator> iclgs = jconf.getInterceptorClassGenerators();
        String iclgstr = cla.getOptionValue(CmdLineOptions.ICLASSGS);
        if (iclgstr != null) {
            iclgs.set(iclgstr);
        }
        iclgs.load();
        JuliacInterceptorSourceCodeGeneratorMap iscgs = jconf.getInterceptorSourceCodeGenerators();
        String iscgstr = cla.getOptionValue(CmdLineOptions.ICODEGS);
        if (iscgstr != null) {
            iscgs.set(iscgstr);
        }
        iscgs.load();
        String compiler = cla.getOptionValue(CmdLineOptions.COMPILER);
        if (compiler != null) {
            jconf.setCompiler(compiler);
        }
        String[] stringArray = adlParsers = (s = cla.getOptionValue(CmdLineOptions.ADLPARSERS)) == null ? new String[]{} : s.split(":");
        if (adlParsers.length == 0) {
            ADLParser defaultParser = ADLParser.getDefaultADLParser();
            jconf.addADLParser(defaultParser);
        } else {
            jconf.addADLParserNames(adlParsers);
        }
        jconf.loadADLParsers();
        s = cla.getOptionValue(CmdLineOptions.SRCS);
        String[] srcs = s == null ? new String[]{} : s.split(";");
        jconf.addSrcs(srcs);
        s = cla.getOptionValue(CmdLineOptions.MIXINS);
        String[] srclibs = s == null ? new String[]{} : s.split(";");
        jconf.addSrclibs(srclibs);
        String pkgRoot = cla.getOptionValue(CmdLineOptions.PKGROOT);
        if (pkgRoot != null) {
            jconf.setPkgRoot(pkgRoot);
        }
        if ((genDirName = cla.getOptionValue(CmdLineOptions.GENSRC)) != null) {
            jconf.setGenDirName(genDirName);
        }
        if ((classDirName = cla.getOptionValue(CmdLineOptions.GENCLASS)) != null) {
            jconf.setClassDirName(classDirName);
        }
        if ((source = cla.getOptionValue(CmdLineOptions.SOURCE)) != null) {
            JDKLevel level = JDKLevel.valueOf(source);
            jconf.setSourceLevel(level);
        }
        if ((target = cla.getOptionValue(CmdLineOptions.TARGET)) != null) {
            JDKLevel level = JDKLevel.valueOf(target);
            jconf.setTargetLevel(level);
        }
        if ((classJarFileName = cla.getOptionValue(CmdLineOptions.GENCLASSJAR)) != null) {
            if (!cla.isFlagSet(CmdLineFlags.COMPILEGENERATED)) {
                String msg = "--genclassjar can not be used without --compiledGenerated";
                logger.severe(msg);
                return;
            }
            jconf.setClassJarFileName(classJarFileName);
        }
        if (debug = cla.isFlagSet(CmdLineFlags.DEBUG)) {
            JuliacConfig.setLevel(logger, Level.FINE);
        }
        boolean compilationWarnings = cla.isFlagSet(CmdLineFlags.COMPILATIONWARNINGS);
        jconf.setCompilationWarnings(compilationWarnings);
        List<String> files = cla.getFiles();
        logger.fine("Juliac classpath:");
        ClassLoader cl = Juliac.class.getClassLoader();
        if (cl instanceof URLClassLoader) {
            URL[] urls;
            URLClassLoader urlcl = (URLClassLoader)cl;
            for (URL url : urls = urlcl.getURLs()) {
                logger.fine("  " + url);
            }
        } else {
            String msg = "Class loader for the Juliac class is not a URLClassLoader";
            logger.fine(msg);
        }
        logger.fine("-----------------");
        if (cla.isFlagSet(CmdLineFlags.COMPILEINPUT)) {
            jc.compile();
        }
        for (String file : files) {
            String[] descs;
            logger.info(file + "...");
            ADLParser ap = jc.acceptADLDesc(file);
            if (ap != null) {
                jc.generate(ap, file, file);
                continue;
            }
            FCSourceCodeGeneratorItf<?> fcscg = jc.acceptCtrlDesc(file);
            if (fcscg != null) {
                jc.generate(file);
                continue;
            }
            for (String desc : descs = file.split(":")) {
                jc.generateForDesc(desc);
            }
        }
        if (cla.isFlagSet(CmdLineFlags.COMPILEGENERATED)) {
            jconf.setCompilationWarnings(false);
            jc.compile();
            jconf.setCompilationWarnings(compilationWarnings);
        }
        if (classJarFileName != null) {
            jc.packGeneratedFiles();
        }
        jc.close();
        logger.info("Done.");
    }

    private static void usage() {
        Juliac jc = new Juliac();
        JuliacConfig jconf = new JuliacConfig(jc);
        Logger logger = jconf.getLogger();
        logger.info("java " + Juliac.class.getName() + " [options] types");
        logger.info("Generate the Java source code associated with the specified ADL, membrane or component descriptors");
        logger.info("");
        logger.info("Options:");
        logger.info("");
        logger.info("  --adlparsers <parsers>  : the ADL parsers (default: FRACTAL_ADL)");
        logger.info("  --compiler <comp>       : Java compiler (default: JDT)");
        logger.info("  --gensrc <dir>          : directory for generated source code (default: target/generated-sources/juliac)");
        logger.info("  --genclass <dir>        : directory for compiled code (default: target/classes)");
        logger.info("  --genclassjar <file>    : package compiled generate code in file");
        logger.info("  --iclassgs <generators> : interceptor class generators (default: 'none')");
        logger.info("  --icodegs <generators>  : interceptor source code generators (default: 'none')");
        logger.info("  --mixins <dirs>         : mixin layer files (default: 'none'");
        logger.info("  --opt <level>           : component source code generators (default: OO)");
        logger.info("  --pkgRoot <name>        : root package for generated code (default: 'none')");
        logger.info("  --source <version>      : the Java source code compatibility level (default: 1.5)");
        logger.info("  --srcs <dirs>           : source files (default: src/main/java)");
        logger.info("  --target <version>      : the Java bytecode compatibility level (default: 1.5)");
        logger.info("");
        logger.info("  --compilationWarnings  : report compilation warnings");
        logger.info("  --compileInput         : compile input code");
        logger.info("  --compileGenerated     : compile generated code");
        logger.info("  --debug                : report debug information");
        logger.info("");
        logger.info("Details:");
        logger.info("  <dirs> is a semicolon-separated list of directories or jar files");
        logger.info("  <parsers> is a colon-separated list of ADL parser class names");
        logger.info("  <level> is:");
        logger.info("    - either one of the predefined values:");
        logger.info("      OO, MERGE_ALL, COMP, ULTRA_COMP or ULTRA_MERGE");
        logger.info("    - or a custom value: the fully-qualified name of a class");
        logger.info("      which implements FCSourceCodeGeneratorItf");
        logger.info("    - or a colon-separated list of predefined or custom values");
        logger.info("      e.g. OO:COMP");
        logger.info("        - a chain of responsibility pattern is applied on the specified");
        logger.info("          source code generators");
        logger.info("    - or a colon-separated list of pairs prefix=value");
        logger.info("      e.g. /julia/=OO:/koch/=COMP");
        logger.info("        - prefix is the name prefix to be appended in front of controller");
        logger.info("          descriptors. The first prefix is considered to be the default one.");
        logger.info("        - value is either predefined or custom");
        logger.info("  <generators> is a colon-separated list of pairs asmgen=srcgen");
        logger.info("    - asmgen is the fqname of the ASM bytecode generator");
        logger.info("    - srcgen is the fqname of the corresponding source code generator");
        logger.info("      e.g. org.objectweb.fractal.julia.asm.LifeCycleCodeGenerator=org.objectweb.fractal.juliac.proxy.LifeCycleSourceCodeGenerator");
        logger.info("  <comp> is:");
        logger.info("    - either one of the predefined values: JDT or JDK6");
        logger.info("    - or a custom value: the fully-qualified name of a class which implements CompileSupportItf");
    }

    public Juliac() {
        UClassFactory ucf = new UClassFactory(this);
        this.register(ucf);
    }

    public JuliacConfig getJuliacConfig() throws IllegalArgumentException {
        if (this.jconf == null) {
            String msg = "JuliacConfig (jconf) has not been set for this instance of Juliac: " + this;
            throw new IllegalArgumentException(msg);
        }
        return this.jconf;
    }

    public void setJuliacConfig(JuliacConfig jconf) {
        this.jconf = jconf;
    }

    public void close() throws IOException {
        JuliacConfig jconf = this.getJuliacConfig();
        jconf.close();
        if (this.compiler != null) {
            this.compiler.close(this);
        }
        if (this.spoon != null) {
            this.spoon.close(this);
        }
    }

    public ADLParser acceptADLDesc(String adl) {
        JuliacConfig jconf = this.getJuliacConfig();
        List<ADLParser> adlParsers = jconf.getADLParsers();
        for (ADLParser adlParser : adlParsers) {
            ADLParserSupportItf supportItf = adlParser.getSupportItf();
            if (supportItf == null) {
                ADLParser defaultParser = ADLParser.getDefaultADLParser();
                if (adlParser.equals((Object)defaultParser)) continue;
                String name = adlParser.getClassName();
                throw new JuliacRuntimeException(new ClassNotFoundException(name));
            }
            boolean b = supportItf.acceptADLDesc(adl);
            if (!b) continue;
            return adlParser;
        }
        return null;
    }

    public ADLParser getADLDesc(String adl) throws IOException {
        ADLParser adlParser = this.acceptADLDesc(adl);
        if (adlParser == null) {
            String msg = "No such ADL parser for: " + adl;
            throw new IOException(msg);
        }
        return adlParser;
    }

    public void generate(String adl, String targetname) throws IOException {
        ADLParser adlParser = this.getADLDesc(adl);
        ADLParserSupportItf supportItf = adlParser.getSupportItf();
        String rootedName = this.getRootedClassName(targetname);
        JuliacConfig jconf = this.getJuliacConfig();
        Logger logger = jconf.getLogger();
        logger.info("[ADLParser: " + supportItf.getClass().getName() + "]");
        supportItf.generate(adl, rootedName, null);
    }

    private void generate(ADLParser adlParser, String adl, String targetname) throws IOException {
        ADLParserSupportItf supportItf = adlParser.getSupportItf();
        String rootedName = this.getRootedClassName(targetname);
        JuliacConfig jconf = this.getJuliacConfig();
        Logger logger = jconf.getLogger();
        logger.info("[ADLParser: " + supportItf.getClass().getName() + "]");
        supportItf.generate(adl, rootedName, null);
    }

    public FCSourceCodeGeneratorItf<?> acceptCtrlDesc(Object controllerDesc) {
        FCSourceCodeGeneratorItf<?> fcscg = null;
        try {
            fcscg = this.getFCSourceCodeGenerator(controllerDesc);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
        return fcscg;
    }

    public FCSourceCodeGeneratorItf<?> generate(Object controllerDesc) throws IOException, InstantiationException, IllegalArgumentException {
        String ctrlDesc = (String)controllerDesc;
        BasicComponentType ct = new BasicComponentType(new BasicInterfaceType[0]);
        FCSourceCodeGeneratorItf<?> fcscg = this.getFCSourceCodeGenerator(ctrlDesc);
        JuliacConfig jconf = this.getJuliacConfig();
        Logger logger = jconf.getLogger();
        logger.info("[Generator: " + fcscg.getClass().getName() + "]");
        fcscg.generateMembraneImpl(ct, ctrlDesc, null);
        return fcscg;
    }

    public FCSourceCodeGeneratorItf<?> generateProxiesImpl(String signature, Object controllerDesc) throws IOException, IllegalArgumentException {
        String ctrlDesc = (String)controllerDesc;
        FCSourceCodeGeneratorItf<?> fcscg = this.getFCSourceCodeGenerator(ctrlDesc);
        JuliacConfig jconf = this.getJuliacConfig();
        Logger logger = jconf.getLogger();
        logger.info("[Generator: " + fcscg.getClass().getName() + "]");
        fcscg.generateProxiesImpl(signature, controllerDesc);
        return fcscg;
    }

    public InitializerClassGenerator<?> generate(Type type, Object controllerDesc, Object contentDesc) throws IOException, IllegalArgumentException {
        FCSourceCodeGeneratorItf<?> fcscg = this.getFCSourceCodeGenerator(controllerDesc);
        JuliacConfig jconf = this.getJuliacConfig();
        Logger logger = jconf.getLogger();
        logger.info("[Generator: " + fcscg.getClass().getName() + "]");
        InitializerClassGenerator<?> icg = fcscg.generate(type, controllerDesc, contentDesc);
        return icg;
    }

    public void generateForDesc(String desc) throws IOException, IllegalArgumentException, InstantiationException {
        String msg = "Expected component descriptor [name/signature/bool/bool/bool,controllerDesc,contentDesc]. Got: " + desc;
        if (desc.length() < "[x/x/true/true/true,x,x]".length()) {
            throw new IllegalArgumentException(msg);
        }
        if (desc.charAt(0) != '[' && desc.charAt(desc.length() - 1) != ']') {
            throw new IllegalArgumentException(msg);
        }
        String[] elts = (desc = desc.substring(1, desc.length() - 1)).split(",");
        if (elts.length != 3) {
            throw new IllegalArgumentException(msg);
        }
        String type = elts[0];
        String ctrlDesc = elts[1];
        String contentDesc = elts[2];
        elts = type.split("/");
        if (elts.length != 5) {
            throw new IllegalArgumentException(msg);
        }
        String name = elts[0];
        String signature = elts[1];
        boolean isClient = Boolean.parseBoolean(elts[2]);
        boolean isOptional = Boolean.parseBoolean(elts[3]);
        boolean isCollection = Boolean.parseBoolean(elts[4]);
        BasicInterfaceType it = new BasicInterfaceType(name, signature, isClient, isOptional, isCollection);
        BasicComponentType ct = new BasicComponentType(new InterfaceType[]{it});
        this.generate(ct, (Object)ctrlDesc, (Object)contentDesc);
    }

    public void generateSourceCode(ClassGeneratorItf scg) throws IOException {
        String targetClassName = scg.getTargetClassName();
        ClassLoader classLoader = this.getJuliacConfig().getClassLoader();
        try {
            classLoader.loadClass(targetClassName);
            return;
        }
        catch (ClassNotFoundException cnfe) {
            this.generateSourceCodeOverride(scg);
            return;
        }
    }

    public void generateSourceCodeOverride(ClassGeneratorItf scg) throws IOException {
        SourceFile sf;
        JuliacConfig jconf = this.getJuliacConfig();
        File genDir = jconf.getGenDir();
        String targetClassName = scg.getTargetClassName();
        CompilationRounds rounds = this.getJuliacConfig().getCompilationRounds();
        if (rounds.contains(sf = SourceFile.create(genDir, targetClassName))) {
            return;
        }
        String filename = targetClassName.replace('.', File.separatorChar) + ".java";
        File f = new File(genDir, filename);
        File fdir = f.getParentFile();
        fdir.mkdirs();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        FileSourceCodeWriter cw = new FileSourceCodeWriter(pw);
        scg.generate(cw);
        pw.close();
        sw.close();
        FileWriter fw = new FileWriter(f);
        StringBuffer sb = sw.getBuffer();
        fw.write(sb.toString());
        fw.close();
        CompilationRound round = rounds.getCurrentCompilationRound();
        round.addGenerated(SourceFile.create(genDir, targetClassName));
    }

    public boolean hasBeenGenerated(String name) throws IOException {
        SourceFile igf;
        JuliacConfig jconf = this.getJuliacConfig();
        File genDir = jconf.getGenDir();
        CompilationRounds rounds = jconf.getCompilationRounds();
        if (rounds.contains(igf = SourceFile.create(genDir, name))) {
            return true;
        }
        ClassLoader classLoader = jconf.getClassLoader();
        try {
            classLoader.loadClass(name);
            return true;
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
    }

    public String getRootedClassName(String contentClassName) {
        JuliacConfig jconf = this.getJuliacConfig();
        String pkgRoot = jconf.getPkgRoot();
        if (pkgRoot != null && pkgRoot.length() != 0) {
            StringBuffer rootedClassName = new StringBuffer();
            rootedClassName.append(pkgRoot);
            rootedClassName.append('.');
            rootedClassName.append(contentClassName);
            return rootedClassName.toString();
        }
        return contentClassName;
    }

    public FCSourceCodeGeneratorItf<?> getFCSourceCodeGeneratorByClassName(String name) throws IllegalArgumentException {
        JuliacConfig jconf = this.getJuliacConfig();
        List<FCSourceCodeGeneratorItf<?>> fcscgs = jconf.getOptLevelSourceCodeGenerators(null);
        for (FCSourceCodeGeneratorItf<?> fcscg : fcscgs) {
            String clName = fcscg.getClass().getName();
            if (!clName.equals(name)) continue;
            return fcscg;
        }
        String msg = "No source code generator: " + name;
        throw new IllegalArgumentException(msg);
    }

    public FCSourceCodeGeneratorItf<?> getFCSourceCodeGenerator(Object controllerDesc) throws IllegalArgumentException {
        JuliacConfig jconf = this.getJuliacConfig();
        String ctrlDesc = (String)controllerDesc;
        List<FCSourceCodeGeneratorItf<?>> fcscgs = jconf.getOptLevelSourceCodeGenerators(ctrlDesc);
        ctrlDesc = Utils.stripControllerDescPrefix(ctrlDesc);
        for (FCSourceCodeGeneratorItf<?> fcscg : fcscgs) {
            boolean accept = fcscg.acceptCtrlDesc(ctrlDesc);
            if (!accept) continue;
            return fcscg;
        }
        String msg = "No source code generator for controller descriptor: " + controllerDesc;
        throw new IllegalArgumentException(msg);
    }

    public CompilationRound compile() throws IOException {
        JuliacConfig jconf = this.getJuliacConfig();
        Logger logger = jconf.getLogger();
        logger.info("Compiling...");
        CompilationRounds rounds = jconf.getCompilationRounds();
        CompilationRound round = rounds.getCurrentCompilationRound();
        List<SourceFile> inputFiles = round.getInputFiles();
        List<SourceFile> generatedFiles = round.getGeneratedFiles();
        if (inputFiles.size() == 0 && generatedFiles.size() == 0) {
            logger.info("No file to compile");
            return round;
        }
        Logger compilationLogger = jconf.getCompilationLogger();
        boolean compilationWarnings = jconf.getCompilationWarnings();
        if (compilationWarnings) {
            JuliacConfig.setLevel(compilationLogger, Level.WARNING);
        }
        CompileSupportItf compiler = this.getCompiler();
        round.compile(compiler);
        JuliacConfig.setLevel(compilationLogger, Level.SEVERE);
        for (SourceFile isf : inputFiles) {
            logger.fine("   " + isf.getQname());
        }
        for (SourceFile igf : generatedFiles) {
            logger.fine("   " + igf.getQname());
        }
        int total = inputFiles.size() + generatedFiles.size();
        String msg = total + " file(s) compiled to " + round.getClassDir().getAbsolutePath();
        logger.info(msg);
        return round;
    }

    public CompilationRound compileQuiet() throws IOException {
        CompilationRounds rounds = this.jconf.getCompilationRounds();
        CompilationRound round = rounds.getCurrentCompilationRound();
        CompileSupportItf compiler = this.getCompiler();
        round.compile(compiler);
        return round;
    }

    public void packGeneratedFiles() throws IOException {
        JuliacConfig jconf = this.getJuliacConfig();
        Logger logger = jconf.getLogger();
        CompilationRounds rounds = jconf.getCompilationRounds();
        List<CompilationRound> rds = rounds.getCompilationRounds();
        boolean generated = false;
        for (CompilationRound round : rds) {
            List<String> outputFileNames = round.getOutputFileNames();
            if (outputFileNames.size() == 0) continue;
            generated = true;
            break;
        }
        if (!generated) {
            String msg = "No compiled generated file. Can not create the jar file.";
            logger.warning(msg);
            return;
        }
        File jarFile = jconf.getClassJarFile();
        FileOutputStream os = new FileOutputStream(jarFile);
        JarOutputStream jos = new JarOutputStream(os);
        int total = 0;
        for (CompilationRound round : rds) {
            File classDir = round.getClassDir();
            List<String> outputFileNames = round.getOutputFileNames();
            for (String outputFileName : outputFileNames) {
                File f = new File(classDir, outputFileName);
                FileInputStream fis = new FileInputStream(f);
                long size = fis.available();
                JarEntry je = new JarEntry(outputFileName);
                je.setSize(size);
                jos.putNextEntry(je);
                byte[] b = new byte[(int)size];
                fis.read(b);
                jos.write(b);
                jos.closeEntry();
                ++total;
            }
        }
        jos.close();
        ((OutputStream)os).close();
        String msg = total + " file(s) packaged to " + jarFile.getAbsolutePath();
        logger.info(msg);
    }

    public CompileSupportItf getCompiler() throws IOException {
        if (this.compiler == null) {
            JuliacConfig jconf = this.getJuliacConfig();
            Compiler compiler = jconf.getCompiler();
            String compilerClassName = compiler.getClassName();
            String cnfeMessage = "Compile support class can not be found: " + (Object)((Object)compiler);
            this.compiler = (CompileSupportItf)this.loadAndInstantiate(compilerClassName, cnfeMessage);
            this.compiler.init(this);
        }
        return this.compiler;
    }

    public SpoonSupportItf getSpoon() throws JuliacRuntimeException {
        if (this.spoon == null) {
            String cnfeMessage = "Spoon support class implementation can not be found: org.objectweb.fractal.juliac.spoon.SpoonSupportImpl. Check that the org.objectweb.fractal.juliac:juliac-spoon artifact is included in the project dependencies.";
            this.spoon = (SpoonSupportItf)this.loadAndInstantiate("org.objectweb.fractal.juliac.spoon.SpoonSupportImpl", "Spoon support class implementation can not be found: org.objectweb.fractal.juliac.spoon.SpoonSupportImpl. Check that the org.objectweb.fractal.juliac:juliac-spoon artifact is included in the project dependencies.");
            try {
                this.spoon.init(this);
            }
            catch (IOException e) {
                throw new JuliacRuntimeException(e);
            }
        }
        return this.spoon;
    }

    private <T> T loadAndInstantiate(String clname, String cnfeMessage) throws JuliacRuntimeException {
        JuliacConfig jconf = this.getJuliacConfig();
        Class cl = null;
        try {
            cl = jconf.load(clname);
        }
        catch (ClassNotFoundException cnfe) {
            throw new JuliacRuntimeException(cnfeMessage, cnfe);
        }
        Object service = jconf.instantiate(cl);
        return service;
    }

    public void register(UnifiedClassFactoryItf ucf) {
        this.ucfs.add(ucf);
    }

    public UnifiedClass create(String name) throws JuliacRuntimeException {
        for (UnifiedClassFactoryItf ucf : this.ucfs) {
            try {
                UnifiedClass uc = ucf.create(name);
                return uc;
            }
            catch (ClassNotFoundException cnfe) {
            }
        }
        throw new JuliacRuntimeException(new ClassNotFoundException(name));
    }

    public String getInterfaceTypeSignature(InterfaceType it) {
        String signature = it.getFcItfSignature();
        UnifiedClass proxycl = this.create(it.getFcItfSignature());
        String[] tpnames = proxycl.getTypeParameterNames();
        if (tpnames.length == 0) {
            return signature;
        }
        StringBuffer sb = new StringBuffer(signature);
        String s = Utils.getTypeParameterNamesSignature(tpnames);
        sb.append(s);
        return sb.toString();
    }
}

