/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParametersString
implements Iterable<String> {
    private List<String> keys = new ArrayList<String>();
    private Map<String, String> values = new HashMap<String, String>();

    public void parse(String str, String delim, String separator) {
        StringTokenizer st = new StringTokenizer(str, delim);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int last = token.lastIndexOf(separator);
            if (last == -1) {
                this.keys.add(token);
                this.values.put(token, null);
                continue;
            }
            String key = token.substring(0, last);
            String value = last + 1 == token.length() ? "" : token.substring(last + 1);
            this.keys.add(key);
            this.values.put(key, value);
        }
    }

    public boolean containsKey(String key) {
        return this.values.containsKey(key);
    }

    public String get(String key) {
        return this.values.get(key);
    }

    public String getKeyAt(int i) {
        return this.keys.get(i);
    }

    public int size() {
        return this.keys.size();
    }

    @Override
    public Iterator<String> iterator() {
        return this.keys.iterator();
    }

    public void put(String key, String value) {
        this.keys.add(key);
        this.values.put(key, value);
    }
}

