/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac;

import java.io.File;
import java.util.TreeSet;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.type.ComponentType;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.julia.loader.Tree;
import org.objectweb.fractal.julia.type.BasicComponentType;
import org.objectweb.fractal.julia.type.BasicInterfaceType;
import org.objectweb.fractal.juliac.JuliacRuntimeException;

public class Utils {
    public static StringBuffer javaifyContentDesc(Object contentDesc) {
        StringBuffer sb = new StringBuffer();
        if (contentDesc == null) {
            sb.append("null");
        } else if (contentDesc instanceof Object[]) {
            Object[] array;
            sb.append("new Object[]{");
            for (Object o : array = (Object[])contentDesc) {
                sb.append(Utils.javaifyContentDesc(o));
                sb.append(',');
            }
            sb.append("}");
        } else {
            sb.append('\"');
            sb.append(contentDesc);
            sb.append('\"');
        }
        return sb;
    }

    public static StringBuffer javaify(ComponentType ct) {
        InterfaceType[] its = ct.getFcInterfaceTypes();
        return Utils.javaify(its);
    }

    public static StringBuffer javaify(InterfaceType[] its) {
        StringBuffer sb = new StringBuffer();
        sb.append("new " + BasicComponentType.class.getName() + "( ");
        sb.append("new " + InterfaceType.class.getName() + "[]{");
        for (int i = 0; i < its.length; ++i) {
            sb.append(Utils.javaify(its[i]));
            sb.append(",");
        }
        sb.append("} )");
        return sb;
    }

    public static StringBuffer javaify(InterfaceType it) {
        StringBuffer sb = new StringBuffer();
        String itfname = it.getFcItfName();
        sb.append("new " + BasicInterfaceType.class.getName() + "(");
        sb.append("\"" + itfname + "\",");
        sb.append("\"" + it.getFcItfSignature() + "\",");
        sb.append((it.isFcClientItf() ? "true" : "false") + ",");
        sb.append((it.isFcOptionalItf() ? "true" : "false") + ",");
        sb.append(it.isFcCollectionItf() ? "true" : "false");
        sb.append(")");
        return sb;
    }

    public static StringBuffer javaify(Tree tree) {
        StringBuffer sb = new StringBuffer();
        sb.append("new " + Tree.class.getName() + '(');
        if (tree.getSize() == 0) {
            sb.append('\"' + tree.toString() + '\"');
        } else {
            sb.append("new " + Tree.class.getName() + "[]{");
            Tree[] subtrees = tree.getSubTrees();
            boolean first = true;
            for (Tree subtree : subtrees) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                StringBuffer s = Utils.javaify(subtree);
                sb.append(s);
            }
            sb.append('}');
        }
        sb.append(')');
        return sb;
    }

    public static InterfaceType newSymetricInterfaceType(InterfaceType it) {
        return new BasicInterfaceType(it.getFcItfName(), it.getFcItfSignature(), !it.isFcClientItf(), it.isFcOptionalItf(), it.isFcCollectionItf());
    }

    public static InterfaceType downToLevel0InterfaceType(InterfaceType srcit) {
        BasicInterfaceType it = new BasicInterfaceType(srcit.getFcItfName().substring(2), srcit.getFcItfSignature(), srcit.isFcClientItf(), srcit.isFcOptionalItf(), srcit.isFcCollectionItf());
        return it;
    }

    public static boolean isComposite(InterfaceType[] its) {
        for (InterfaceType it : its) {
            String itname = it.getFcItfName();
            if (!itname.equals("content-controller") && !itname.equals("basic-content-controller")) continue;
            return true;
        }
        return false;
    }

    public static String hexhash(ComponentType ct) {
        InterfaceType[] its = ct.getFcInterfaceTypes();
        TreeSet<String> names = new TreeSet<String>();
        for (InterfaceType it : its) {
            String name = it.getFcItfName();
            names.add(name);
        }
        StringBuffer sct = new StringBuffer("[");
        boolean first = true;
        for (String name : names) {
            InterfaceType it = null;
            try {
                it = ct.getFcInterfaceType(name);
            }
            catch (NoSuchInterfaceException nsie) {
                throw new JuliacRuntimeException(nsie);
            }
            if (first) {
                first = false;
            } else {
                sct.append(',');
            }
            sct.append(it.toString());
        }
        sct.append(']');
        int hashct = sct.toString().hashCode();
        String hexhashct = Integer.toHexString(hashct);
        return hexhashct;
    }

    public static String getJuliacGeneratedStrongTypeName(String fqn) {
        int lastdot = fqn.lastIndexOf(46);
        if (lastdot == -1) {
            String s = "juliac.generated." + fqn;
            return s;
        }
        if (fqn.startsWith("java.") || fqn.startsWith("javax.")) {
            String s = "juliac.generated." + fqn;
            return s;
        }
        return fqn;
    }

    public static String getContentClassName(String ctrlDesc, Object contentDesc) throws IllegalArgumentException {
        if (ctrlDesc.endsWith("Template")) {
            if (!(contentDesc instanceof Object[])) {
                String msg = "contentDesc should be an array when " + ctrlDesc + " is used";
                throw new IllegalArgumentException(msg);
            }
            Object[] cont = (Object[])contentDesc;
            if (!(cont[0] instanceof String)) {
                String msg = "Inner controllerDesc should be a String";
                throw new IllegalArgumentException(msg);
            }
            if (cont[1] != null && !(cont[1] instanceof String)) {
                String msg = "Inner contentDesc should be a String";
                throw new IllegalArgumentException(msg);
            }
            return (String)cont[1];
        }
        if (contentDesc != null && !(contentDesc instanceof String)) {
            String msg = "contentDesc should be a String";
            throw new IllegalArgumentException(msg);
        }
        return (String)contentDesc;
    }

    public static String getControllerDescPrefix(String ctrlDesc) {
        if (ctrlDesc.charAt(0) != '/') {
            return null;
        }
        int lastslash = ctrlDesc.lastIndexOf(47);
        if (lastslash != -1 && lastslash + 1 < ctrlDesc.length()) {
            String prefix = ctrlDesc.substring(0, lastslash + 1);
            return prefix;
        }
        return null;
    }

    public static String stripControllerDescPrefix(String ctrlDesc) {
        String prefix = Utils.getControllerDescPrefix(ctrlDesc);
        if (prefix == null) {
            return ctrlDesc;
        }
        String cdesc = ctrlDesc.substring(prefix.length());
        return cdesc;
    }

    public static File getFile(File baseDir, String fileName) {
        File f = new File(fileName);
        if (!f.isAbsolute()) {
            f = new File(baseDir, fileName);
        }
        return f;
    }

    public static String trimHeadingAndTrailingBlanks(String src) {
        char c;
        if (src == null) {
            return null;
        }
        int i = -1;
        int len = src.length();
        do {
            if (++i != len) continue;
            return "";
        } while ((c = src.charAt(i)) == ' ' || c == '\t' || c == '\n');
        int j = src.length();
        while ((c = src.charAt(--j)) == ' ' || c == '\t' || c == '\n') {
        }
        String trim = src.substring(i, j + 1);
        return trim;
    }

    public static String getTypeParameterNamesSignature(String[] tpnames) {
        if (tpnames.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append('<');
        boolean first = true;
        for (String tpname : tpnames) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(tpname);
        }
        sb.append('>');
        return sb.toString();
    }

    public static boolean isRegularClassPathEntry(File f) {
        boolean exits = f.exists();
        boolean isLib = f.getAbsolutePath().endsWith("lib");
        return exits && !isLib;
    }
}

