/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.conf;

import java.util.Arrays;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JDKLevel {
    JDK1_1("1.1"),
    JDK1_2("1.2"),
    JDK1_3("1.3"),
    JDK1_4("1.4"),
    JDK1_5("1.5"),
    JDK1_6("1.6"),
    JDK1_7("1.7");

    private String version;

    private JDKLevel(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public static JDKLevel getDefaultLevel(Logger logger) {
        try {
            String v = System.getProperty("java.specification.version");
            JDKLevel level = JDKLevel.valueOfIAE(v);
            return level;
        }
        catch (IllegalArgumentException iae) {
            if (logger != null) {
                String msg = iae.getMessage() + ". This value is returned by the " + "java.specification.version system property. " + "1.5 will be assumed instead.";
                logger.warning(msg);
            }
            return JDK1_5;
        }
    }

    public static JDKLevel getDefaultSourceLevel(Logger logger) {
        JDKLevel level = JDKLevel.getDefaultLevel(logger);
        return level;
    }

    public static JDKLevel getDefaultTargetLevel(Logger logger) {
        JDKLevel level = JDKLevel.getDefaultLevel(logger);
        return level;
    }

    public static JDKLevel valueOfIAE(String v) throws IllegalArgumentException {
        for (JDKLevel level : JDKLevel.values()) {
            if (!level.version.equals(v)) continue;
            return level;
        }
        Object[] versions = JDKLevel.getVersions();
        String s = Arrays.toString(versions);
        String msg = "Java compatibility version number " + v + " is not among the supported ones: " + s;
        throw new IllegalArgumentException(msg);
    }

    public static String[] getVersions() {
        JDKLevel[] levels = JDKLevel.values();
        String[] versions = new String[levels.length];
        for (int i = 0; i < levels.length; ++i) {
            versions[i] = levels[i].getVersion();
        }
        return versions;
    }
}

