/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.conf;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.fractal.julia.loader.Tree;
import org.objectweb.fractal.juliac.desc.NoSuchControllerDescriptorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JuliaLoader
extends HashMap<String, Tree> {
    private static final long serialVersionUID = -4943830365587148693L;
    private InputStream is;
    private int line;
    private int car;
    private List<String> filenames = new ArrayList<String>();
    private ClassLoader classloader;

    public JuliaLoader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfigFile(String filename) throws IOException {
        if (this.filenames.contains(filename)) {
            return;
        }
        InputStream is = this.classloader.getResourceAsStream(filename);
        if (is == null) {
            String msg = "Can not load " + filename + ". Classloader: ";
            if (this.classloader instanceof URLClassLoader) {
                URL[] urls;
                URLClassLoader uc = (URLClassLoader)this.classloader;
                for (URL url : urls = uc.getURLs()) {
                    msg = msg + url.toString() + ',';
                }
            } else {
                msg = msg + this.classloader.getClass() + ": " + this.classloader;
            }
            throw new IOException(msg);
        }
        try {
            this.line = 1;
            while (true) {
                Tree def;
                try {
                    def = this.parseTree(is);
                }
                catch (IOException e) {
                    String msg = "File '" + filename + "', line " + this.line + ": " + e.getMessage();
                    throw new IOException(msg);
                }
                if (def == null) {
                    break;
                }
                String name = def.getSubTree(0).toString();
                Tree t = def.getSubTree(1);
                this.put(name, t);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        this.filenames.add(filename);
    }

    public Tree loadTree(String name) throws NoSuchControllerDescriptorException {
        if (!this.containsKey(name)) {
            String str = Arrays.deepToString(this.filenames.toArray());
            String msg = "Cannot find the '" + name + "' descriptor in the '" + str + "' configuration file(s)";
            throw new NoSuchControllerDescriptorException(msg);
        }
        Tree t = (Tree)this.get(name);
        return t;
    }

    public Tree evalTree(Tree tree, Map<?, ?> context) throws IllegalArgumentException {
        if (tree.getSize() == 0) {
            String var = tree.toString();
            if (var.startsWith("'")) {
                Tree val = (Tree)context.get(var = var.substring(1));
                if (val == null) {
                    val = this.loadTree(var);
                }
                if (val == null) {
                    throw new IllegalArgumentException(var);
                }
                if (!val.toString().equals("QUOTE")) {
                    return this.evalTree(val, context);
                }
            }
            return tree;
        }
        boolean ok = true;
        Tree[] subTrees = tree.getSubTrees();
        for (int i = 0; i < subTrees.length; ++i) {
            Tree oldSubTree = subTrees[i];
            Tree newSubTree = this.evalTree(oldSubTree, context);
            if (newSubTree == oldSubTree) continue;
            if (ok) {
                Tree[] newSubTrees = new Tree[subTrees.length];
                System.arraycopy(subTrees, 0, newSubTrees, 0, subTrees.length);
                subTrees = newSubTrees;
                ok = false;
            }
            subTrees[i] = newSubTree;
        }
        return ok ? tree : new Tree(subTrees);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tree parseTree(InputStream is) throws IOException {
        try {
            this.is = is;
            this.read();
            this.parseSpaces();
            if (this.car == -1) {
                Tree tree = null;
                return tree;
            }
            Tree tree = this.parseTree();
            return tree;
        }
        finally {
            this.is = null;
        }
    }

    private Tree parseTree() throws IOException {
        int c = this.car;
        if (c == -1) {
            throw new IOException("Unexpected end of file");
        }
        if (c == 41) {
            throw new IOException("Unmatched closing parenthesis");
        }
        if (c == 40) {
            this.read();
            ArrayList<Tree> subTrees = new ArrayList<Tree>();
            while (true) {
                if ((c = this.parseSpaces()) == 41) {
                    this.read();
                    return new Tree(subTrees.toArray(new Tree[subTrees.size()]));
                }
                subTrees.add(this.parseTree());
            }
        }
        StringBuffer buf = new StringBuffer();
        do {
            buf.append((char)c);
        } while ((c = this.read()) != -1 && c != 32 && c != 9 && c != 10 && c != 13 && c != 35 && c != 40 && c != 41);
        this.car = c;
        return new Tree(buf.toString());
    }

    private int parseSpaces() throws IOException {
        int c = this.car;
        while (c == 32 || c == 9 || c == 10 || c == 13 || c == 35) {
            if (c == 35) {
                while ((c = this.read()) != 10 && c != 13) {
                }
            }
            c = this.read();
        }
        this.car = c;
        return this.car;
    }

    private int read() throws IOException {
        this.car = this.is.read();
        if (this.car == 10 || this.car == 13) {
            ++this.line;
        }
        return this.car;
    }
}

