/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.conf;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.objectweb.fractal.juliac.CompilationRound;
import org.objectweb.fractal.juliac.CompilationRounds;
import org.objectweb.fractal.juliac.Juliac;
import org.objectweb.fractal.juliac.JuliacRuntimeException;
import org.objectweb.fractal.juliac.SourceFile;
import org.objectweb.fractal.juliac.Utils;
import org.objectweb.fractal.juliac.api.ADLParserSupportItf;
import org.objectweb.fractal.juliac.api.FCSourceCodeGeneratorItf;
import org.objectweb.fractal.juliac.conf.ADLParser;
import org.objectweb.fractal.juliac.conf.Compiler;
import org.objectweb.fractal.juliac.conf.JDKLevel;
import org.objectweb.fractal.juliac.conf.JuliacGeneratorMap;
import org.objectweb.fractal.juliac.conf.JuliacInterceptorSourceCodeGeneratorMap;
import org.objectweb.fractal.juliac.conf.JuliacLoggerFormatter;
import org.objectweb.fractal.juliac.conf.JulietLoader;
import org.objectweb.fractal.juliac.conf.OptLevel;
import org.objectweb.fractal.juliac.proxy.InterceptorClassGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JuliacConfig {
    private Juliac jc;
    private File baseDir = new File(".");
    private List<String> srcs = new ArrayList<String>();
    private List<String> srclibs = new ArrayList<String>();
    private String pkgRoot = "";
    private String genDirName = "target/generated-sources/juliac";
    private File genDir;
    private String classDirName = "target/classes";
    private File classDir;
    private String classJarFileName = "target/juliac.jar";
    private File classJarFile;
    private JDKLevel sourceLevel = JDKLevel.getDefaultSourceLevel(this.getLogger());
    private JDKLevel targetLevel = JDKLevel.getDefaultTargetLevel(this.getLogger());
    private Compiler compiler = Compiler.getDefaultCompiler();
    private List<ADLParser> adlParsers = new ArrayList<ADLParser>();
    private List<String> optLevelPrefixes = new ArrayList<String>();
    private List<String> optLevelNames = new ArrayList<String>();
    private Map<String, FCSourceCodeGeneratorItf<?>> optLevels = new HashMap();
    private JuliacGeneratorMap<InterceptorClassGenerator> iclgs = new JuliacGeneratorMap(this);
    private JuliacInterceptorSourceCodeGeneratorMap iscgs = new JuliacInterceptorSourceCodeGeneratorMap(this);
    private ClassLoader classLoader;
    private JulietLoader julietLoader;
    private CompilationRounds rounds;
    private Logger logger = null;
    private static final String LOGGER_NAME = "org.objectweb.fractal.juliac";
    private Logger compilationLogger = null;
    private static final String COMPILATION_LOGGER_NAME = "org.objectweb.fractal.juliac.plugin.compiler";
    private boolean compilationWarnings = false;

    public JuliacConfig(Juliac jc) {
        this.jc = jc;
    }

    public void close() throws IOException {
        Collection<FCSourceCodeGeneratorItf<?>> fcscgs = this.optLevels.values();
        for (FCSourceCodeGeneratorItf<?> fcscg : fcscgs) {
            fcscg.close(this.jc);
        }
    }

    public void setPkgRoot(String pkgRoot) {
        this.pkgRoot = pkgRoot;
    }

    public String getPkgRoot() {
        return this.pkgRoot;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public String[] getSrcs() {
        return this.srcs.toArray(new String[this.srcs.size()]);
    }

    public void addSrc(String src) throws IOException {
        File baseDir = this.getBaseDir();
        ArrayList<SourceFile> sfs = new ArrayList<SourceFile>();
        SourceFile.addAllJavaFiles(baseDir, src, sfs);
        CompilationRounds rounds = this.getCompilationRounds();
        CompilationRound round = rounds.getCurrentCompilationRound();
        round.addInput(sfs);
        this.srcs.add(src);
    }

    public void addSrcs(String[] srcs) throws IOException {
        for (String src : srcs) {
            this.addSrc(src);
        }
    }

    public String[] getSrclibs() {
        return this.srclibs.toArray(new String[this.srclibs.size()]);
    }

    public void addSrclib(String srclib) {
        this.srclibs.add(srclib);
    }

    public void addSrclibs(String[] srclibs) {
        for (String srclib : srclibs) {
            this.addSrclib(srclib);
        }
    }

    public File getGenDir() throws IOException {
        if (this.genDir == null) {
            File baseDir = this.getBaseDir();
            String genDirName = this.getGenDirName();
            this.genDir = JuliacConfig.initDir(baseDir, genDirName);
        }
        return this.genDir;
    }

    public String getGenDirName() {
        return this.genDirName;
    }

    public void setGenDirName(String genDirName) throws IOException {
        File baseDir = this.getBaseDir();
        this.genDir = JuliacConfig.initDir(baseDir, genDirName);
    }

    public File getClassDir() throws IOException {
        if (this.classDir == null) {
            File baseDir = this.getBaseDir();
            String classDirName = this.getClassDirName();
            this.classDir = JuliacConfig.initDir(baseDir, classDirName);
        }
        return this.classDir;
    }

    public String getClassDirName() {
        return this.classDirName;
    }

    public void setClassDirName(String classDirName) throws IOException {
        File baseDir = this.getBaseDir();
        this.classDir = JuliacConfig.initDir(baseDir, classDirName);
    }

    public File getClassJarFile() {
        if (this.classJarFile == null) {
            String classJarFileName = this.getClassJarFileName();
            this.classJarFile = new File(this.baseDir, classJarFileName);
        }
        return this.classJarFile;
    }

    public String getClassJarFileName() {
        return this.classJarFileName;
    }

    public void setClassJarFileName(String classJarFileName) {
        File baseDir = this.getBaseDir();
        this.classJarFile = new File(baseDir, classJarFileName);
    }

    public JDKLevel getSourceLevel() {
        return this.sourceLevel;
    }

    public void setSourceLevel(JDKLevel sourceLevel) {
        this.sourceLevel = sourceLevel;
    }

    public JDKLevel getTargetLevel() {
        return this.targetLevel;
    }

    public void setTargetLevel(JDKLevel targetLevel) {
        this.targetLevel = targetLevel;
    }

    public Compiler getCompiler() {
        return this.compiler;
    }

    public void setCompiler(String compiler) {
        try {
            this.compiler = Compiler.valueOf(compiler);
        }
        catch (IllegalArgumentException iae) {
            this.compiler = Compiler.CUSTOM;
            this.compiler.setClassName(compiler);
        }
    }

    public void setCompiler(Compiler compiler) {
        this.compiler = compiler;
    }

    public void addADLParserNames(String[] adlParserNames) {
        for (String adlParserName : adlParserNames) {
            this.addADLParserName(adlParserName);
        }
    }

    public void addADLParserName(String adlParserName) {
        ADLParser adlParser = null;
        try {
            adlParser = ADLParser.valueOf(adlParserName);
        }
        catch (IllegalArgumentException iae) {
            adlParser = ADLParser.CUSTOM;
            adlParser.setClassName(adlParserName);
        }
        this.adlParsers.add(adlParser);
    }

    public void addADLParser(ADLParser adlParser) {
        this.adlParsers.add(adlParser);
    }

    public void loadADLParsers() throws ClassNotFoundException, IOException {
        for (ADLParser adlParser : this.adlParsers) {
            String clname = adlParser.getClassName();
            Class cl = null;
            try {
                cl = this.load(clname);
                ADLParserSupportItf parserItf = (ADLParserSupportItf)this.instantiate(cl);
                parserItf.init(this.jc);
                adlParser.setSupportItf(parserItf);
            }
            catch (ClassNotFoundException cnfe) {
                ADLParser defaultParser = ADLParser.getDefaultADLParser();
                if (adlParser.equals((Object)defaultParser)) continue;
                throw cnfe;
            }
        }
    }

    public List<ADLParser> getADLParsers() {
        return this.adlParsers;
    }

    public void setOptLevel(String optLevel) throws IllegalArgumentException {
        this.optLevelPrefixes = new ArrayList<String>();
        this.optLevelNames = new ArrayList<String>();
        String[] levels = optLevel.split(":");
        for (int i = 0; i < levels.length; ++i) {
            String name;
            String[] elts = levels[i].split("=");
            if (elts.length > 2) {
                String msg = "Too many = in " + levels[i];
                throw new IllegalArgumentException(msg);
            }
            String prefix = elts.length == 1 ? null : elts[0];
            String string = name = elts.length == 1 ? elts[0] : elts[1];
            if (i == 0 && prefix != null) {
                this.addOptLevel(null, name);
            }
            this.addOptLevel(prefix, name);
        }
    }

    public void loadOptLevels() throws ClassNotFoundException, IOException {
        ArrayList<String> copy = new ArrayList<String>();
        copy.addAll(this.optLevelNames);
        for (String optLevelName : copy) {
            Class cl = this.load(optLevelName);
            FCSourceCodeGeneratorItf fcscg = (FCSourceCodeGeneratorItf)this.instantiate(cl);
            fcscg.init(this.jc);
            fcscg.postInit();
            this.optLevels.put(optLevelName, fcscg);
        }
    }

    public void addOptLevel(String prefix, String optLevelName) {
        String clname = null;
        try {
            OptLevel level = OptLevel.valueOf(optLevelName);
            clname = level.getClassName();
        }
        catch (IllegalArgumentException iae) {
            clname = optLevelName;
        }
        this.optLevelPrefixes.add(prefix);
        this.optLevelNames.add(clname);
    }

    public void addOptLevel(String prefix, FCSourceCodeGeneratorItf<?> fcscg) {
        String clname = fcscg.getClass().getName();
        this.optLevelPrefixes.add(prefix);
        this.optLevelNames.add(clname);
        this.optLevels.put(clname, fcscg);
    }

    public List<FCSourceCodeGeneratorItf<?>> getOptLevelSourceCodeGenerators(String ctrlDesc) throws IllegalArgumentException {
        if (this.optLevelNames.size() == 0) {
            String msg = "No default optimization level source code generator";
            throw new IllegalArgumentException(msg);
        }
        String prefix = ctrlDesc == null ? null : Utils.getControllerDescPrefix(ctrlDesc);
        ArrayList scgs = new ArrayList();
        for (int i = 0; i < this.optLevelPrefixes.size(); ++i) {
            String p = this.optLevelPrefixes.get(i);
            String name = this.optLevelNames.get(i);
            FCSourceCodeGeneratorItf<?> scg = this.optLevels.get(name);
            if (scg == null) {
                String msg = "Source code generator for " + ctrlDesc + "is null. Check that loadOptLevels() has been invoked.";
                throw new IllegalArgumentException(msg);
            }
            if (ctrlDesc == null) {
                scgs.add(scg);
                continue;
            }
            if (prefix == null) {
                if (p != null) continue;
                scgs.add(scg);
                continue;
            }
            if (!prefix.equals(p)) continue;
            scgs.add(scg);
        }
        if (scgs.size() == 0) {
            String msg = "No source code generator for " + ctrlDesc;
            throw new IllegalArgumentException(msg);
        }
        return scgs;
    }

    public List<String> getArtifactIdsForKnownOptLevels() {
        Map<String, String> map = OptLevel.toMap();
        ArrayList<String> ols = new ArrayList<String>();
        for (String name : this.optLevelNames) {
            if (!map.containsKey(name)) continue;
            String artifactId = map.get(name);
            ols.add(artifactId);
        }
        return ols;
    }

    public JuliacGeneratorMap<InterceptorClassGenerator> getInterceptorClassGenerators() {
        return this.iclgs;
    }

    public JuliacInterceptorSourceCodeGeneratorMap getInterceptorSourceCodeGenerators() {
        return this.iscgs;
    }

    public JulietLoader getJulietLoader() {
        if (this.julietLoader == null) {
            this.julietLoader = new JulietLoader();
        }
        return this.julietLoader;
    }

    public CompilationRounds getCompilationRounds() {
        if (this.rounds == null) {
            this.rounds = new CompilationRounds(this);
        }
        return this.rounds;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = this.getClass().getClassLoader();
        }
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public <T> Class<T> load(String name) throws ClassNotFoundException {
        Class<?> c;
        ClassLoader classloader = this.getClassLoader();
        Class<?> cl = c = classloader.loadClass(name);
        return cl;
    }

    public <T> T instantiate(Class<T> cl) throws JuliacRuntimeException {
        try {
            T o = cl.newInstance();
            return o;
        }
        catch (InstantiationException e) {
            throw new JuliacRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new JuliacRuntimeException(e);
        }
    }

    public List<String> getClassPathEntries() {
        ArrayList<String> lst = new ArrayList<String>();
        ClassLoader classLoader = this.getClassLoader();
        while (classLoader != null && classLoader instanceof URLClassLoader) {
            URL[] urls;
            URLClassLoader urlcl = (URLClassLoader)classLoader;
            for (URL url : urls = urlcl.getURLs()) {
                String absfilename = url.getPath();
                File f = new File(absfilename = absfilename.replace("%20", " "));
                boolean isRegular = Utils.isRegularClassPathEntry(f);
                if (!isRegular) continue;
                lst.add(absfilename);
            }
            classLoader = urlcl.getParent();
        }
        return lst;
    }

    public Logger getLogger() {
        if (this.logger == null) {
            Handler[] handlers;
            this.logger = Logger.getLogger(LOGGER_NAME);
            Logger parent = this.logger.getParent();
            for (Handler handler : handlers = parent.getHandlers()) {
                JuliacLoggerFormatter newFormatter = new JuliacLoggerFormatter();
                handler.setFormatter(newFormatter);
            }
        }
        return this.logger;
    }

    public Logger getCompilationLogger() {
        if (this.compilationLogger == null) {
            Handler[] handlers;
            this.compilationLogger = Logger.getLogger(COMPILATION_LOGGER_NAME);
            Logger parent = this.compilationLogger.getParent();
            for (Handler handler : handlers = parent.getHandlers()) {
                JuliacLoggerFormatter newFormatter = new JuliacLoggerFormatter();
                handler.setFormatter(newFormatter);
            }
            JuliacConfig.setLevel(this.compilationLogger, Level.SEVERE);
        }
        return this.compilationLogger;
    }

    public static void setLevel(Logger logger, Level level) {
        Handler[] handlers;
        logger.setLevel(level);
        Logger parent = logger.getParent();
        for (Handler handler : handlers = parent.getHandlers()) {
            handler.setLevel(level);
        }
    }

    public void setCompilationWarnings(boolean compilationWarnings) {
        this.compilationWarnings = compilationWarnings;
    }

    public boolean getCompilationWarnings() {
        return this.compilationWarnings;
    }

    private static File initDir(File baseDir, String dirName) throws IOException {
        File dir = Utils.getFile(baseDir, dirName);
        if (dir.exists() && !dir.isDirectory()) {
            String msg = dir.getAbsolutePath() + " is not a directory";
            throw new IOException(msg);
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }
}

