/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.conf;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.fractal.juliac.conf.JuliacConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JuliacGeneratorMap<V>
extends HashMap<String, V> {
    private static final long serialVersionUID = -3421839892473143881L;
    private Map<String, String> names = new HashMap<String, String>();
    protected JuliacConfig jconf;

    public JuliacGeneratorMap(JuliacConfig jconf) {
        this.jconf = jconf;
    }

    public void set(String def) throws IllegalArgumentException {
        String[] iscgs;
        for (String iscg : iscgs = def.split(":")) {
            String[] elts = iscg.split("=");
            if (elts.length != 2) {
                String msg = iscg + " should contain only one =";
                throw new IllegalArgumentException(msg);
            }
            String asm = elts[0];
            String scg = elts[1];
            this.set(asm, scg);
        }
    }

    public void set(String key, String name) {
        this.names.put(key, name);
    }

    public void load() throws ClassNotFoundException {
        for (Map.Entry<String, String> entry : this.names.entrySet()) {
            String key = entry.getKey();
            String name = entry.getValue();
            this.load(key, name);
        }
    }

    public V load(String key, String name) throws ClassNotFoundException {
        Class cl = this.jconf.load(name);
        Object iscg = this.jconf.instantiate(cl);
        this.put(key, iscg);
        return (V)iscg;
    }
}

