/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.conf;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.objectweb.fractal.api.type.ComponentType;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.fraclet.extensions.Controller;
import org.objectweb.fractal.julia.type.BasicInterfaceType;
import org.objectweb.fractal.juliac.conf.MembraneHelper;
import org.objectweb.fractal.juliac.conf.MembraneLoaderItf;
import org.objectweb.fractal.juliac.desc.ControllerDesc;
import org.objectweb.fractal.juliac.desc.NoSuchControllerDescriptorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JulietLoader
extends HashMap<String, Class<?>>
implements MembraneLoaderItf {
    private static final long serialVersionUID = 3490584715210564495L;

    @Override
    public Class<?> put(String ctrlDesc, Class<?> cl) throws IllegalArgumentException {
        MembraneHelper.check(cl);
        return super.put(ctrlDesc, cl);
    }

    @Override
    public boolean containsKey(String ctrlDesc) {
        return super.containsKey(ctrlDesc);
    }

    @Override
    public InterfaceType[] getMembraneType(ComponentType ct, String ctrlDesc) throws NoSuchControllerDescriptorException {
        if (!this.containsKey(ctrlDesc)) {
            throw new NoSuchControllerDescriptorException(ctrlDesc);
        }
        Class cl = (Class)this.get(ctrlDesc);
        List<Field> fields = MembraneHelper.getControllerAnnotatedFields(cl);
        InterfaceType[] its = new InterfaceType[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            Field field = fields.get(i);
            Controller controller = field.getAnnotation(Controller.class);
            String name = controller.name();
            String signature = field.getType().getName();
            its[i] = new BasicInterfaceType(name, signature, false, false, false);
        }
        return its;
    }

    @Override
    public List<ControllerDesc> getCtrlImplLayers(ComponentType ct, String ctrlDesc) throws NoSuchControllerDescriptorException {
        if (!this.containsKey(ctrlDesc)) {
            throw new NoSuchControllerDescriptorException(ctrlDesc);
        }
        Class cl = (Class)this.get(ctrlDesc);
        List<Field> fields = MembraneHelper.getControllerAnnotatedFields(cl);
        ArrayList<ControllerDesc> cdescs = new ArrayList<ControllerDesc>();
        for (Field field : fields) {
            Controller controller = field.getAnnotation(Controller.class);
            String impl = controller.impl();
            if (impl.equals("")) {
                Class<?> rtype = field.getType();
                impl = rtype.getSimpleName() + ctrlDesc;
            }
            Class<?>[] mixins = controller.mixins();
            ArrayList<String> names = new ArrayList<String>();
            for (Class<?> mixin : mixins) {
                String name = mixin.getName();
                names.add(name);
            }
            ControllerDesc cdesc = new ControllerDesc(impl, names, null);
            cdescs.add(cdesc);
        }
        return cdescs;
    }

    @Override
    public String getInterceptorClassGeneratorName(ComponentType ct, String ctrlDesc) throws NoSuchControllerDescriptorException {
        if (!this.containsKey(ctrlDesc)) {
            throw new NoSuchControllerDescriptorException(ctrlDesc);
        }
        Class cl = (Class)this.get(ctrlDesc);
        Class<?> generator = MembraneHelper.getGenerator(cl);
        return generator.getName();
    }

    @Override
    public String[] getInterceptorSourceCodeGeneratorNames(ComponentType ct, String ctrlDesc) throws NoSuchControllerDescriptorException {
        if (!this.containsKey(ctrlDesc)) {
            throw new NoSuchControllerDescriptorException(ctrlDesc);
        }
        Class cl = (Class)this.get(ctrlDesc);
        Class<?>[] interceptors = MembraneHelper.getInterceptors(cl);
        String[] strs = new String[interceptors.length];
        for (int i = 0; i < interceptors.length; ++i) {
            strs[i] = interceptors[i].getName();
        }
        return strs;
    }
}

