/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.conf;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.objectweb.fractal.fraclet.extensions.Controller;
import org.objectweb.fractal.fraclet.extensions.Membrane;
import org.objectweb.fractal.fraclet.types.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MembraneHelper {
    public static Class<?> getMembraneDef(Membrane jm, String name) {
        Class<?> cl = jm.controllerDesc();
        Membrane mdef = cl.getAnnotation(Membrane.class);
        if (mdef == null) {
            String msg = "The " + cl.getName() + " membrane class specified in the " + "@Membrane(controllerDesc=...) annotation on the " + name + " class should be annotated with @Membrane(desc=\"...\").";
            throw new IllegalArgumentException(msg);
        }
        return cl;
    }

    public static void check(Class<?> cl) throws IllegalArgumentException {
        Membrane mdef = cl.getAnnotation(Membrane.class);
        if (mdef == null) {
            String msg = "No @Membrane annotation on class " + cl.getName();
            throw new IllegalArgumentException(msg);
        }
        boolean isControllerSet = !mdef.controller().equals("");
        boolean isTemplateSet = !mdef.template().equals("");
        boolean isControllerDescSet = !mdef.controllerDesc().equals(Constants.class);
        boolean isTemplateDescSet = !mdef.templateDesc().equals(Constants.class);
        boolean isDescSet = !mdef.desc().equals("");
        boolean isGeneratorSet = !mdef.generator().equals(Constants.class);
        boolean isInterceptorsSet = mdef.interceptors().length != 0;
        boolean first = isControllerSet | isTemplateSet | isControllerDescSet | isTemplateDescSet;
        boolean second = isDescSet | isGeneratorSet | isInterceptorsSet;
        if (first && second) {
            String msg = "{controller,template,controllerDesc,templateDesc} on one side and {desc,generator,interceptors} on the other side cannot be set jointly in " + mdef + " for class " + cl.getName();
            throw new IllegalArgumentException(msg);
        }
        if (!first && !second) {
            String msg = "Either {controller,template,controllerDesc,templateDesc} or {desc,generator,interceptors} should be set in " + mdef + " for class " + cl.getName();
            throw new IllegalArgumentException(msg);
        }
        ArrayList classes = new ArrayList();
        MembraneHelper.addSuperClasses(cl, classes);
        boolean membraneAnnotated = false;
        for (Class clazz : classes) {
            Membrane m = clazz.getAnnotation(Membrane.class);
            if (m == null) continue;
            membraneAnnotated = true;
            break;
        }
        if (!membraneAnnotated) {
            String msg = "No @Membrane annotated class in the inheritance hierarchy of " + cl.getName();
            throw new IllegalArgumentException(msg);
        }
    }

    public static Class<?> getGenerator(Class<?> cl) throws IllegalStateException {
        ArrayList classes = new ArrayList();
        MembraneHelper.addSuperClasses(cl, classes);
        for (Class clazz : classes) {
            Class<?> generator;
            Membrane mdef = clazz.getAnnotation(Membrane.class);
            if (mdef == null || (generator = mdef.generator()).equals(Constants.class)) continue;
            return generator;
        }
        return null;
    }

    public static Class<?>[] getInterceptors(Class<?> cl) throws IllegalStateException {
        ArrayList classes = new ArrayList();
        MembraneHelper.addSuperClasses(cl, classes);
        for (Class clazz : classes) {
            Class<?>[] interceptors;
            Membrane mdef = clazz.getAnnotation(Membrane.class);
            if (mdef == null || (interceptors = mdef.interceptors()).length == 0) continue;
            return interceptors;
        }
        return null;
    }

    public static void addSuperClasses(Class<?> cl, List<Class<?>> classes) {
        if (cl.equals(Object.class)) {
            return;
        }
        classes.add(cl);
        Class<?> sup = cl.getSuperclass();
        MembraneHelper.addSuperClasses(sup, classes);
    }

    public static List<Field> getControllerAnnotatedFields(Class<?> cl) {
        ArrayList classes = new ArrayList();
        MembraneHelper.addSuperClasses(cl, classes);
        ArrayList<Field> fields = new ArrayList<Field>();
        HashSet<String> names = new HashSet<String>();
        for (Class clazz : classes) {
            Field[] fs;
            for (Field f : fs = clazz.getDeclaredFields()) {
                String name;
                if (!f.isAnnotationPresent(Controller.class) || names.contains(name = f.getName())) continue;
                fields.add(f);
                names.add(name);
            }
        }
        return fields;
    }
}

