/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.conf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.type.ComponentType;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.julia.loader.Tree;
import org.objectweb.fractal.julia.type.BasicInterfaceType;
import org.objectweb.fractal.juliac.conf.JuliaLoader;
import org.objectweb.fractal.juliac.conf.MembraneLoaderItf;
import org.objectweb.fractal.juliac.desc.ControllerDesc;
import org.objectweb.fractal.juliac.desc.NoSuchControllerDescriptorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MembraneLoader
implements MembraneLoaderItf {
    private JuliaLoader loader;

    public MembraneLoader(JuliaLoader loader) {
        this.loader = loader;
    }

    @Override
    public boolean containsKey(String ctrlDesc) {
        return this.loader.containsKey(ctrlDesc);
    }

    @Override
    public InterfaceType[] getMembraneType(ComponentType ct, String ctrlDesc) throws NoSuchControllerDescriptorException {
        Tree t = this.loader.loadTree(ctrlDesc);
        Map<String, Tree> context = MembraneLoader.getJuliaContextInfo(ct);
        Tree tree = this.loader.evalTree(t, context);
        Tree membraneItfTree = tree.getSubTree(1);
        Tree[] ctrlItfTrees = membraneItfTree.getSubTrees();
        InterfaceType[] its = new InterfaceType[ctrlItfTrees.length];
        for (int i = 0; i < its.length; ++i) {
            String name = ctrlItfTrees[i].getSubTree(0).toString();
            String signature = ctrlItfTrees[i].getSubTree(1).toString();
            its[i] = new BasicInterfaceType(name, signature, false, false, false);
        }
        return its;
    }

    @Override
    public List<ControllerDesc> getCtrlImplLayers(ComponentType ct, String ctrlDesc) throws NoSuchControllerDescriptorException {
        Map<String, Tree> context = MembraneLoader.getJuliaContextInfo(ct);
        Tree[] ctrlTrees = this.getCtrlImplTrees(ctrlDesc, context);
        ArrayList<ControllerDesc> cdescs = new ArrayList<ControllerDesc>();
        for (Tree ctrlTree : ctrlTrees) {
            ControllerDesc cdesc = null;
            if (ctrlTree.getSize() == 0) {
                String name = ctrlTree.toString();
                cdesc = new ControllerDesc(name, null, null);
            } else {
                Tree t = ctrlTree.getSubTree(0);
                Tree[] ts = t.getSubTrees();
                String name = ts[1].toString();
                ArrayList<String> layers = new ArrayList<String>();
                for (int j = 2; j < ts.length; ++j) {
                    String s = ts[j].toString();
                    layers.add(s);
                }
                cdesc = new ControllerDesc(name, layers, ctrlTree);
            }
            cdescs.add(cdesc);
        }
        return cdescs;
    }

    @Override
    public String getInterceptorClassGeneratorName(ComponentType ct, String ctrlDesc) throws NoSuchControllerDescriptorException {
        Map<String, Tree> context;
        Tree t = this.loader.loadTree(ctrlDesc);
        Tree tree = this.loader.evalTree(t, context = MembraneLoader.getJuliaContextInfo(ct));
        Tree interceptTree = tree.getSubTree(3);
        if (interceptTree.getSize() == 0) {
            return null;
        }
        Tree t0 = interceptTree.getSubTree(0);
        Tree tt = t0.getSubTree(0);
        String name = tt.toString();
        return name;
    }

    @Override
    public String[] getInterceptorSourceCodeGeneratorNames(ComponentType ct, String ctrlDesc) throws NoSuchControllerDescriptorException {
        Map<String, Tree> context;
        Tree t = this.loader.loadTree(ctrlDesc);
        Tree tree = this.loader.evalTree(t, context = MembraneLoader.getJuliaContextInfo(ct));
        Tree interceptTree = tree.getSubTree(3);
        if (interceptTree.getSize() == 0) {
            return null;
        }
        Tree t0 = interceptTree.getSubTree(0);
        String[] names = new String[t0.getSize() - 1];
        for (int i = 0; i < names.length; ++i) {
            Tree tt = t0.getSubTree(i + 1);
            names[i] = tt.toString();
        }
        return names;
    }

    private Tree[] getCtrlImplTrees(String ctrlDesc, Map<?, ?> context) throws NoSuchControllerDescriptorException {
        Tree t = this.loader.loadTree(ctrlDesc);
        Tree tree = this.loader.evalTree(t, context);
        Tree membraneTree = tree.getSubTree(2);
        Tree[] ctrlTrees = membraneTree.getSubTrees();
        return ctrlTrees;
    }

    private static Map<String, Tree> getJuliaContextInfo(ComponentType ct) {
        HashMap<String, Tree> context = new HashMap<String, Tree>();
        try {
            InterfaceType it = ct.getFcInterfaceType("attribute-controller");
            String signature = it.getFcItfSignature();
            Tree tree = new Tree(new Tree[]{new Tree("attribute-controller"), new Tree(signature)});
            context.put("attributeControllerInterface", tree);
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            // empty catch block
        }
        return context;
    }
}

