/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.desc;

import java.util.List;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.juliac.Juliac;
import org.objectweb.fractal.juliac.desc.ComponentDesc;
import org.objectweb.fractal.juliac.desc.MembraneDesc;
import org.objectweb.fractal.juliac.ucf.UnifiedClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompBasedMembraneDesc
extends MembraneDesc<ComponentDesc> {
    public CompBasedMembraneDesc(String name, String descriptor, InterfaceType[] ctrlItfTypes, ComponentDesc ctrlDescs) {
        super(name, descriptor, ctrlItfTypes, ctrlDescs);
    }

    @Override
    public UnifiedClass getCtrlImpl(String signature, Juliac jc) throws IllegalArgumentException {
        UnifiedClass ctrlItf = jc.create(signature);
        ComponentDesc cdesc = (ComponentDesc)this.getCtrlDescs();
        UnifiedClass uc = this.getCtrlImpl(cdesc, ctrlItf, jc);
        if (uc == null) {
            String msg = "No control component implementing " + signature + " in controller descriptor " + this.getDescriptor();
            throw new IllegalArgumentException(msg);
        }
        return uc;
    }

    private UnifiedClass getCtrlImpl(ComponentDesc cdesc, UnifiedClass ctrlItf, Juliac jc) {
        UnifiedClass uc;
        String contentClassName = cdesc.getContentClassName();
        if (contentClassName != null && ctrlItf.isAssignableFrom(uc = jc.create(contentClassName))) {
            return uc;
        }
        List<ComponentDesc> subs = cdesc.getSubComponents();
        for (ComponentDesc sub : subs) {
            UnifiedClass uc2 = this.getCtrlImpl(sub, ctrlItf, jc);
            if (uc2 == null) continue;
            return uc2;
        }
        return null;
    }
}

