/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.desc;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.api.type.ComponentType;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.julia.type.BasicComponentType;
import org.objectweb.fractal.juliac.Juliac;
import org.objectweb.fractal.juliac.JuliacRuntimeException;
import org.objectweb.fractal.juliac.api.FCSourceCodeGeneratorItf;
import org.objectweb.fractal.juliac.desc.AttributeDesc;
import org.objectweb.fractal.juliac.desc.BindingDesc;
import org.objectweb.fractal.juliac.desc.BindingType;
import org.objectweb.fractal.juliac.opt.InitializerClassGenerator;
import org.objectweb.fractal.juliac.ucf.UnifiedClass;
import org.objectweb.fractal.juliac.ucf.UnifiedMethod;
import org.objectweb.fractal.util.Fractal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentDesc {
    private String id;
    private String name;
    private String definition;
    private Juliac jc;
    private ComponentType ct;
    private String ctrlDesc;
    private String contentClassName;
    private Map<String, AttributeDesc> attributes = new HashMap<String, AttributeDesc>();
    private List<ComponentDesc> superComponents = new ArrayList<ComponentDesc>();
    private List<ComponentDesc> subComponents = new ArrayList<ComponentDesc>();
    private Map<String, BindingDesc> bindings = new HashMap<String, BindingDesc>();
    private List<BindingDesc> lbindings = new ArrayList<BindingDesc>();

    public ComponentDesc(String id, String name, String definition, Juliac jc, ComponentType ct, String ctrlDesc, String contentClassName) {
        this.id = id;
        this.name = name;
        this.definition = definition;
        this.jc = jc;
        this.ct = ct;
        this.ctrlDesc = ctrlDesc;
        this.contentClassName = contentClassName;
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDefinition() {
        return this.definition;
    }

    public ComponentType getCT() {
        return this.ct;
    }

    public String getCtrlDesc() {
        return this.ctrlDesc;
    }

    public String getContentClassName() {
        return this.contentClassName;
    }

    public String toString() {
        return this.id;
    }

    public void addInterfaceTypes(InterfaceType[] its) throws InstantiationException {
        InterfaceType[] currentits = this.ct.getFcInterfaceTypes();
        InterfaceType[] newits = new InterfaceType[currentits.length + its.length];
        System.arraycopy(currentits, 0, newits, 0, currentits.length);
        System.arraycopy(its, 0, newits, currentits.length, its.length);
        this.ct = new BasicComponentType(newits);
    }

    public void putAttribute(String name, AttributeDesc adesc) {
        this.attributes.put(name, adesc);
    }

    public AttributeDesc getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Set<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    public void putBinding(String cltItfName, BindingDesc bdesc) throws IllegalArgumentException {
        String bdescCltItfName = bdesc.getCltItfName();
        if (!cltItfName.equals(bdescCltItfName)) {
            String msg = "cltItfName (" + cltItfName + ") and the value returned by bdesc.getCltItfName (" + bdescCltItfName + ") differ";
            throw new IllegalArgumentException(msg);
        }
        this.bindings.put(cltItfName, bdesc);
        this.lbindings.add(bdesc);
    }

    public BindingDesc getBinding(String cltIftName) {
        BindingDesc bdesc = this.bindings.get(cltIftName);
        return bdesc;
    }

    public Set<String> getBindingCltItfNames() {
        return this.bindings.keySet();
    }

    public List<BindingDesc> getBindingDescs() {
        return this.lbindings;
    }

    public ComponentDesc getBoundComponent(String name) {
        BindingDesc bdesc = this.bindings.get(name);
        if (bdesc == null) {
            return null;
        }
        ComponentDesc cdesc = bdesc.getSrv();
        return cdesc;
    }

    public ComponentDesc getBoundPrimitiveComponent(String name) {
        return this.getBoundComponent(name, "primitive");
    }

    public ComponentDesc getBoundComponent(String name, String ctrlDesc) {
        BindingDesc bdesc = this.bindings.get(name);
        if (bdesc == null) {
            return null;
        }
        String srvItfName = bdesc.getSrvItfName();
        ComponentDesc srv = bdesc.getSrv();
        String srvCtrlDesc = srv.getCtrlDesc();
        if (srvCtrlDesc.equals(ctrlDesc)) {
            return srv;
        }
        ComponentDesc bound = srv.getBoundPrimitiveComponent(srvItfName);
        return bound;
    }

    public List<String> getBoundContentClassNames() {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<ComponentDesc> visited = new ArrayList<ComponentDesc>();
        this.getBoundContentClassNames(names, visited);
        return names;
    }

    private void getBoundContentClassNames(List<String> names, List<ComponentDesc> visited) {
        if (!visited.contains(this)) {
            visited.add(this);
            if (this.contentClassName != null) {
                names.add(this.contentClassName);
            }
            Collection<BindingDesc> bdescs = this.bindings.values();
            for (BindingDesc bdesc : bdescs) {
                ComponentDesc srv = bdesc.getSrv();
                srv.getBoundContentClassNames(names, visited);
            }
        }
    }

    public void addSuperComponent(ComponentDesc parent) {
        this.superComponents.add(parent);
    }

    public void addSubComponent(ComponentDesc sub) {
        this.subComponents.add(sub);
    }

    public List<ComponentDesc> getSuperComponents() {
        return this.superComponents;
    }

    public List<ComponentDesc> getSubComponents() {
        return this.subComponents;
    }

    public void generate(PrintWriter pw, boolean declareLocalVars) {
        this.generateInstantiations(pw, declareLocalVars);
        this.generateHierarchy(pw);
        this.generateBindings(pw);
    }

    protected void generateInstantiations(PrintWriter pw, boolean declareLocalVars) {
        FCSourceCodeGeneratorItf<?> fcscg = this.jc.getFCSourceCodeGenerator(this.ctrlDesc);
        InitializerClassGenerator<?> icg = null;
        try {
            icg = fcscg.generate(this.ct, this.ctrlDesc, this.contentClassName);
        }
        catch (IOException e) {
            throw new JuliacRuntimeException(e);
        }
        String initializerClassName = icg.getTargetClassName();
        if (declareLocalVars) {
            pw.print(Component.class.getName());
            pw.print(" ");
        }
        pw.print(this.id);
        pw.print(" = new ");
        pw.print(initializerClassName);
        pw.println("().newFcInstance();");
        this.generateComponentName(pw);
        this.generateAttributes(pw);
        for (ComponentDesc sub : this.subComponents) {
            sub.generateInstantiations(pw, declareLocalVars);
        }
    }

    protected void generateComponentName(PrintWriter pw) {
        pw.print(Fractal.class.getName());
        pw.print(".getNameController(");
        pw.print(this.id);
        pw.print(").setFcName(\"");
        pw.print(this.name);
        pw.println("\");");
    }

    protected void generateAttributes(PrintWriter pw) {
        for (Map.Entry<String, AttributeDesc> attribute : this.attributes.entrySet()) {
            String name = attribute.getKey();
            AttributeDesc adesc = attribute.getValue();
            String attributeController = adesc.getAttributeController();
            String mname = name.substring(0, 1).toUpperCase() + name.substring(1);
            String settername = "set" + mname;
            String value = adesc.getValue();
            pw.print("((");
            pw.print(attributeController);
            pw.print(")");
            pw.print(Fractal.class.getName());
            pw.print(".getAttributeController(");
            pw.print(this.id);
            pw.print(")).");
            pw.print(settername);
            UnifiedClass atype = this.getAttrType(attributeController, settername);
            String delimiter = atype.getValueDelimiter();
            pw.print("(");
            pw.print(delimiter);
            pw.print(value);
            pw.print(delimiter);
            pw.println(");");
        }
    }

    protected void generateHierarchy(PrintWriter pw) {
        for (ComponentDesc sub : this.subComponents) {
            String subid = sub.getID();
            pw.print(Fractal.class.getName());
            pw.print(".getContentController(");
            pw.print(this.id);
            pw.print(").addFcSubComponent(");
            pw.print(subid);
            pw.println(");");
        }
        for (ComponentDesc sub : this.subComponents) {
            sub.generateHierarchy(pw);
        }
    }

    protected void generateBindings(PrintWriter pw) {
        List<BindingDesc> bdescs = this.lbindings;
        for (BindingDesc bdesc : bdescs) {
            BindingType btype = bdesc.getBindingType();
            String cltItfName = bdesc.getCltItfName();
            String srvItfName = bdesc.getSrvItfName();
            ComponentDesc srv = bdesc.getSrv();
            String srvid = srv.getID();
            pw.print(Fractal.class.getName());
            pw.print(".getBindingController(");
            pw.print(this.id);
            pw.print(").bindFc(\"");
            pw.print(cltItfName);
            pw.print("\",");
            if (btype.equals((Object)BindingType.IMPORT)) {
                pw.print(Fractal.class.getName());
                pw.print(".getContentController(");
                pw.print(srvid);
                pw.print(").getFcInternalInterface(\"");
            } else {
                pw.print(srvid);
                pw.print(".getFcInterface(\"");
            }
            pw.print(srvItfName);
            pw.println("\"));");
        }
        for (ComponentDesc sub : this.subComponents) {
            sub.generateBindings(pw);
        }
    }

    private UnifiedClass getAttrType(String itfName, String setterName) throws JuliacRuntimeException {
        UnifiedClass uc = this.jc.create(itfName);
        UnifiedMethod[] ums = uc.getMethods();
        UnifiedMethod umeth = null;
        for (UnifiedMethod um : ums) {
            String umname = um.getName();
            if (!umname.equals(setterName)) continue;
            umeth = um;
            break;
        }
        if (umeth == null) {
            String msg = "No setter method " + setterName + "in " + itfName;
            throw new JuliacRuntimeException(msg);
        }
        UnifiedClass[] ptypes = umeth.getParameterTypes();
        if (ptypes.length == 0) {
            String msg = "Method " + setterName + " in " + itfName + " is expected to declare at least one parameter";
            throw new JuliacRuntimeException(msg);
        }
        return ptypes[0];
    }
}

