/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.opt;

import java.util.Date;
import org.objectweb.fractal.juliac.api.ClassGeneratorItf;
import org.objectweb.fractal.juliac.visit.ClassSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.FileSourceCodeVisitor;

public abstract class ClassGenerator
implements ClassGeneratorItf {
    public void generate(FileSourceCodeVisitor fv) {
        this.generateFileHeaders(fv);
        String packageName = this.getPackageName();
        if (packageName != null) {
            fv.visitPackageName(packageName);
        }
        this.generateImports(fv);
        ClassSourceCodeVisitor cv = fv.visitPublicClass();
        this.generate(cv);
    }

    public void generate(ClassSourceCodeVisitor cv) {
        int modifiers = this.getClassModifiers();
        String name = this.getClassName();
        String[] genericTypeParameters = this.getClassGenericTypeParameters();
        String superClassName = this.getSuperClassName();
        String[] implementedInterfaceNames = this.getImplementedInterfaceNames();
        cv.visit(modifiers, name, genericTypeParameters, superClassName, implementedInterfaceNames);
        this.generateFields(cv);
        this.generateConstructors(cv);
        this.generateMethods(cv);
        cv.visitEnd();
    }

    public void generateFileHeaders(FileSourceCodeVisitor fv) {
        fv.visitFileHeader("/*");
        fv.visitFileHeader(" * Generated by: " + this.getClass().getName());
        fv.visitFileHeader(" * on: " + new Date().toString());
        fv.visitFileHeader(" */");
    }

    public String getPackageName() {
        String targetclassname = this.getTargetClassName();
        int lastdot = targetclassname.lastIndexOf(46);
        if (lastdot == -1) {
            return null;
        }
        String packagename = targetclassname.substring(0, lastdot);
        return packagename;
    }

    public void generateImports(FileSourceCodeVisitor fv) {
    }

    public int getClassModifiers() {
        return 1;
    }

    public String getClassName() {
        String targetclassname = this.getTargetClassName();
        int lastdot = targetclassname.lastIndexOf(46);
        String shortclassname = targetclassname.substring(lastdot + 1);
        return shortclassname;
    }

    public String[] getClassGenericTypeParameters() {
        return null;
    }

    public String getSuperClassName() {
        return null;
    }

    public String[] getImplementedInterfaceNames() {
        return null;
    }

    public void generateFields(ClassSourceCodeVisitor cv) {
    }

    public void generateConstructors(ClassSourceCodeVisitor cv) {
    }

    public void generateMethods(ClassSourceCodeVisitor cv) {
    }
}

