/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.opt;

import java.io.IOException;
import org.objectweb.fractal.api.Type;
import org.objectweb.fractal.api.control.AttributeController;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.api.type.ComponentType;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.julia.control.attribute.CloneableAttributeController;
import org.objectweb.fractal.julia.type.BasicComponentType;
import org.objectweb.fractal.julia.type.BasicInterfaceType;
import org.objectweb.fractal.juliac.Juliac;
import org.objectweb.fractal.juliac.JuliacRuntimeException;
import org.objectweb.fractal.juliac.Utils;
import org.objectweb.fractal.juliac.api.FCSourceCodeGeneratorItf;
import org.objectweb.fractal.juliac.conf.JuliaLoader;
import org.objectweb.fractal.juliac.conf.JuliacConfig;
import org.objectweb.fractal.juliac.conf.JuliacGeneratorMap;
import org.objectweb.fractal.juliac.conf.JuliacInterceptorSourceCodeGeneratorMap;
import org.objectweb.fractal.juliac.conf.MembraneLoader;
import org.objectweb.fractal.juliac.conf.MembraneLoaderItf;
import org.objectweb.fractal.juliac.desc.MembraneDesc;
import org.objectweb.fractal.juliac.opt.InitializerClassGenerator;
import org.objectweb.fractal.juliac.proxy.AttributeControllerClassGenerator;
import org.objectweb.fractal.juliac.proxy.InterceptorClassGenerator;
import org.objectweb.fractal.juliac.proxy.InterceptorSourceCodeGeneratorItf;
import org.objectweb.fractal.juliac.proxy.InterfaceImplementationClassGenerator;
import org.objectweb.fractal.juliac.proxy.LifeCycleSourceCodeGenerator;
import org.objectweb.fractal.juliac.proxy.ProxyClassGeneratorItf;
import org.objectweb.fractal.juliac.ucf.UnifiedClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FCSourceCodeGenerator<T>
implements FCSourceCodeGeneratorItf<T> {
    protected Juliac jc;
    protected JuliaLoader jloader;
    protected MembraneLoaderItf mloader;
    private boolean initialized = false;

    @Override
    public void init(Juliac jc) throws IOException {
        this.jc = jc;
        JuliacConfig jconf = jc.getJuliacConfig();
        ClassLoader classloader = jconf.getClassLoader();
        this.jloader = new JuliaLoader(classloader);
        this.mloader = new MembraneLoader(this.jloader);
    }

    @Override
    public void postInit() throws IOException {
        if (this.initialized) {
            String msg = this.getClass().getName() + ".init() has already been called";
            throw new JuliacRuntimeException(msg);
        }
        JuliacConfig jconf = this.jc.getJuliacConfig();
        JuliacGeneratorMap<InterceptorClassGenerator> iclgs = jconf.getInterceptorClassGenerators();
        iclgs.put("org.objectweb.fractal.julia.asm.InterceptorClassGenerator", new InterceptorClassGenerator());
        JuliacInterceptorSourceCodeGeneratorMap iscgs = jconf.getInterceptorSourceCodeGenerators();
        iscgs.put("org.objectweb.fractal.julia.asm.LifeCycleCodeGenerator", new LifeCycleSourceCodeGenerator());
        String prop = System.getProperty("julia.config");
        if (prop != null && prop.length() != 0) {
            String[] filenames;
            for (String filename : filenames = prop.split(",")) {
                this.jloader.loadConfigFile(filename);
            }
        }
        this.initialized = true;
    }

    @Override
    public void close(Juliac jc) throws IOException {
    }

    @Override
    public JuliaLoader getJuliaLoader() {
        return this.jloader;
    }

    @Override
    public boolean acceptCtrlDesc(Object controllerDesc) {
        if (!(controllerDesc instanceof String)) {
            return false;
        }
        String ctrlDesc = (String)controllerDesc;
        boolean accept = this.mloader.containsKey(ctrlDesc);
        return accept;
    }

    @Override
    public InitializerClassGenerator<T> generate(Type type, Object controllerDesc, Object contentDesc) throws IOException {
        if (!(type instanceof ComponentType)) {
            String msg = "ComponentType instance expected";
            throw new IllegalArgumentException(msg);
        }
        if (!(controllerDesc instanceof String)) {
            String msg = "controllerDesc should be a String";
            throw new IllegalArgumentException(msg);
        }
        ComponentType ct = (ComponentType)type;
        String ctrlDesc = (String)controllerDesc;
        String contentClassName = Utils.getContentClassName(ctrlDesc, contentDesc);
        MembraneDesc membraneDesc = this.generateMembraneImpl(ct, ctrlDesc, contentClassName);
        InitializerClassGenerator scg = this.generateInitializerImpl(membraneDesc, ct, contentDesc);
        return scg;
    }

    @Override
    public void generateProxiesImpl(String signature, Object controllerDesc) throws IOException {
        if (!(controllerDesc instanceof String)) {
            String msg = "controllerDesc should be a String";
            throw new IllegalArgumentException(msg);
        }
        String ctrlDesc = (String)controllerDesc;
        InterfaceType[] its = new InterfaceType[]{new BasicInterfaceType("none", signature, false, false, false)};
        BasicComponentType ct = null;
        try {
            ct = new BasicComponentType(its);
        }
        catch (InstantiationException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        this.generateMembraneImpl(ct, ctrlDesc, null);
    }

    @Override
    public ProxyClassGeneratorItf getInterfaceClassGenerator(InterfaceType it, MembraneDesc<?> membraneDesc) {
        return new InterfaceImplementationClassGenerator(it, membraneDesc, false, this.jc);
    }

    protected ProxyClassGeneratorItf getInterceptorClassGenerator(ComponentType ct, String ctrldesc) throws IOException {
        boolean mergeable = false;
        InterceptorSourceCodeGeneratorItf[] scgs = this.getInterceptorSourceCodeGenerators(ct, ctrldesc, mergeable, this.jc);
        if (scgs == null) {
            return null;
        }
        ProxyClassGeneratorItf icg = this.getInterceptorClassGenerator(ct, ctrldesc, scgs);
        return icg;
    }

    protected ProxyClassGeneratorItf getInterceptorClassGenerator(ComponentType ct, String ctrldesc, InterceptorSourceCodeGeneratorItf[] iscgs) throws IOException {
        JuliacConfig jconf = this.jc.getJuliacConfig();
        String asm = this.mloader.getInterceptorClassGeneratorName(ct, ctrldesc);
        JuliacGeneratorMap<InterceptorClassGenerator> iclgs = jconf.getInterceptorClassGenerators();
        InterceptorClassGenerator icg = null;
        if (iclgs.containsKey(asm)) {
            icg = (InterceptorClassGenerator)iclgs.get(asm);
        } else {
            try {
                icg = iclgs.load(asm, asm);
            }
            catch (ClassNotFoundException cnfe) {
                IOException ioe = new IOException();
                ioe.initCause(cnfe);
                throw ioe;
            }
        }
        icg.init(iscgs);
        icg.setJuliac(this.jc);
        return icg;
    }

    public InterceptorSourceCodeGeneratorItf[] getInterceptorSourceCodeGenerators(ComponentType ct, String ctrldesc, boolean mergeable, Juliac jc) throws IOException {
        String[] asms = this.mloader.getInterceptorSourceCodeGeneratorNames(ct, ctrldesc);
        if (asms == null) {
            return null;
        }
        JuliacConfig jconf = jc.getJuliacConfig();
        JuliacInterceptorSourceCodeGeneratorMap jiscgm = jconf.getInterceptorSourceCodeGenerators();
        return jiscgm.get(asms, mergeable, jc);
    }

    protected abstract InitializerClassGenerator<T> getInitializerClassGenerator();

    protected InitializerClassGenerator<T> generateInitializerImpl(MembraneDesc<T> membraneDesc, ComponentType ct, Object contentDesc) throws IOException {
        InitializerClassGenerator<T> scg = this.getInitializerClassGenerator();
        scg.init(this.jc, this, membraneDesc, ct, contentDesc);
        this.jc.generateSourceCode(scg);
        return scg;
    }

    protected void generateInterfaceImpl(InterfaceType[] its, String ctrlDesc) throws IOException {
        for (InterfaceType it : its) {
            this.generateInterfaceImpl(it, ctrlDesc);
            InterfaceType internalit = Utils.newSymetricInterfaceType(it);
            this.generateInterfaceImpl(internalit, ctrlDesc);
        }
    }

    protected void generateInterfaceImpl(InterfaceType it, String ctrlDesc) throws IOException {
        String signature = it.getFcItfSignature();
        UnifiedClass cl = this.jc.create(signature);
        UnifiedClass ac = this.jc.create(AttributeController.class.getName());
        UnifiedClass cac = this.jc.create(CloneableAttributeController.class.getName());
        if (ac.isAssignableFrom(cl) && !cac.isAssignableFrom(cl)) {
            AttributeControllerClassGenerator ascg = new AttributeControllerClassGenerator(it, null, false, this.jc);
            this.jc.generateSourceCode(ascg);
        }
        ProxyClassGeneratorItf iscg = this.getInterfaceClassGenerator(it, null);
        this.jc.generateSourceCode(iscg);
    }

    protected void generateInterceptorImpl(InterfaceType[] its, MembraneDesc<?> membraneDesc) throws IOException {
        ProxyClassGeneratorItf iscg = membraneDesc.getInterceptorClassGenerator();
        if (iscg == null) {
            return;
        }
        iscg.setMembraneDesc(membraneDesc);
        for (InterfaceType it : its) {
            this.generateInterceptorImpl(it, iscg);
        }
    }

    protected void generateInterceptorImpl(InterfaceType it, ProxyClassGeneratorItf iscg) throws IOException {
        iscg.setInterfaceType(it);
        if (iscg.match()) {
            this.jc.generateSourceCode(iscg);
        }
    }
}

