/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.opt;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Type;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.api.type.ComponentType;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.julia.Interceptor;
import org.objectweb.fractal.juliac.Juliac;
import org.objectweb.fractal.juliac.Utils;
import org.objectweb.fractal.juliac.api.FCSourceCodeGeneratorItf;
import org.objectweb.fractal.juliac.desc.MembraneDesc;
import org.objectweb.fractal.juliac.opt.ClassGenerator;
import org.objectweb.fractal.juliac.proxy.ProxyClassGeneratorItf;
import org.objectweb.fractal.juliac.visit.BlockSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.CatchSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.ClassSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.ThenSourceCodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitializerClassGenerator<T>
extends ClassGenerator {
    protected Juliac jc;
    protected FCSourceCodeGeneratorItf<T> fcscg;
    protected MembraneDesc<T> membraneDesc;
    protected ComponentType ct;
    protected Object contentDesc;

    public void init(Juliac jc, FCSourceCodeGeneratorItf<T> fcscg, MembraneDesc<T> membraneDesc, ComponentType ct, Object contentDesc) {
        this.jc = jc;
        this.fcscg = fcscg;
        this.membraneDesc = membraneDesc;
        this.ct = ct;
        this.contentDesc = contentDesc;
    }

    protected MembraneDesc<T> getMembraneDesc() {
        return this.membraneDesc;
    }

    @Override
    public String[] getImplementedInterfaceNames() {
        return new String[]{"org.objectweb.fractal.juliac.runtime.Factory"};
    }

    @Override
    public void generateMethods(ClassSourceCodeVisitor cv) {
        this.generateGetFcInstanceTypeMethod(cv);
        this.generateGetFcControllerDescMethod(cv);
        this.generateGetFcContentDescMethod(cv);
        this.generateNewFcContentMethod(cv);
        this.generateNewFcInstanceMethod(cv);
        this.generateNewFcInstanceContentMethod(cv);
        this.generateExtraCode(cv);
    }

    @Override
    public String getTargetClassName() {
        String ctrlDesc = this.membraneDesc.getDescriptor();
        String contentClassName = Utils.getContentClassName(ctrlDesc, this.contentDesc);
        String membraneClassName = this.getMembraneClassName(ctrlDesc, contentClassName);
        String hexhashct = Utils.hexhash(this.ct);
        String initializerClassName = membraneClassName + "FC" + hexhashct;
        return initializerClassName;
    }

    public String getMembraneClassName(Object ctrlDesc, String contentClassName) throws IllegalArgumentException {
        if (!(ctrlDesc instanceof String)) {
            String msg = "ctrlDesc should be a String";
            throw new IllegalArgumentException(msg);
        }
        String ctrlDescStr = ((String)ctrlDesc).replace('/', '_');
        String membraneClassName = contentClassName == null ? Utils.getJuliacGeneratedStrongTypeName(ctrlDescStr) : contentClassName + "FC" + ctrlDescStr;
        String rootedMembraneClassName = this.jc.getRootedClassName(membraneClassName);
        return rootedMembraneClassName;
    }

    protected void generateGetFcInstanceTypeMethod(ClassSourceCodeVisitor cv) {
        BlockSourceCodeVisitor mv = cv.visitMethod(1, null, Type.class.getName(), "getFcInstanceType", null, null);
        this.generateGetFcInstanceTypeMethod(mv);
        mv.visitEnd();
    }

    protected void generateGetFcInstanceTypeMethod(BlockSourceCodeVisitor mv) {
        CatchSourceCodeVisitor cv = mv.visitTry();
        cv.visitIns("return", Utils.javaify(this.ct).toString());
        cv = cv.visitCatch(InstantiationException.class, "ie");
        cv.visitIns("throw", "new", "org.objectweb.fractal.juliac.runtime.RuntimeException(ie)");
        cv.visitEnd();
    }

    protected void generateGetFcControllerDescMethod(ClassSourceCodeVisitor cv) {
        BlockSourceCodeVisitor mv = cv.visitMethod(1, null, "Object", "getFcControllerDesc", null, null);
        this.generateGetFcControllerDescMethod(mv);
        mv.visitEnd();
    }

    protected void generateGetFcControllerDescMethod(BlockSourceCodeVisitor mv) {
        mv.visitIns("throw", "new", "UnsupportedOperationException()");
    }

    protected void generateGetFcContentDescMethod(ClassSourceCodeVisitor cv) {
        BlockSourceCodeVisitor mv = cv.visitMethod(1, null, "Object", "getFcContentDesc", null, null);
        this.generateGetFcContentDescMethod(mv);
        mv.visitEnd();
    }

    protected void generateGetFcContentDescMethod(BlockSourceCodeVisitor mv) {
        mv.visitIns("throw", "new", "UnsupportedOperationException()");
    }

    protected void generateNewFcContentMethod(ClassSourceCodeVisitor cv) {
        BlockSourceCodeVisitor mv = cv.visitMethod(1, null, "Object", "newFcContent", null, new String[]{InstantiationException.class.getName()});
        this.generateNewFcContentMethod(mv);
        mv.visitEnd();
    }

    protected void generateNewFcContentMethod(BlockSourceCodeVisitor mv) {
        mv.visitIns("throw", "new", "UnsupportedOperationException()");
    }

    protected void generateNewFcInstanceMethod(ClassSourceCodeVisitor cv) {
        BlockSourceCodeVisitor mv = cv.visitMethod(1, null, Component.class.getName(), "newFcInstance", null, new String[]{InstantiationException.class.getName()});
        this.generateNewFcInstanceMethod(mv);
        mv.visitEnd();
    }

    protected void generateNewFcInstanceMethod(BlockSourceCodeVisitor mv) {
        mv.visitIns("throw", "new", "UnsupportedOperationException()");
    }

    protected void generateNewFcInstanceContentMethod(ClassSourceCodeVisitor cv) {
        BlockSourceCodeVisitor mv = cv.visitMethod(1, null, Component.class.getName(), "newFcInstance", new String[]{"Object content"}, new String[]{InstantiationException.class.getName()});
        this.generateNewFcInstanceContentMethod(mv);
        mv.visitEnd();
    }

    protected void generateNewFcInstanceContentMethod(BlockSourceCodeVisitor mv) {
        mv.visitIns("throw", "new", "UnsupportedOperationException()");
    }

    protected void generateExtraCode(ClassSourceCodeVisitor cv) {
    }

    protected void generateContentChecks(BlockSourceCodeVisitor mv) {
        String ctrlDesc = this.membraneDesc.getDescriptor();
        String contentClassName = Utils.getContentClassName(ctrlDesc, this.contentDesc);
        if (contentClassName != null) {
            boolean checkForBC = false;
            InterfaceType[] its = this.ct.getFcInterfaceTypes();
            for (int i = 0; i < its.length; ++i) {
                if (its[i].isFcClientItf()) {
                    checkForBC = true;
                    continue;
                }
                String signature = its[i].getFcItfSignature();
                ThenSourceCodeVisitor then = mv.visitIf("content!=null", "&&", "!(content", "instanceof", signature + ")");
                then.visitVar("String", "msg", "\"" + contentClassName, "should implement", signature + "\"");
                then.visitIns("throw", "new", InstantiationException.class.getName() + "(msg)").visitEnd();
            }
            if (checkForBC) {
                this.generateContentCheckForBC(mv);
            }
        }
    }

    protected void generateContentCheckForBC(BlockSourceCodeVisitor mv) {
        String ctrlDesc = this.membraneDesc.getDescriptor();
        String contentClassName = Utils.getContentClassName(ctrlDesc, this.contentDesc);
        ThenSourceCodeVisitor then = mv.visitIf("content!=null", "&&", "!(content", "instanceof", BindingController.class.getName() + ")");
        then.visitVar("String", "msg", "\"" + contentClassName, "should implement", BindingController.class.getName() + "\"");
        then.visitIns("throw", "new", InstantiationException.class.getName() + "(msg)").visitEnd();
    }

    protected void generateInitializationContextForContent(BlockSourceCodeVisitor mv) {
        String ctrlDesc = this.membraneDesc.getDescriptor();
        mv.visitIns("ic.interfaces.put(\"/content\",content)");
        mv.visitIns("ic.interfaces.put(\"/controllerDesc\",\"" + ctrlDesc + "\")");
        if (ctrlDesc.endsWith("Template")) {
            mv.visitSet("ic.content", Utils.javaifyContentDesc(this.contentDesc).toString());
        } else {
            mv.visitSet("ic.content", "content");
        }
    }

    public boolean generateInterceptorCreation(BlockSourceCodeVisitor mv, InterfaceType it, String delegate) {
        ProxyClassGeneratorItf scg = this.membraneDesc.getInterceptorClassGenerator();
        if (scg == null) {
            return false;
        }
        scg.setInterfaceType(it);
        scg.setMembraneDesc(this.membraneDesc);
        if (!scg.match()) {
            return false;
        }
        String name = scg.getTargetClassName();
        mv.visitSet("intercept", "new", name + "()");
        mv.visitIns("ic.controllers.add(intercept)");
        if (!it.isFcClientItf()) {
            mv.visitIns("((" + Interceptor.class.getName() + ")intercept).setFcItfDelegate(" + delegate + ")");
        }
        return true;
    }
}

