/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.opt.oo;

import java.io.IOException;
import java.util.List;
import org.objectweb.fractal.api.type.ComponentType;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.juliac.Utils;
import org.objectweb.fractal.juliac.api.SpoonSupportItf;
import org.objectweb.fractal.juliac.desc.ControllerDesc;
import org.objectweb.fractal.juliac.desc.MembraneDesc;
import org.objectweb.fractal.juliac.desc.SimpleMembraneDesc;
import org.objectweb.fractal.juliac.opt.FCSourceCodeGenerator;
import org.objectweb.fractal.juliac.opt.oo.InitializerOOCtrlClassGenerator;
import org.objectweb.fractal.juliac.opt.oo.MembraneInitializerOOCtrlClassGenerator;
import org.objectweb.fractal.juliac.proxy.ProxyClassGeneratorItf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FCOOCtrlSourceCodeGenerator
extends FCSourceCodeGenerator<List<ControllerDesc>> {
    @Override
    public void postInit() throws IOException {
        this.jloader.loadConfigFile("julia-bundled.cfg");
        super.postInit();
    }

    @Override
    public MembraneDesc<List<ControllerDesc>> generateMembraneImpl(ComponentType ct, String ctrldesc, String contentClassName) throws IOException {
        InterfaceType[] its = ct.getFcInterfaceTypes();
        this.generateInterfaceImpl(its, ctrldesc);
        InterfaceType[] membraneits = this.mloader.getMembraneType(ct, ctrldesc);
        this.generateInterfaceImpl(membraneits, ctrldesc);
        List<ControllerDesc> ctrlDescs = this.mloader.getCtrlImplLayers(ct, ctrldesc);
        for (ControllerDesc ctrlDesc : ctrlDescs) {
            List<String> ctrlImplLayers = ctrlDesc.getLayerImplNames();
            String ctrlImplClassName = ctrlDesc.getImplName();
            if (ctrlImplClassName.startsWith("(") || ctrlImplLayers == null) continue;
            ctrlImplClassName = Utils.getJuliacGeneratedStrongTypeName(ctrlImplClassName);
            ctrlImplClassName = this.jc.getRootedClassName(ctrlImplClassName);
            ctrlDesc.setImplName(ctrlImplClassName);
            if (this.jc.hasBeenGenerated(ctrlImplClassName)) continue;
            SpoonSupportItf spoon = this.jc.getSpoon();
            spoon.mixAndGenerate(ctrlImplClassName, ctrlImplLayers);
        }
        SimpleMembraneDesc md = new SimpleMembraneDesc(null, ctrldesc, membraneits, ctrlDescs);
        ProxyClassGeneratorItf icg = this.getInterceptorClassGenerator(ct, ctrldesc);
        md.setInterceptorClassGenerator(icg);
        this.generateInterceptorImpl(its, md);
        this.generateInterceptorImpl(membraneits, md);
        this.generateMembraneInitializer(md);
        return md;
    }

    public InitializerOOCtrlClassGenerator getInitializerClassGenerator() {
        return new InitializerOOCtrlClassGenerator();
    }

    private void generateMembraneInitializer(MembraneDesc<List<ControllerDesc>> membraneDesc) throws IOException {
        InitializerOOCtrlClassGenerator icg = this.getInitializerClassGenerator();
        icg.init(this.jc, this, membraneDesc, null, null);
        MembraneInitializerOOCtrlClassGenerator micg = icg.getMembraneInitializerClassGenerator();
        this.jc.generateSourceCode(micg);
    }
}

