/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.opt.oo;

import java.util.List;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.julia.InitializationContext;
import org.objectweb.fractal.julia.factory.ChainedInstantiationException;
import org.objectweb.fractal.juliac.JuliacRuntimeException;
import org.objectweb.fractal.juliac.Utils;
import org.objectweb.fractal.juliac.desc.ControllerDesc;
import org.objectweb.fractal.juliac.desc.MembraneDesc;
import org.objectweb.fractal.juliac.opt.InitializerClassGenerator;
import org.objectweb.fractal.juliac.opt.oo.MembraneInitializerOOCtrlClassGenerator;
import org.objectweb.fractal.juliac.proxy.AttributeControllerClassGenerator;
import org.objectweb.fractal.juliac.proxy.ProxyClassGeneratorItf;
import org.objectweb.fractal.juliac.visit.BlockSourceCodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitializerOOCtrlClassGenerator
extends InitializerClassGenerator<List<ControllerDesc>> {
    @Override
    public String getSuperClassName() {
        MembraneInitializerOOCtrlClassGenerator micg = this.getMembraneInitializerClassGenerator();
        String name = micg.getTargetClassName();
        return name;
    }

    @Override
    protected void generateGetFcControllerDescMethod(BlockSourceCodeVisitor mv) {
        mv.visit("      return \"");
        MembraneDesc membraneDesc = this.getMembraneDesc();
        mv.visit(membraneDesc.getDescriptor());
        mv.visitln("\";");
    }

    @Override
    protected void generateGetFcContentDescMethod(BlockSourceCodeVisitor mv) {
        mv.visit("      return ");
        mv.visit(Utils.javaifyContentDesc(this.contentDesc).toString());
        mv.visitln(";");
    }

    @Override
    protected void generateNewFcContentMethod(BlockSourceCodeVisitor mv) {
        MembraneDesc membraneDesc = this.getMembraneDesc();
        String ctrlDesc = membraneDesc.getDescriptor();
        String contentClassName = Utils.getContentClassName(ctrlDesc, this.contentDesc);
        if (contentClassName == null) {
            mv.visitln("    return null;");
        } else {
            mv.visitln("    try {");
            mv.visit("      Object content = new ");
            mv.visit(contentClassName);
            mv.visitln("();");
            mv.visitln("      return content;");
            mv.visitln("    }");
            mv.visitln("    catch( Throwable t ) {");
            mv.visit("      throw new ");
            mv.visit(ChainedInstantiationException.class.getName());
            mv.visitln("(t,null,\"\");");
            mv.visitln("    }");
        }
    }

    @Override
    protected void generateNewFcInstanceMethod(BlockSourceCodeVisitor mv) {
        mv.visitln("    Object content = newFcContent();");
        mv.visitln("    return newFcInstance(content);");
    }

    @Override
    protected void generateNewFcInstanceContentMethod(BlockSourceCodeVisitor mv) {
        MembraneDesc membraneDesc = this.getMembraneDesc();
        InterfaceType[] membraneits = membraneDesc.getCtrlItfTypes();
        boolean isComposite = Utils.isComposite(membraneits);
        this.generateContentChecks(mv);
        mv.visitln("    " + InitializationContext.class.getName() + " ic = newFcInitializationContext(content);");
        this.generateInitializationContextForContent(mv);
        mv.visitln("    " + Interface.class.getName() + " proxy;");
        mv.visitln("    Object intercept;");
        mv.visitln("    " + Component.class.getName() + " proxyForCompCtrl = (" + Component.class.getName() + ") ic.interfaces.get(\"component\");");
        boolean attrimplgenerated = false;
        for (int i = 1; i < membraneits.length; ++i) {
            String itname = membraneits[i].getFcItfName();
            if (!itname.equals("/cloneable-attribute-controller")) continue;
            this.generateNFCICMControlInterfaceCAC(mv, membraneits[i]);
            attrimplgenerated = true;
        }
        InterfaceType[] its = this.ct.getFcInterfaceTypes();
        InterfaceType[] fullits = new InterfaceType[membraneits.length + its.length];
        System.arraycopy(membraneits, 0, fullits, 0, membraneits.length);
        System.arraycopy(its, 0, fullits, membraneits.length, its.length);
        mv.visitln("    ic.type = " + Utils.javaify(fullits) + ";");
        for (int i = 0; i < its.length; ++i) {
            String itname = its[i].getFcItfName();
            if (its[i].isFcCollectionItf()) {
                itname = "/collection/" + itname;
            }
            if (!this.generateInterceptorCreation(mv, its[i], "content")) {
                mv.visit("    intercept = ");
                mv.visit(its[i].isFcClientItf() ? "null" : "content");
                mv.visitln(";");
            }
            this.generateNFICMExternalInterface(mv, its[i], attrimplgenerated);
            if (itname.equals("attribute-controller") || !isComposite) continue;
            InterfaceType intit = Utils.newSymetricInterfaceType(its[i]);
            ProxyClassGeneratorItf itfscg = this.fcscg.getInterfaceClassGenerator(intit, membraneDesc);
            String fcitfClassname = itfscg.getTargetClassName();
            String itstring = Utils.javaify(intit).toString();
            mv.visit("    proxy = ");
            mv.visit("new " + fcitfClassname + "(");
            mv.visit("proxyForCompCtrl,\"" + itname + "\"," + itstring);
            mv.visitln(",true,intercept);");
            mv.visitln("    ic.internalInterfaces.put(\"" + itname + "\",proxy);");
        }
        mv.visitln("    initFcController(ic);");
        mv.visitln("    return proxyForCompCtrl;");
    }

    private void generateNFCICMControlInterfaceCAC(BlockSourceCodeVisitor mv, InterfaceType membraneit) {
        String itname = membraneit.getFcItfName();
        ProxyClassGeneratorItf itfscg = this.fcscg.getInterfaceClassGenerator(membraneit, this.membraneDesc);
        String fcitfClassname = itfscg.getTargetClassName();
        String itstring = Utils.javaify(membraneit).toString();
        InterfaceType attrit = null;
        try {
            attrit = this.ct.getFcInterfaceType("attribute-controller");
        }
        catch (NoSuchInterfaceException e) {
            throw new JuliacRuntimeException(e);
        }
        AttributeControllerClassGenerator attrscg = new AttributeControllerClassGenerator(attrit, null, false, this.jc);
        String s = attrscg.getTargetClassName();
        mv.visitIns("Object attrimpl = new ", s, "()");
        mv.visitIns("proxy = ", "new ", fcitfClassname, "(", "proxyForCompCtrl,\"" + itname + "\",", itstring, ",false,attrimpl)");
        mv.visitIns("ic.interfaces.put(\"" + itname + "\",proxy)");
    }

    protected void generateNFICMExternalInterface(BlockSourceCodeVisitor mv, InterfaceType it, boolean attrimplgenerated) {
        String itname = it.getFcItfName();
        if (it.isFcCollectionItf()) {
            itname = "/collection/" + itname;
        }
        MembraneDesc membraneDesc = this.getMembraneDesc();
        ProxyClassGeneratorItf itfscg = this.fcscg.getInterfaceClassGenerator(it, membraneDesc);
        String fcitfClassname = itfscg.getTargetClassName();
        String itstring = Utils.javaify(it).toString();
        mv.visit("    proxy = ");
        mv.visit("new " + fcitfClassname + "(");
        mv.visit("proxyForCompCtrl,\"" + itname + "\"," + itstring + ",false,");
        if (itname.equals("attribute-controller") && attrimplgenerated) {
            mv.visit("attrimpl");
        } else {
            mv.visit("intercept");
        }
        mv.visitln(");");
        mv.visitln("    ic.interfaces.put(\"" + itname + "\",proxy);");
    }

    protected MembraneInitializerOOCtrlClassGenerator getMembraneInitializerClassGenerator() {
        MembraneInitializerOOCtrlClassGenerator micg = new MembraneInitializerOOCtrlClassGenerator(this.jc, this.fcscg, this, this.membraneDesc, this.ct, this.contentDesc);
        return micg;
    }
}

