/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.opt.oo;

import java.util.HashMap;
import java.util.List;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.api.type.ComponentType;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.julia.InitializationContext;
import org.objectweb.fractal.julia.factory.ChainedInstantiationException;
import org.objectweb.fractal.julia.loader.Initializable;
import org.objectweb.fractal.julia.loader.Tree;
import org.objectweb.fractal.julia.type.BasicInterfaceType;
import org.objectweb.fractal.juliac.Juliac;
import org.objectweb.fractal.juliac.Utils;
import org.objectweb.fractal.juliac.api.FCSourceCodeGeneratorItf;
import org.objectweb.fractal.juliac.desc.ControllerDesc;
import org.objectweb.fractal.juliac.desc.MembraneDesc;
import org.objectweb.fractal.juliac.opt.ClassGenerator;
import org.objectweb.fractal.juliac.opt.oo.InitializerOOCtrlClassGenerator;
import org.objectweb.fractal.juliac.proxy.ProxyClassGeneratorItf;
import org.objectweb.fractal.juliac.ucf.UnifiedClass;
import org.objectweb.fractal.juliac.visit.BlockSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.ClassSourceCodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MembraneInitializerOOCtrlClassGenerator
extends ClassGenerator {
    protected Juliac jc;
    protected FCSourceCodeGeneratorItf<List<ControllerDesc>> fcscg;
    protected MembraneDesc<List<ControllerDesc>> membraneDesc;
    protected InitializerOOCtrlClassGenerator icg;
    protected ComponentType ct;
    protected Object contentDesc;

    public MembraneInitializerOOCtrlClassGenerator(Juliac jc, FCSourceCodeGeneratorItf<List<ControllerDesc>> fcscg, InitializerOOCtrlClassGenerator icg, MembraneDesc<List<ControllerDesc>> membraneDesc, ComponentType ct, Object contentDesc) {
        this.jc = jc;
        this.fcscg = fcscg;
        this.icg = icg;
        this.membraneDesc = membraneDesc;
        this.ct = ct;
        this.contentDesc = contentDesc;
    }

    @Override
    public String getTargetClassName() {
        String ctrlDesc = this.membraneDesc.getDescriptor();
        String strong = Utils.getJuliacGeneratedStrongTypeName(ctrlDesc);
        String rooted = this.jc.getRootedClassName(strong);
        return rooted;
    }

    @Override
    public String getSuperClassName() {
        return "org.objectweb.fractal.juliac.runtime.MembraneInitializer";
    }

    @Override
    public void generateMethods(ClassSourceCodeVisitor cv) {
        this.generateNewFcInitializationContextMethod(cv);
        this.generateNewFcControllerInstantiationMethod(cv);
    }

    protected void generateNewFcInitializationContextMethod(ClassSourceCodeVisitor cv) {
        BlockSourceCodeVisitor mv = cv.visitMethod(1, null, InitializationContext.class.getName(), "newFcInitializationContext", new String[]{"Object content"}, new String[]{InstantiationException.class.getName()});
        this.generateNewFcInitializationContextMethod(mv);
        mv.visitEnd();
    }

    protected void generateNewFcInitializationContextMethod(BlockSourceCodeVisitor mv) {
        InterfaceType[] membraneits = this.membraneDesc.getCtrlItfTypes();
        List<ControllerDesc> ctrlDescs = this.membraneDesc.getCtrlDescs();
        boolean isComposite = Utils.isComposite(membraneits);
        mv.visitln("    " + InitializationContext.class.getName() + " ic = initFcInitializationContext();");
        if (isComposite) {
            mv.visitln("    ic.internalInterfaces = new " + HashMap.class.getName() + "();");
        }
        mv.visitln("    " + Component.class.getName() + " compctrl = newFcControllerInstantiation(ic);");
        BasicInterfaceType compctrlit = new BasicInterfaceType("component", Component.class.getName(), false, false, false);
        mv.visitln("    Object intercept = null;");
        if (!this.icg.generateInterceptorCreation(mv, compctrlit, "compctrl")) {
            mv.visitln("    intercept = compctrl;");
        }
        ProxyClassGeneratorItf itfscg = this.fcscg.getInterfaceClassGenerator(compctrlit, this.membraneDesc);
        String fcitfClassname = itfscg.getTargetClassName();
        this.generateNCICMProxyCreation(mv, true, fcitfClassname, "compctrl", "component", compctrlit);
        mv.visit("    " + Component.class.getName() + " proxyForCompCtrl = ");
        mv.visitln("(" + Component.class.getName() + ") proxy;");
        mv.visitln("    Object ctrl = null;");
        for (int i = 0; i < membraneits.length; ++i) {
            InterfaceType membraneit = membraneits[i];
            String itname = membraneit.getFcItfName();
            if (itname.equals("component") || itname.equals("/cloneable-attribute-controller")) continue;
            mv.visitln("    for( int i=0 ; i < ic.controllers.size() ; i++ ) {");
            mv.visitln("      ctrl = ic.controllers.get(i);");
            mv.visitln("      if( ctrl instanceof " + membraneit.getFcItfSignature() + " ) {");
            mv.visitln("        break;");
            mv.visitln("      }");
            mv.visitln("      ctrl = null;");
            mv.visitln("    }");
            mv.visitln("    if( ctrl == null ) {");
            mv.visitln("      if( content instanceof " + membraneit.getFcItfSignature() + ") {");
            mv.visitln("        ctrl = content;");
            mv.visitln("      }");
            mv.visitln("      else {");
            mv.visitln("        throw new " + InstantiationException.class.getName() + "(\"No such controller implementing " + membraneit.getFcItfSignature() + "\");");
            mv.visitln("      }");
            mv.visitln("    }");
            if (!this.icg.generateInterceptorCreation(mv, membraneit, "ctrl")) {
                mv.visitln("    intercept = ctrl;");
            }
            itfscg = this.fcscg.getInterfaceClassGenerator(membraneit, this.membraneDesc);
            fcitfClassname = itfscg.getTargetClassName();
            this.generateNCICMProxyCreation(mv, false, fcitfClassname, "proxyForCompCtrl", itname, membraneit);
            if (!itname.equals("factory") || !isComposite) continue;
            InterfaceType intit = Utils.newSymetricInterfaceType(membraneit);
            itfscg = this.fcscg.getInterfaceClassGenerator(intit, this.membraneDesc);
            fcitfClassname = itfscg.getTargetClassName();
            String itstring = Utils.javaify(intit).toString();
            mv.visit("    proxy = ");
            mv.visit("new " + fcitfClassname + "(");
            mv.visit("proxyForCompCtrl,\"" + itname + "\"," + itstring);
            mv.visitln(",true,intercept);");
            mv.visitln("    ic.internalInterfaces.put(\"" + itname + "\",proxy);");
        }
        mv.visitln("    return ic;");
    }

    protected void generateNewFcControllerInstantiationMethod(ClassSourceCodeVisitor cv) {
        BlockSourceCodeVisitor mv = cv.visitMethod(1, null, Component.class.getName(), "newFcControllerInstantiation", new String[]{InitializationContext.class.getName() + " ic"}, new String[]{InstantiationException.class.getName()});
        this.generateNewFcControllerInstantiationMethod(mv);
        mv.visitEnd();
    }

    protected void generateNewFcControllerInstantiationMethod(BlockSourceCodeVisitor mv) {
        List<ControllerDesc> ctrlDescs = this.membraneDesc.getCtrlDescs();
        UnifiedClass ucinitializable = this.jc.create(Initializable.class.getName());
        UnifiedClass uccomponent = this.jc.create(Component.class.getName());
        mv.visitln("    Object ctrl = null;");
        for (ControllerDesc ctrlDesc : ctrlDescs) {
            Tree tree;
            String ctrlImplName = ctrlDesc.getImplName();
            if (ctrlImplName.charAt(0) == '(') continue;
            mv.visitln("    ic.controllers.add(ctrl = new " + ctrlImplName + "());");
            UnifiedClass uc = this.jc.create(ctrlImplName);
            if (ucinitializable.isAssignableFrom(uc) && (tree = ctrlDesc.getTree()) != null) {
                mv.visitln("    " + Tree.class.getName() + " tree = " + Utils.javaify(tree) + ';');
                mv.visitln("    try {");
                mv.visitln("      ((" + Initializable.class.getName() + ")ctrl).initialize(tree);");
                mv.visitln("    }");
                mv.visitln("    catch( Exception e ) {");
                mv.visitln("      throw new " + ChainedInstantiationException.class.getName() + "(e,null,\"\");");
                mv.visitln("    }");
            }
            if (!uccomponent.isAssignableFrom(uc)) continue;
            mv.visitln("    " + Component.class.getName() + " compctrl = (" + Component.class.getName() + ")ctrl;");
        }
        mv.visitln("    return compctrl;");
    }

    protected void generateNCICMProxyCreation(BlockSourceCodeVisitor mv, boolean typedef, String fcitfClassname, String delegate, String itname, InterfaceType it) {
        String itstring = Utils.javaify(it).toString();
        mv.visitIns(typedef ? Interface.class.getName() : "", " proxy = ", "new ", fcitfClassname, "(", delegate, ",\"" + itname + "\",", itstring, ",false,intercept)");
        mv.visitIns("ic.interfaces.put(\"" + itname + "\",proxy);");
    }
}

